// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>


#include <Common/Base/Types/Geometry/Aabb24_16_24/hkAabb24_16_24_Codec.h>
#include <Common/Base/Algorithm/PseudoRandom/hkPseudoRandomGenerator.h>
#include <Common/Internal/GeometryProcessing/hkGeometryProcessing.h>

template <typename CODEC, typename AABB>
static void compressedAabbCodecTest( bool checkAny )
{
#if 0 
    hkVector4       aabbMaxSize; aabbMaxSize.setAll( hkReal( 1 ) );

    hkReal domainSize = 4.0f;
    hkReal domainSizePower2 = 4.0f;
    for ( int i = 0; i < 40; i++ )
    {
        hkReal effectiveSize;
        if ( i & 1 )
        {
            effectiveSize = domainSize;
            domainSize *= 1.6f;
            if ( !checkAny )
            {
                continue; // 16 bit aabb does not support any size, but its not really a problem since floating point accuracy is so much higher than 15bit
            }
        }
        else
        {
            effectiveSize = domainSizePower2;
            domainSizePower2 *= 2.0f;
        }
        hkAabb      domain; domain.setFromCenterRadius( hkVector4::getZero(), hkSimdReal::fromFloat( effectiveSize / 2 ) );

        CODEC   codec; codec.set( domain );

        domain.m_min *= hkSimdReal::fromFloat(.9999f);      // shrink the domain a little bit because border will be clipped
        domain.m_max *= hkSimdReal::fromFloat(.9999f);

        hkVector4   domainExtent; domainExtent.setSub( domain.m_max, domain.m_min );
        hkGeometryProcessing::Prng  prng;

        const int   numAabbToSample = 10000;
        for ( int i = 0; i < numAabbToSample; ++i )
        {
            hkVector4   positionT; prng.nextVector<3>( positionT );
            hkVector4   sizeT; prng.nextVector<3>( sizeT );

            hkAabb      baseAabb;
            baseAabb.m_min.setAddMul( domain.m_min, domainExtent, positionT );
            baseAabb.m_max.setAddMul( baseAabb.m_min, aabbMaxSize, sizeT );
            baseAabb.setIntersection( domain, baseAabb );

            AABB packedAabb;
            codec.convertAabb( baseAabb, packedAabb );

            // Test for overlap of neighbors in packed space and unpacked space.
            {
                const int axis = prng.nextInt32() % 3;
                const int sign = prng.nextInt32() & 1 ? -1 : 1;

                hkAabb          neighboringAabb = baseAabb;
                hkVector4&      bounds = sign == -1 ? neighboringAabb.m_min : neighboringAabb.m_max;
                bounds( axis ) += hkReal( sign ) * ( neighboringAabb.m_max( axis ) - neighboringAabb.m_min( axis ) );
                neighboringAabb.setIntersection( domain, neighboringAabb );

                AABB  neighboringPackedAabb; codec.convertAabb( neighboringAabb, neighboringPackedAabb );

                // In packed space.
                const bool overlapsPacked = !neighboringPackedAabb.disjoint( packedAabb );
                HK_TEST( overlapsPacked );
                if ( !overlapsPacked )
                {
                    return;
                }

                // In unpacked space.
                hkAabb          unpack0; codec.restoreAabb( neighboringPackedAabb, unpack0 );
                hkAabb          unpack1; codec.restoreAabb( packedAabb, unpack1 );

                const bool overlapsUnpacked = unpack0.overlaps( unpack1 );
                HK_TEST( overlapsUnpacked );
                if ( !overlapsUnpacked )
                {
                    return;
                }
            }

            // Test that packing is conservative, that is, the unpacked AABB must includes the original one.
            hkAabb  unpackedAabb; codec.restoreAabb( packedAabb, unpackedAabb );

            const bool unpackedAabbContainBaseAabb = unpackedAabb.contains( baseAabb );
            HK_TEST( unpackedAabbContainBaseAabb );
            if ( !unpackedAabbContainBaseAabb )
            {
                return;
            }

            // Test that packing is stable, that is, a pack/unpack cycles should yield the same packed AABB.
            // Not required to pass but it would be nice for this property to hold.
            {
                #if 0 
                AABB repackedAabb; codec.convertAabb( unpackedAabb, repackedAabb );
                const bool sameAabb = hkString::memCmp( &repackedAabb, &packedAabb, sizeof( AABB ) ) == 0;
                HK_TEST( sameAabb );
                if ( !sameAabb )
                {
                    // Does it converge to something at least ?? :)
                    for ( int j = 0; j < 100; ++j )
                    {
                        codec.restoreAabb( repackedAabb, unpackedAabb );
                        codec.convertAabb( unpackedAabb, repackedAabb );
                    }
                    return;
                }
                #endif
            }
        }
    }
#endif
}


int aabbUnitTest_main()
{
    // 16bits.
    compressedAabbCodecTest<hkIntSpaceUtil, hkAabb16>(false);

    // 24bits.
    compressedAabbCodecTest<hkAabb24_16_24_Codec, hkAabb24_16_24>(true);

    if ( 1 )
    {
        hkAabb aabb;

        aabb.m_min.setZero();
        aabb.m_max.set( 0x800000, 0x8000, 0x800000 );   // this creates unit scale

        hkAabb24_16_24_Codec codec;
        codec.set( aabb );

        hkAabb a0;
        a0.m_min.set ( 1,2,3 );
        a0.m_max.set ( 2,3,4 );

        hkAabb24_16_24_WithKey a0i; codec.packAabb( a0, &a0i );

        {
            hkAabb t;   codec.unpackAabb24Unscaled( a0i, &t );
            HK_TEST( ( t.m_min <= a0.m_min ).allAreSet( hkVector4ComparisonMask::MASK_XYZ ) );
        }

        {   // tests if less really takes minX
            hkAabb a1;
            a1.m_min.set ( 0,100,100 );
            a1.m_max.set ( 100,100,100 );
            hkAabb24_16_24_WithKey a1i;
            codec.packAabb( a1, &a1i );
            bool a0Less = a0i < a1i;    /// test minX
            HK_TEST( !a0Less );
        }

        {
            hkAabb a;
            a.m_min.set ( 4,2,3 );
            a.m_max.set ( 5,3,4 );

            hkAabb24_16_24_WithKey ai;
            codec.packAabb( a, &ai );
            hkBoolLL t = a0i.disjoint( ai );
            HK_TEST( t != hkFalse32 );
        }
        {
            hkAabb a;
            a.m_min.set ( 1,5,3 );
            a.m_max.set ( 2,6,4 );

            hkAabb24_16_24_WithKey ai;
            codec.packAabb( a, &ai );
            hkBoolLL t = a0i.disjoint( ai );
            HK_TEST( t != hkFalse32 );
        }
        {
            hkAabb a;
            a.m_min.set ( 1,2,6 );
            a.m_max.set ( 2,3,7 );

            hkAabb24_16_24_WithKey ai;
            codec.packAabb( a, &ai );
            hkBoolLL t = a0i.disjoint( ai );
            HK_TEST( t != hkFalse32 );
        }
        {   // check some random aabbs pack unpack
            for (int i =0 ; i < 2; i++)
            {
                hkPseudoRandomGenerator random(5);
                for (int j = 0; j < 20; j++ )
                {
                    hkAabb a;
                    random.getRandomVectorRange( aabb.m_min, aabb.m_max, a.m_min );
                    random.getRandomVectorRange( a.m_min, aabb.m_max, a.m_max );

                    HK_ALIGN16(hkAabb24_16_24_WithKey) ai; codec.packAabb( a, &ai);
                    hkAabb t;   codec.unpackAabb24Unscaled( ai, &t );
                    HK_TEST( t.m_min.allEqual<3>(a.m_min, hkSimdReal_2 ));

                    hkAabb b;
                    random.getRandomVectorRange( aabb.m_min, aabb.m_max, b.m_min );
                    random.getRandomVectorRange( b.m_min, aabb.m_max, b.m_max );

                    hkAabb24_16_24_WithKey bi; codec.packAabb( b, &bi);

                    bool overlaps = 0 != a.overlaps(b);
                    bool iOverlap = (0 == ai.disjoint(bi));

                    HK_TEST( overlaps == iOverlap );
                }
                aabb.m_max.set( 0x800000, 0x800000, 0x8000 );
                codec.set(aabb);
            }
        }
    }
    return 0;
}

HK_TEST_REGISTER(aabbUnitTest_main,     "Fast", "Common/Test/UnitTest/Base/",     __FILE__    );

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
