// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/Types/Geometry/Aabb/hkAabb.h>
#include <Common/Base/Types/Geometry/Aabb/hkAabbUtil.h>

int aabb_main()
{
    hkVector4 zero; zero.setZero();
    hkVector4 v0, v1, v2;
    v0.set(100,200,300);
    v1.set(200,300,400);
    v2.set(50,100,350);

    hkAabb a0; a0.m_min = zero; a0.m_max =  v0;
    hkAabb a1; a1.m_min = zero; a1.m_max =  v1;
    hkAabb a2; a2.m_min = v2; a2.m_max =  v1;

    HK_TEST( a0.isValid() );
    HK_TEST( a1.isValid() );
    HK_TEST( a2.isValid() );
    HK_TEST( a0.isEmpty() == false);

    hkAabb a3;
    a3.m_min = v2;
    a3.m_max = v0;
    HK_TEST( a3.isValid() == false);
    HK_TEST( a3.isEmpty() );

    HK_TEST( a1.contains(a0) );
    HK_TEST( a0.contains(a1) == hkFalse32);

    HK_TEST( a1.contains(a2) );
    HK_TEST( a2.contains(a1) == hkFalse32);
    HK_TEST( a0.contains(a2) == hkFalse32);
    HK_TEST( a2.contains(a0) == hkFalse32);

    // Test setEmpty/isEmpty
    {
        hkAabb a4;
        a4.setEmpty();
        HK_TEST( a3.isEmpty() );

        // After we include a point, the AABB shouldn't be empty any more.
        hkVector4 pos; pos.set(1,2,3);
        a4.includePoint(pos);
        HK_TEST( !a4.isEmpty() );;
    }

    // Test expandBy/containsPoint
    {
        hkAabb a5; a5.m_min = v2; a5.m_max =  v1;
        hkVector4 testPoint;
        testPoint.set( v2(0) - 1.0f, v1(1) + 1.0f, .5f * (v2(2) + v1(2)) );
        HK_TEST( !a5.containsPoint(testPoint) );

        a5.expandBy(hkSimdReal::fromFloat(1.5f));
        HK_TEST( a5.containsPoint( testPoint ) );
    }

    // Test transform
    {
        hkSimdReal tol;
        tol.setFromFloat(1.0e-3f);

        hkAabb ut; ut.m_min = v0; ut.m_max = v1;
        hkAabb outAabb;
        hkMatrix4 matrix;

        // Identity transform should not modify aabb
        matrix.setIdentity();
        hkAabbUtil::calcAabb(matrix, ut, outAabb);
        //ut.transform(matrix, outAabb);
        HK_TEST (ut.m_min.allEqual<3>(outAabb.m_min, tol) && ut.m_max.allEqual<3>(outAabb.m_max, tol));

        // Test translation
        hkQsTransform transform;
        transform.setIdentity();
        hkVector4 transl;
        transl.set(100.f, 0.0f, 0.0f);
        transform.setTranslation(transl);
        matrix.set(transform);
        hkAabbUtil::calcAabb(matrix, ut, outAabb);
        //ut.transform(matrix, outAabb);
        HK_TEST (outAabb.m_min.getComponent(0).getReal() == 200);
        HK_TEST (outAabb.m_min.getComponent(1).getReal() == 200);
        HK_TEST (outAabb.m_max.getComponent(0).getReal() == 300);
        HK_TEST (outAabb.m_max.getComponent(2).getReal() == 400);

        // Test rotation (1)
        hkQuaternion rot;
        rot.setFromEulerAngles( HK_REAL_DEG_TO_RAD * 90.f, 0.0f, 0.0f);
        transform.setRotation(rot);
        matrix.set(transform);
        hkAabbUtil::calcAabb(matrix, ut, outAabb);
        //ut.transform(matrix, outAabb);
        hkVector4 comp0, comp1;
        comp0.set(400.f, 200.f, -200.f);
        comp1.set(500.f, 300.f, -100.f);
        HK_TEST (comp0.allEqual<3>(outAabb.m_min, tol) && comp1.allEqual<3>(outAabb.m_max, tol));

        // Test rotation (2)
        rot.setFromEulerAngles( HK_REAL_DEG_TO_RAD * 90.f, 0.0f, HK_REAL_DEG_TO_RAD * 180.f);
        transform.setRotation(rot);
        matrix.set(transform);
        hkAabbUtil::calcAabb(matrix, ut, outAabb);
        //ut.transform(matrix, outAabb);
        comp0.set(-300.f, -300.f, -200.f);
        comp1.set(-200.f, -200.f, -100.f);
        HK_TEST (comp0.allEqual<3>(outAabb.m_min, tol) && comp1.allEqual<3>(outAabb.m_max, tol));

        // Test rotation (3)
        rot.setFromEulerAngles( HK_REAL_DEG_TO_RAD * 90.f, HK_REAL_DEG_TO_RAD * (-90.f), HK_REAL_DEG_TO_RAD * 180.f);
        transform.setRotation(rot);
        matrix.set(transform);
        hkAabbUtil::calcAabb(matrix, ut, outAabb);
        //ut.transform(matrix, outAabb);
        comp0.set(-300.f, -200.f, 200.f);
        comp1.set(-200.f, -100.f, 300.f);
        HK_TEST (comp0.allEqual<3>(outAabb.m_min, tol) && comp1.allEqual<3>(outAabb.m_max, tol));

    }

    return 0;
}

HK_TEST_REGISTER(aabb_main, "Fast", "Common/Test/UnitTest/Base/", __FILE__     );

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
