// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/Fwd/hkcstdarg.h>

namespace
{
    const hkVarArgs::VaTypes NULL_VA_TYPES = HK_NULL;

    void myvarL_none( const char* fmt, hkVarArgs::VaTypes types, ... )
    {
        HK_TEST_NE( NULL_VA_TYPES, types );
        HK_TEST( 0 == types->m_numTypes );
    }

    void myvarL_single( const char* fmt, hkVarArgs::VaTypes types, ... )
    {
        HK_TEST_NE( NULL_VA_TYPES, types );
        HK_TEST( 1 == types->m_numTypes );

        const hkVarArgs::Detail::VarArgsTypeArray<1>* storage = reinterpret_cast<const hkVarArgs::Detail::VarArgsTypeArray<1>*>( types );
        const hkReflect::Type* const* typeArray = storage->m_types;

        HK_TEST( typeArray[0]->equals<int>() );
    }

    void myvarL_multiple( const char* fmt, hkVarArgs::VaTypes types, ... )
    {
        HK_TEST_NE( NULL_VA_TYPES, types );
        HK_TEST( 3 == types->m_numTypes );

        const hkVarArgs::Detail::VarArgsTypeArray<1>* storage = reinterpret_cast<const hkVarArgs::Detail::VarArgsTypeArray<1>*>( types );
        const hkReflect::Type* const* typeArray = storage->m_types;

        HK_TEST( typeArray[0]->equals<int>() );
        HK_TEST( typeArray[1]->equals<const int>() );
        HK_TEST( typeArray[2]->equals<float>() );
    }

    void myvarL_strings( const char* fmt, hkVarArgs::VaTypes types, ... )
    {
        HK_TEST_NE( NULL_VA_TYPES, types );
        HK_TEST( 4 == types->m_numTypes );

        const hkVarArgs::Detail::VarArgsTypeArray<1>* storage = reinterpret_cast<const hkVarArgs::Detail::VarArgsTypeArray<1>*>( types );
        const hkReflect::Type* const* typeArray = storage->m_types;

        HK_TEST( typeArray[0]->equals<const char*>() );
        HK_TEST( typeArray[1]->equals<char[11]>() ); // yes, we remove const... might want to revisit later
        HK_TEST( typeArray[2]->equals<char*>() );
        HK_TEST( typeArray[3]->equals<char[12]>() );
    }

    int varargs_list()
    {
        {
            myvarL_none( HK_VARARGS1( "test_none" ) );
        }

        {
            myvarL_single( HK_VARARGS1( "test_single", 1 ) );
        }

        {
            int x = 3;
            const int cx = 42;
            float f = -37.28f;
            myvarL_multiple( HK_VARARGS1( "test_multiple", x, cx, f ) );
        }

        {
            const char* ptr = "ptr_string";
            const char buf[] = "buf_string";
            char dummy[] = "ptr2_string";
            char* ptr2 = dummy;
            char buf2[] = "buf2_string";
            myvarL_strings( HK_VARARGS1( "test_strings", ptr, buf, ptr2, buf2 ) );
        }

        return 0;
    }
}

namespace
{
    int myvar_v( const hkVarArgs::Vector& inf )
    {
        return 0;
    }

    HK_VARARGS_FUNCTION_0( int, myvar, myvar_v );

    int varargs_vector()
    {
        myvar( 10, 20 );
        myvar( 'c', "foo" );
        myvar( 10.4, 20, 9999999 );
        //myvar(10.4,20,9999999,4,"asdf",11.3,44);
        return 0;
    }
}

namespace
{
    void myunpackL_none( const char* fmt, hkVarArgs::VaTypes types, ... )
    {
        hkVarArgs::FixedArray<10> buffer;
        HK_VARARGS_UNPACK( buffer, types );

        HK_TEST( 0 == buffer.getSize() );
    }

    void myunpackL_single( const char* fmt, hkVarArgs::VaTypes types, ... )
    {
        hkVarArgs::FixedArray<10> buffer;
        HK_VARARGS_UNPACK( buffer, types );

        HK_TEST( 1 == buffer.getSize() );

        hkReflect::IntVar h = buffer[0];
        HK_TEST( h != HK_NULL );
        HK_TEST( h.getValue().equals( 1 ) );
    }

    void myunpackL_multiple( const char* fmt, hkVarArgs::VaTypes types, ... )
    {
        hkVarArgs::FixedArray<10> buffer;
        HK_VARARGS_UNPACK( buffer, types );

        HK_TEST( 3 == buffer.getSize() );

        {
            hkReflect::IntVar h = buffer[0];
            HK_TEST( h != HK_NULL );
            HK_TEST( h.getValue().equals( 3 ) );
        }
        {
            hkReflect::IntVar h = buffer[1];
            HK_TEST( h != HK_NULL );
            HK_TEST( h.getValue().equals( 42 ) );
        }
        {
            hkReflect::FloatVar h = buffer[2];
            HK_TEST( h != HK_NULL );
            HK_TEST( -37.28f == h.getValue().m_value );
        }
    }

    void myunpackL_strings( const char* fmt, hkVarArgs::VaTypes types, ... )
    {
        hkVarArgs::FixedArray<10> buffer;
        HK_VARARGS_UNPACK( buffer, types );

        HK_TEST( 4 == buffer.getSize() );

        {
            hkReflect::StringVar h = buffer[0];
            HK_TEST( h != HK_NULL );
            HK_TEST_EQ( 0, h.getValue().compare( "ptr_string" ) );
        }
        {
            hkReflect::StringVar h = buffer[1];
            HK_TEST( h != HK_NULL );
            HK_TEST_EQ( 0, h.getValue().compare( "buf_string" ) );
        }
        {
            hkReflect::StringVar h = buffer[2];
            HK_TEST( h != HK_NULL );
            HK_TEST_EQ( 0, h.getValue().compare( "ptr2_string" ) );
        }
        {
            hkReflect::StringVar h = buffer[3];
            HK_TEST( h != HK_NULL );
            HK_TEST_EQ( 0, h.getValue().compare( "buf2_string" ) );
        }
    }

    int varargs_unpack()
    {
        {
            myunpackL_none( HK_VARARGS1( "test_none" ) );
        }

        {
            myunpackL_single( HK_VARARGS1( "test_single", 1 ) );
        }

        {
            int x = 3;
            const int cx = 42;
            float f = -37.28f;
            myunpackL_multiple( HK_VARARGS1( "test_multiple", x, cx, f ) );
        }

        {
            const char* ptr = "ptr_string";
            const char buf[] = "buf_string";
            char dummy[] = "ptr2_string";
            char* ptr2 = dummy;
            char buf2[] = "buf2_string";
            myunpackL_strings( HK_VARARGS1( "test_strings", ptr, buf, ptr2, buf2 ) );
        }

        return 0;
    }
}

HK_TEST_REGISTER( varargs_list, "Fast", "Common/Test/UnitTest/Base/", __FILE__ );
HK_TEST_REGISTER( varargs_vector, "Fast", "Common/Test/UnitTest/Base/", __FILE__ );
HK_TEST_REGISTER( varargs_unpack, "Fast", "Common/Test/UnitTest/Base/", __FILE__ );

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
