// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>

#include <Common/Base/Reflect/Visitor/hkReflectVisitor.h>
#include <Common/Base/UnitTest/Reflection/castsTest.h>


template<typename T>
struct OneTypeVisitor : public hkReflect::TypeVisitor<OneTypeVisitor<T>, bool>
{
    int otherTypes;

    OneTypeVisitor() : otherTypes(0) {}

    bool visit(const hkReflect::Type*)
    {
        ++otherTypes;
        return false;
    }

    bool visit(const T*)
    {
        return true;
    }
};

template<typename CxxType, typename ReflType>
void testTypeVisitorImpl()
{
    OneTypeVisitor<ReflType> v;
    HK_TEST(v.dispatch(hkReflect::getType<CxxType>()));
    HK_TEST(v.otherTypes == 0);
}

void testTypeVisitor()
{
    testTypeVisitorImpl<int, hkReflect::IntType>();
    testTypeVisitorImpl<float, hkReflect::FloatType>();
    testTypeVisitorImpl<hkArray<int>, hkReflect::ArrayType>();
    testTypeVisitorImpl<hkReferencedObject, hkReflect::RecordType>();
}


template<typename T>
struct OneVarVisitor : public hkReflect::VarVisitor<OneVarVisitor<T>, bool>
{
    int otherTypes;

    OneVarVisitor() : otherTypes(0) {}

    bool visit(const hkReflect::Var&)
    {
        ++otherTypes;
        return false;
    }

    bool visit(const T& t)
    {
        return true;
    }
};

template<typename CxxType, typename ReflType, typename HandleType>
void testVarVisitorImpl()
{
    CxxType cxx;
    hkReflect::Var var(&cxx, hkReflect::getType<CxxType>());

    OneVarVisitor<HandleType> v;
    HK_TEST(v.dispatch(var));
//  HK_TEST(v.otherTypes == 0);
}

void testVarVisitor()
{
    testVarVisitorImpl<int, hkReflect::IntType, hkReflect::IntVar>();
    testVarVisitorImpl<float, hkReflect::FloatType, hkReflect::FloatVar>();
    testVarVisitorImpl<hkArray<int>, hkReflect::ArrayType, hkReflect::ArrayVar>();
    testVarVisitorImpl<castTest::Leaf, hkReflect::RecordType, hkReflect::RecordVar>();
}

int typeVisitor_main()
{
    testTypeVisitor();
    testVarVisitor();

    return 0;
}

HK_TEST_REGISTER(typeVisitor_main,     "Fast", "Common/Test/UnitTest/Base/",     __FILE__    );

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
