// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/Reflect/Util/hkVarCoerce.h>

template<typename TargetCppType, typename SourceCppType>
bool expectSuccess(TargetCppType& target, const SourceCppType& source, const hkReflect::VarCoerce& util)
{
    target = 0;
    return util.copy(&target, &source) && (target == static_cast<TargetCppType>(source));
};

template<typename TargetCppType, typename SourceCppType>
bool expectFailure(TargetCppType& target, const SourceCppType& source, const hkReflect::VarCoerce& util)
{
    target = 0;
    return util.copy(&target, &source) == false && (target == 0);
}


template<typename TargetCppType, typename SourceCppType>
bool expectSuccess(TargetCppType& target, const SourceCppType& source)
{
    hkReflect::VarCoerce util;
    return expectSuccess(target, source, util);
};

template<typename TargetCppType, typename SourceCppType>
bool expectFailure(TargetCppType& target, const SourceCppType& source)
{
    hkReflect::VarCoerce util;
    return expectFailure(target, source, util);
}

static int typeConvertTest_main()
{
    hkBool s_true_b8 = true; (void) s_true_b8;
    hkBool s_false_b8 = false; (void) s_false_b8;
    hkBool32 s_true_b32 = true; (void) s_true_b32;
    hkBool32 s_false_b32 = true; (void) s_false_b32;

    hkInt8 s_pos_i8 = 1 << 5; (void) s_pos_i8;
    hkInt8 s_neg_i8 = -s_pos_i8; (void) s_neg_i8;
    hkInt16 s_pos_i16 = 1 << 13; (void) s_pos_i16;
    hkInt16 s_neg_i16 = -s_pos_i16; (void) s_neg_i16;
    hkInt32 s_pos_i32 = 1 << 22; (void) s_pos_i32;
    hkInt32 s_neg_i32 = -s_pos_i32; (void) s_neg_i32;
    hkInt64 s_pos_i64 = (hkInt64) 1 << 37; (void) s_pos_i64;
    hkInt64 s_neg_i64 = -s_pos_i64; (void) s_neg_i64;

    hkUint8 s_small_u8 = 1 << 5; (void) s_small_u8;
    hkUint8 s_big_u8 = 1 << 7; (void) s_big_u8;
    hkUint16 s_small_u16 = 1 << 5; (void) s_small_u16;
    hkUint16 s_big_u16 = 1 << 15; (void) s_big_u16;
    hkUint32 s_small_u32 = (hkUint32) 1 << 13; (void) s_small_u32;
    hkUint32 s_big_u32 = (hkUint32) 1 << 31; (void) s_big_u32;
    hkUint64 s_small_u64 = (hkUint64) 1 << 22; (void) s_small_u64;
    hkUint64 s_big_u64 = (hkUint64) 1 << 63; (void) s_big_u64;

    hkBool t_b8; (void) t_b8;
    hkBool32 t_b32; (void) t_b32;

    hkInt8 t_i8 = 0; (void) t_i8;
    hkInt16 t_i16 = 0; (void) t_i16;
    hkInt32 t_i32 = 0; (void) t_i32;
    hkInt64 t_i64 = 0; (void) t_i64;

    hkUint8 t_u8 = 0; (void) t_u8;
    hkUint16 t_u16 = 0; (void) t_u16;
    hkUint32 t_u32 = 0; (void) t_u32;
    hkUint64 t_u64 = 0; (void) t_u64;

    hkFloat32 s_pos8_f32 = hkMath::pow(2.0f, 6.0f); (void) s_pos8_f32;
    hkFloat32 s_neg8_f32 = -s_pos8_f32; (void) s_neg8_f32;

    hkFloat32 s_pos16_f32 = hkMath::pow(2.0f, 14.0f); (void) s_pos16_f32;
    hkFloat32 s_neg16_f32 = -s_pos8_f32; (void) s_neg16_f32;

    hkDouble64 s_pos32_d64 = hkMath::pow(2.0, 30.0); (void) s_pos32_d64;
    hkDouble64 s_small_d64 = hkMath::pow(2.0, 120.0); (void) s_small_d64;
    hkDouble64 s_big_d64 = hkMath::pow(2.0, 130); (void) s_big_d64;
    hkDouble64 s_neg64_d64 = -hkMath::pow(2.0, 62.0); (void) s_big_d64;

    hkFloat32 t_f32 = 0; (void) t_f32;
    hkDouble64 t_d64 = 0; (void) t_d64;

    // First test the static convertValue methods.

    // Test some diagonals
    HK_TEST(expectSuccess(t_b8, s_true_b8));
    HK_TEST(expectSuccess(t_i16, s_neg_i16));
    HK_TEST(expectSuccess(t_u8, s_big_u8));
    HK_TEST(expectSuccess(t_u32, s_small_u32));
    HK_TEST(expectSuccess(t_f32, s_neg8_f32));

    // Test smaller to bigger type conversion within a kind.
//  HK_TEST((expectSuccess<hkBool32, hkBool, hkReflect::BoolType, hkReflect::BoolType>(t_b32, s_true_b8)));
    HK_TEST(expectSuccess(t_i16, s_big_u8));
    HK_TEST(expectSuccess(t_u64, s_pos_i16));
    HK_TEST(expectSuccess(t_d64, s_pos16_f32));

    // Test successful bigger to smaller type conversion within a kind.
//  HK_TEST((expectSuccess<hkBool, hkBool32, hkReflect::BoolType, hkReflect::BoolType>(t_b8, s_true_b32)));
    HK_TEST(expectSuccess(t_i8, s_small_u16));
    HK_TEST(expectSuccess(t_u16, s_small_u32));
    HK_TEST(expectSuccess(t_f32, s_small_d64));

    // Test failed bigger to smaller type conversion within a kind.
    HK_TEST(expectFailure(t_u8, s_big_u16));
    HK_TEST(expectFailure(t_i16, s_pos_i64));
    HK_TEST(expectFailure(t_i8, s_neg_i16));
//  HK_TEST(expectFailure(t_f32, s_big_d64));

//  // Test failed negative to signed type conversion within integer types.
    HK_TEST(expectFailure(t_u8, s_neg_i8));
    HK_TEST(expectFailure(t_u16, s_neg_i16));
    HK_TEST(expectFailure(t_u32, s_neg_i32));
    HK_TEST(expectFailure(t_u64, s_neg_i64));

    // Test successful cross conversion between kinds.
//  HK_TEST(expectSuccess(t_u8, s_pos8_f32));
//  HK_TEST(expectSuccess(t_i16, s_neg16_f32));
//  HK_TEST(expectSuccess(t_u32, s_pos32_d64));
//  HK_TEST(expectSuccess(t_f32, s_neg_i64));
//  HK_TEST(expectSuccess(t_d64, s_big_u64));
//  HK_TEST(expectSuccess(t_i64, s_neg64_d64));

    // Test failed conversion between kinds.
    HK_TEST(expectFailure(t_i8, s_pos16_f32));
    HK_TEST(expectFailure(t_u16, s_neg8_f32));
    HK_TEST(expectFailure(t_u32, s_neg_i32));
    HK_TEST(expectFailure(t_u64, s_neg_i64));
    HK_TEST(expectFailure(t_u64, s_big_d64));

    // Now test the option functionality.
    hkReflect::VarCoerce convertUtil;
    convertUtil.disallow(hkReflect::KIND_BOOL, hkReflect::KIND_BOOL);
    convertUtil.disallow(hkReflect::KIND_INT, hkReflect::KIND_INT);
    convertUtil.disallow(hkReflect::KIND_FLOAT, hkReflect::KIND_FLOAT);


    //HK_TEST(expectFailure(t_b8, s_true_b8, convertUtil));
    HK_TEST(expectFailure(t_i16, s_neg_i16, convertUtil));
    HK_TEST(expectFailure(t_u8, s_big_u8, convertUtil));
    HK_TEST(expectFailure(t_u32, s_small_u32, convertUtil));
    HK_TEST(expectFailure(t_f32, s_neg8_f32, convertUtil));

    // Test conversions within a kind are disabled.
    HK_TEST(expectFailure(t_i16, s_big_u8, convertUtil));
    HK_TEST(expectFailure(t_u64, s_pos_i16, convertUtil));
    HK_TEST(expectFailure(t_d64, s_pos16_f32, convertUtil));
    HK_TEST(expectFailure(t_i8, s_small_u16, convertUtil));
    HK_TEST(expectFailure(t_u16, s_small_u32, convertUtil));
    HK_TEST(expectFailure(t_f32, s_small_d64, convertUtil));

    // Test cross conversions between kinds are disabled.
    HK_TEST(expectFailure(t_u8, s_pos8_f32, convertUtil));
    HK_TEST(expectFailure(t_i16, s_neg16_f32, convertUtil));
    HK_TEST(expectFailure(t_u32, s_pos32_d64, convertUtil));
    HK_TEST(expectFailure(t_f32, s_neg_i64, convertUtil));
    HK_TEST(expectFailure(t_d64, s_big_u64, convertUtil));
    HK_TEST(expectFailure(t_i64, s_neg64_d64, convertUtil));

    // Switch on conversions within a kind.
    convertUtil.allow<hkReflect::KIND_BOOL, hkReflect::KIND_BOOL>(&hkReflect::VarCoerce::boolFromBool);
    convertUtil.allow<hkReflect::KIND_INT, hkReflect::KIND_INT>(&hkReflect::VarCoerce::intFromInt);
    convertUtil.allow<hkReflect::KIND_FLOAT, hkReflect::KIND_FLOAT>(&hkReflect::VarCoerce::floatFromFloat);

    // Test conversions within a kind are enabled.
    HK_TEST(expectSuccess(t_i16, s_big_u8, convertUtil));
    HK_TEST(expectSuccess(t_u64, s_pos_i16, convertUtil));
    HK_TEST(expectSuccess(t_d64, s_pos16_f32, convertUtil));
    HK_TEST(expectSuccess(t_i8, s_small_u16, convertUtil));
    HK_TEST(expectSuccess(t_u16, s_small_u32, convertUtil));
    HK_TEST(expectSuccess(t_f32, s_small_d64, convertUtil));

    // Switch on some other options.
    convertUtil.allow<hkReflect::KIND_FLOAT, hkReflect::KIND_INT>(&hkReflect::VarCoerce::floatFromInt);
    convertUtil.allow<hkReflect::KIND_INT, hkReflect::KIND_FLOAT>(&hkReflect::VarCoerce::intFromFloat);

    // Check the new conversions are enabled.
    HK_TEST(expectSuccess(t_u8, s_pos8_f32, convertUtil));
    HK_TEST(expectSuccess(t_i16, s_neg16_f32, convertUtil));
    HK_TEST(expectSuccess(t_u32, s_pos32_d64, convertUtil));

    HK_TEST(expectFailure(t_f32, s_true_b8, convertUtil));
    convertUtil.allow<hkReflect::KIND_FLOAT, hkReflect::KIND_BOOL>(&hkReflect::VarCoerce::floatFromBool);
    HK_TEST(expectSuccess(t_f32, s_true_b8, convertUtil));

    return 0;
}

HK_TEST_REGISTER(typeConvertTest_main,     "Fast", "Common/Test/UnitTest/Base/",     __FILE__    );

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
