// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/Reflect/TypeVm/hkTypeVmCompilerPasses.h>
#include <Common/Base/Reflect/TypeVm/hkTypeVmCompiler.h>
#include <Common/Base/Reflect/TypeVm/hkTypeVmFastCopyInterpreter.h>

template<typename SRCTYPE, typename DSTTYPE>
int testSimpleConversion()
{
    enum
    {
        // Increase this considerably once it passes
        NUM_VALUES = 10
    };

    SRCTYPE vals[NUM_VALUES];
    DSTTYPE target[NUM_VALUES];

    for (hkUint64 i = 0; i < NUM_VALUES; i++)
    {
        vals[int(i)] = SRCTYPE(float(i) * 3.1415926536f * ((i % 2) ? -1.0f : 1.0f));
    }

    hkTypeVm::Compiler compiler;
    hkTypeVm::addDefaultPasses(compiler);
    compiler.addPass<hkTypeVm::IntAndFloatConversionPass>();

    const hkTypeVm::Program* program = compiler.compile(hkReflect::getType<SRCTYPE>(), hkReflect::getType<DSTTYPE>());

    hkTypeVm::FastCopyInterpreter interp;
    const int srcElementSize = hkSizeOf(vals[0]);
    const int dstElementSize = hkSizeOf(target[0]);

    hkTypeVm::FastCopyInterpreter::execN(interp, program, target, NUM_VALUES * dstElementSize, vals, NUM_VALUES * srcElementSize, dstElementSize, srcElementSize, NUM_VALUES);

    for (hkUint64 i = 0; i < NUM_VALUES; i++)
    {
        const double tolerance = hkMath::abs(double(vals[i]) + double(target[i])) / 100000.0;
        HK_TEST(hkMath::equal(static_cast<double>(vals[i]), static_cast<double>(target[i]), tolerance));
    }

    return 0;
}

int typeConvertMachine_main()
{
    // Simplest version
    testSimpleConversion<float, double>();
    testSimpleConversion<float, float>();
    testSimpleConversion<double, float>();
    testSimpleConversion<double, double>();

    // Source type, dest type and matching native types to extract for comparison
    testSimpleConversion<hkFloat32Be, hkFloat32Be>();
    testSimpleConversion<hkFloat32Le, hkFloat32Be>();
    testSimpleConversion<hkFloat64Be, hkFloat32Be>();
    testSimpleConversion<hkFloat64Le, hkFloat32Be>();

    testSimpleConversion<hkFloat32Be, hkFloat32Le>();
    testSimpleConversion<hkFloat32Le, hkFloat32Le>();
    testSimpleConversion<hkFloat64Be, hkFloat32Le>();
    testSimpleConversion<hkFloat64Le, hkFloat32Le>();

    testSimpleConversion<hkFloat32Be, hkFloat64Be>();
    testSimpleConversion<hkFloat32Le, hkFloat64Be>();
    testSimpleConversion<hkFloat64Be, hkFloat64Be>();
    testSimpleConversion<hkFloat64Le, hkFloat64Be>();

    testSimpleConversion<hkFloat32Be, hkFloat64Le>();
    testSimpleConversion<hkFloat32Le, hkFloat64Le>();
    testSimpleConversion<hkFloat64Be, hkFloat64Le>();
    testSimpleConversion<hkFloat64Le, hkFloat64Le>();

    return 0;
}

HK_TEST_REGISTER(typeConvertMachine_main, "Fast", "Common/Test/UnitTest/Base/", __FILE__);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
