// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>

int traitTest_main()
{
    HK_COMPILE_TIME_ASSERT(hkTrait::IsPodType<const void*>::result);

    HK_COMPILE_TIME_ASSERT((hkTrait::TypesAreEqual<int, int>::result));
    HK_COMPILE_TIME_ASSERT((!hkTrait::TypesAreEqual<int, float>::result));

    HK_COMPILE_TIME_ASSERT((hkTrait::TypesAreEqual<hkTrait::RemoveConst<int>::type, int>::result));
    HK_COMPILE_TIME_ASSERT((hkTrait::TypesAreEqual<hkTrait::RemoveConst<const int>::type, int>::result));
    HK_COMPILE_TIME_ASSERT((hkTrait::TypesAreEqual<hkTrait::RemoveConst<int*>::type, int*>::result));
    HK_COMPILE_TIME_ASSERT((hkTrait::TypesAreEqual<hkTrait::RemoveConst<const int*>::type, const int*>::result));
    HK_COMPILE_TIME_ASSERT((hkTrait::TypesAreEqual<hkTrait::RemoveConst<int* const>::type, int*>::result));
    HK_COMPILE_TIME_ASSERT((hkTrait::TypesAreEqual<hkTrait::RemoveConst<const int* const>::type, const int*>::result));

    HK_COMPILE_TIME_ASSERT((hkTrait::TypesAreEqual<hkTrait::AddConst<int>::type, const int>::result));
    HK_COMPILE_TIME_ASSERT((hkTrait::TypesAreEqual<hkTrait::AddConst<const int>::type, const int>::result));
    HK_COMPILE_TIME_ASSERT((hkTrait::TypesAreEqual<hkTrait::AddConst<int*>::type, int* const>::result));
    HK_COMPILE_TIME_ASSERT((hkTrait::TypesAreEqual<hkTrait::AddConst<const int*>::type, const int* const>::result));
    HK_COMPILE_TIME_ASSERT((hkTrait::TypesAreEqual<hkTrait::AddConst<int* const>::type, int* const>::result));
    HK_COMPILE_TIME_ASSERT((hkTrait::TypesAreEqual<hkTrait::AddConst<const int* const>::type, const int* const>::result));

    HK_COMPILE_TIME_ASSERT((hkTrait::TypesAreEqual<hkTrait::ConstIfConst<int, int*>::type, int*>::result));
    HK_COMPILE_TIME_ASSERT((hkTrait::TypesAreEqual<hkTrait::ConstIfConst<int, int*>::type, int*>::result));
    HK_COMPILE_TIME_ASSERT((hkTrait::TypesAreEqual<hkTrait::ConstIfConst<int*, int*>::type, int*>::result));
    HK_COMPILE_TIME_ASSERT((hkTrait::TypesAreEqual<hkTrait::ConstIfConst<const int*, int*>::type, int*>::result));
    HK_COMPILE_TIME_ASSERT((hkTrait::TypesAreEqual<hkTrait::ConstIfConst<int* const, int*>::type, int* const>::result));
    HK_COMPILE_TIME_ASSERT((hkTrait::TypesAreEqual<hkTrait::ConstIfConst<const int* const, int*>::type, int* const>::result));

    HK_COMPILE_TIME_ASSERT((hkTrait::TypesAreEqual<hkTrait::ToVoid<int>::type, void>::result));
    HK_COMPILE_TIME_ASSERT((hkTrait::TypesAreEqual<hkTrait::ToVoid<const int>::type, const void>::result));
    HK_COMPILE_TIME_ASSERT((hkTrait::TypesAreEqual<hkTrait::ToVoid<int*>::type, void>::result));
    HK_COMPILE_TIME_ASSERT((hkTrait::TypesAreEqual<hkTrait::ToVoid<const int*>::type, void>::result));
    HK_COMPILE_TIME_ASSERT((hkTrait::TypesAreEqual<hkTrait::ToVoid<int* const>::type, const void>::result));
    HK_COMPILE_TIME_ASSERT((hkTrait::TypesAreEqual<hkTrait::ToVoid<const int* const>::type, const void>::result));

#define TEST_VIEW_AS(FROM, TO) hkTrait::ViewAsOther<FROM, TO>::view((FROM*)HK_NULL);
#define TEST_VIEW_AS_REINTERPRET(FROM, TO) \
    hkTrait::ViewAsOther<FROM, TO>::view((FROM*)HK_NULL); \
    static_assert(hkTrait::CanBeReinterpreted<FROM, TO>::result, "Cannot convert " #FROM " to " #TO)

    TEST_VIEW_AS( int, int );
    TEST_VIEW_AS( int, const int );
    TEST_VIEW_AS( hkReferencedObject, hkBaseObject );
    TEST_VIEW_AS( hkReferencedObject, const hkBaseObject );

    //TEST_VIEW_AS( const int, int );
    //TEST_VIEW_AS( hkBaseObject, hkReferencedObject );
    //TEST_VIEW_AS( const hkReferencedObject, hkBaseObject );

    TEST_VIEW_AS_REINTERPRET( const char*, const hkStringPtr );
    TEST_VIEW_AS_REINTERPRET( const char* const, const hkStringPtr );

    static_assert( !hkTrait::CanBeReinterpreted<char*, hkStringPtr>::result, "Invalid conversion allowed");
    static_assert( !hkTrait::CanBeReinterpreted<hkStringPtr, char* const>::result, "Invalid conversion allowed" );
    //TEST_VIEW_AS( char*, hkStringPtr );
    //TEST_VIEW_AS( hkStringPtr, char* const );

    TEST_VIEW_AS_REINTERPRET( hkReferencedObject*, const hkRefPtr<hkReferencedObject> );
    TEST_VIEW_AS_REINTERPRET( hkReferencedObject*, const hkRefPtr<const hkReferencedObject> );
    TEST_VIEW_AS_REINTERPRET( hkReferencedObject* const, const hkRefPtr<const hkReferencedObject> );
    TEST_VIEW_AS_REINTERPRET( const hkReferencedObject* const, const hkRefPtr<const hkReferencedObject> );

    TEST_VIEW_AS_REINTERPRET( hkRefPtr<hkReferencedObject>, hkReferencedObject* const );
    TEST_VIEW_AS_REINTERPRET( hkRefPtr<hkReferencedObject>, const hkReferencedObject* const );
    TEST_VIEW_AS_REINTERPRET( const hkRefPtr<hkReferencedObject>, hkReferencedObject* const );
    TEST_VIEW_AS_REINTERPRET( const hkRefPtr<const hkReferencedObject>, const hkReferencedObject* const );

    static_assert( !hkTrait::CanBeReinterpreted<hkReferencedObject*, hkRefPtr<hkReferencedObject> >::result, "Invalid conversion allowed" );
    static_assert( !hkTrait::CanBeReinterpreted<hkReferencedObject*, hkRefPtr<const hkReferencedObject> >::result, "Invalid conversion allowed" );
    static_assert( !hkTrait::CanBeReinterpreted<hkRefPtr<hkReferencedObject>, hkReferencedObject*>::result, "Invalid conversion allowed" );
    static_assert( !hkTrait::CanBeReinterpreted<hkRefPtr<hkReferencedObject>, const hkReferencedObject*>::result, "Invalid conversion allowed" );
    //TEST_VIEW_AS( hkReferencedObject*, hkRefPtr<hkReferencedObject> );
    //TEST_VIEW_AS( hkReferencedObject*, hkRefPtr<const hkReferencedObject> );
    //TEST_VIEW_AS( hkRefPtr<hkReferencedObject>, hkReferencedObject* );
    //TEST_VIEW_AS( hkRefPtr<hkReferencedObject>, const hkReferencedObject* );


#undef TEST_VIEW_AS
#undef TEST_VIEW_AS_REINTERPRET

    return 0;
}

//HK_TEST_REGISTER(traitTest_main,     "Fast", "Test/Test/UnitTest/Base/",     __FILE__    );

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
