// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>

#include <Common/Base/Types/hkSignalSlots.h>

namespace UnitTest
{
    HK_DECLARE_SIGNAL(TestSignal, hkSignal1<int>);

    struct SimpleSlot
    {
        void onTestSignal(int i) { HK_TEST(i == 0xabcd); }
    };

    struct UnsubscribingSlot
    {
        UnsubscribingSlot(TestSignal& testSignal) : m_testSignal(testSignal) {}

        void onTestSignal(int i)
        {
            HK_TEST(i == 0xabcd);
            m_testSignal.unsubscribeAll(this);
        }

        TestSignal& m_testSignal;
    };

    struct SignalMergeTest
    {
        HK_DECLARE_SIGNAL( SignalType, hkSignal0 );

        SignalType m_signal0;
        SignalType m_signal1;

        int m_numCallsToSlot0;
        int m_numCallsToSlot1;

        void slot0()
        {
            m_numCallsToSlot0++;
        }

        void slot1()
        {
            m_numCallsToSlot1++;
        }

        void run()
        {
            // sig0 => slot0
            m_signal0.subscribe( this, &SignalMergeTest::slot0, "slot0" );

            // sig1 => slot0, slot1
            m_signal1.subscribe( this, &SignalMergeTest::slot0, "slot0" );
            m_signal1.subscribe( this, &SignalMergeTest::slot1, "slot1" );

            // Check base-line behavior.
            m_numCallsToSlot0 = m_numCallsToSlot1 = 0;
            m_signal0.fire(); HK_TEST( m_numCallsToSlot0 == 1 && m_numCallsToSlot1 == 0 );

            m_numCallsToSlot0 = m_numCallsToSlot1 = 0;
            m_signal1.fire(); HK_TEST( m_numCallsToSlot0 == 1 && m_numCallsToSlot1 == 1 );

            // Append signal1 to signal0 and clear signal1.
            m_signal0 += m_signal1;
            m_signal1.reset();

            m_numCallsToSlot0 = m_numCallsToSlot1 = 0;
            m_signal0.fire(); HK_TEST( m_numCallsToSlot0 == 1 && m_numCallsToSlot1 == 1 );

            m_numCallsToSlot0 = m_numCallsToSlot1 = 0;
            m_signal1.fire(); HK_TEST( m_numCallsToSlot0 == 0 && m_numCallsToSlot1 == 0 );


            // Append signal1 to signal0 and clear signal0.
            m_signal1 += m_signal0;
            m_signal0.reset();

            m_numCallsToSlot0 = m_numCallsToSlot1 = 0;
            m_signal0.fire(); HK_TEST( m_numCallsToSlot0 == 0 && m_numCallsToSlot1 == 0 );

            m_numCallsToSlot0 = m_numCallsToSlot1 = 0;
            m_signal1.fire(); HK_TEST( m_numCallsToSlot0 == 1 && m_numCallsToSlot1 == 1 );
        }
    };
}

int signalUnitTest_main()
{
    UnitTest::TestSignal testSignal;
    HK_TEST(testSignal.getSlots() == HK_NULL);
    HK_TEST(testSignal.getNumSubscriptions() == 0);

    {
        UnitTest::SimpleSlot sSlot;
        for (int i = 0; i < 10; ++i)
        {
            HK_SUBSCRIBE_TO_SIGNAL(testSignal, &sSlot, SimpleSlot);
        }
        HK_TEST(testSignal.getNumSubscriptions() == 10);

        testSignal.fire(0xabcd);
        HK_TEST(testSignal.getNumSubscriptions() == 10);

        testSignal.unsubscribeAll(&sSlot);
        HK_TEST(testSignal.getNumSubscriptions() == 0);
    }

    {
        UnitTest::SimpleSlot sSlot;
        UnitTest::UnsubscribingSlot uSlot(testSignal);
        for (int i = 0; i < 10; ++i)
        {
            HK_SUBSCRIBE_TO_SIGNAL(testSignal, &sSlot, SimpleSlot);
            HK_SUBSCRIBE_TO_SIGNAL(testSignal, &uSlot, UnsubscribingSlot);
        }

        for (int i = 0; i < 10; ++i)
        {
            testSignal.unsubscribe(&sSlot, &UnitTest::SimpleSlot::onTestSignal);
            HK_TEST(testSignal.getNumSubscriptions() == 20 - i - 1);
        }

        for (hkSlot* slot = testSignal.getSlots(); slot; slot = slot->getNext())
        {
            HK_TEST(!slot->hasNoSubscription());
            HK_TEST(slot->m_object == &uSlot);
        }

        for (int i = 0; i < 10; ++i)
        {
            testSignal.unsubscribe(&uSlot, &UnitTest::UnsubscribingSlot::onTestSignal);
            HK_TEST(testSignal.getNumSubscriptions() == 10 - i - 1);
        }

        HK_TEST(testSignal.getNumSubscriptions() == 0);
    }

    {
        UnitTest::SimpleSlot sSlot;
        UnitTest::UnsubscribingSlot uSlot(testSignal);
        for (int i = 0; i < 10; ++i)
        {
            HK_SUBSCRIBE_TO_SIGNAL(testSignal, &sSlot, SimpleSlot);
            HK_SUBSCRIBE_TO_SIGNAL(testSignal, &uSlot, UnsubscribingSlot);
        }

        testSignal.fire(0xabcd);
        testSignal.fire(0xabcd);
        HK_TEST(testSignal.getNumSubscriptions() == 10);

        for (hkSlot* slot = testSignal.getSlots(); slot; slot = slot->getNext())
        {
            HK_TEST(!slot->hasNoSubscription());
            HK_TEST(slot->m_object == &sSlot);
        }

        testSignal.unsubscribeAll(&sSlot);
        HK_TEST(testSignal.getNumSubscriptions() == 0);
    }

    {
        UnitTest::SignalMergeTest mergeTests;
        mergeTests.run();
    }

    return 0;
}

HK_TEST_REGISTER(signalUnitTest_main, "Fast", "Common/Test/UnitTest/Base/", __FILE__);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
