// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/UnitTest/Types/ScopedPtrTest.h>
#include <Common/Base/UnitTest/UnitTestUtils.h>

#define HK_TEST_RETURN(exp) \
    if(!HK_TEST(exp)) { return 0; }


int scopedPtrTest_main()
{
    using namespace hkScopedPtrTest;

     hkDisableError allowGlobalNew(0xf0c34ded); // Test calls new int

    {
        hkScopedPtr<int> ptr;

        HK_TEST_RETURN(!ptr);
        HK_TEST_RETURN(ptr == HK_NULL);
        HK_TEST_RETURN(ptr.get() == HK_NULL);
        HK_TEST_RETURN(ptr == ptr);

        int* nullint = HK_NULL;
        HK_TEST_RETURN(ptr == nullint);
        HK_TEST_RETURN(nullint == ptr);

        int nonnullint;
        HK_TEST_RETURN(ptr != &nonnullint);
        HK_TEST_RETURN(&nonnullint != ptr);

        ptr.reset(new int(42));
        HK_TEST_RETURN(ptr);
        HK_TEST_RETURN(ptr != HK_NULL);
        HK_TEST_RETURN(ptr.get() != HK_NULL);

        HK_TEST_RETURN(*ptr == 42);
        ++*ptr;
        HK_TEST_RETURN(*ptr == 43);

        ptr.reset(HK_NULL);

        HK_TEST_RETURN(!ptr);
        HK_TEST_RETURN(ptr == HK_NULL);
        HK_TEST_RETURN(ptr.get() == HK_NULL);
    }

    {
        Foo::wasDeleted = false;
        hkScopedPtr<Foo> ptr(new Foo());
    }
    HK_TEST_RETURN(Foo::wasDeleted);

    {
        Foo::wasDeleted = false;
        hkScopedPtr<Foo> ptr;

        hkReflect::Var v(&ptr);
        hkReflect::PointerVar pv = v;
        HK_TEST_RETURN(pv);

        hkReflect::Var target(new Foo);
        pv.setValue(target);
        HK_TEST_RETURN(pv.getValue() == target);
        HK_TEST_RETURN(ptr.get() == target.getAddress());

        pv.setValue(hkReflect::Var());
        HK_TEST_RETURN(Foo::wasDeleted);
        HK_TEST_RETURN(pv.getValue().getAddress() == HK_NULL);
        HK_TEST_RETURN(ptr.get() == HK_NULL);
    }

    {  // Move-construct: empty source
        hkScopedPtr<int> src;
        hkScopedPtr<int> dst(hk::move(src));
        HK_TEST_RETURN(!src);
        HK_TEST_RETURN(!dst);
    }
    {  // Move-construct: ownership transfer
        hkScopedPtr<int> src(new int(42));
        hkScopedPtr<int> dst(hk::move(src));
        HK_TEST_RETURN(!src);
        HK_TEST_RETURN(dst);
        HK_TEST_RETURN(*dst == 42);
    }
    {  // Move-assign: ownership transfer
        hkScopedPtr<int> src(new int(42));
        hkScopedPtr<int> dst;
        dst = hk::move(src);
        HK_TEST_RETURN(!src);
        HK_TEST_RETURN(dst);
        HK_TEST_RETURN(*dst == 42);
    }
    {  // Move-assign: release the previous value
        Foo::wasDeleted = false;
        hkScopedPtr<Foo> src;
        hkScopedPtr<Foo> dst(new Foo());
        dst = hk::move(src);
        HK_TEST_RETURN(Foo::wasDeleted);
        HK_TEST_RETURN(!src);
        HK_TEST_RETURN(!dst);
    }
    {  // Move-assign: self-assignment
        Foo::wasDeleted = false;
        hkScopedPtr<Foo> src(new Foo());
        src = hk::move(src);
        HK_TEST_RETURN(!Foo::wasDeleted);
        HK_TEST_RETURN(src);
    }
    {  // swap
        auto ptrA = hk::makeUnique<int>(111);
        auto ptrB = hk::makeUnique<int>(222);
        swap(ptrA, ptrB);
        HK_TEST_RETURN(ptrA);
        HK_TEST_RETURN(ptrB);
        HK_TEST_RETURN(*ptrA == 222);
        HK_TEST_RETURN(*ptrB == 111);
    }
    {  // hk::makeUnique: construction
        auto ptr = hk::makeUnique<int>(42);
        HK_TEST_RETURN(ptr);
        HK_TEST_RETURN(*ptr == 42);
    }
    {  // hk::makeUnique: forwarding
        using namespace UnitTest;
        ForwardingTestingHelper src;

        auto dst = hk::makeUnique<ForwardingTestingHelper>(
            hk::move(src.t1),
            hk::move(src.t2),
            hk::move(src.t3),
            hk::move(src.t4),
            hk::move(src.t5));
        HK_TEST_RETURN(dst);
        HK_TEST_RETURN(dst->isEverythingMoveConstructed());
        HK_TEST_RETURN(src.isEverythingMovedFrom());
    }
    return 0;
}

HK_TEST_REGISTER(scopedPtrTest_main, "Fast", "Common/Test/UnitTest/Base/", __FILE__);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
