// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>

#include <Common/Base/UnitTest/Types/PtrReferenceLogger.h>

namespace hkPtrLogging
{

PtrReferenceLogger::PtrReferenceLogger(Log& log, const Value& value)
    : m_value(value), m_log(&log)
{
    m_log->pushBack(Event::NormallyConstructed);
}

PtrReferenceLogger::PtrReferenceLogger(Log& log, Value&& value)
    : m_value(value), m_log(&log)

{
    m_log->pushBack(Event::NormallyConstructedWithRValue);
}

PtrReferenceLogger::PtrReferenceLogger(const PtrReferenceLogger& other)
    : m_value(other.m_value), m_log(other.m_log)
{
    m_log->pushBack(Event::CopyConstructed);
}

PtrReferenceLogger::PtrReferenceLogger(PtrReferenceLogger&& other)
    : m_value(other.m_value), m_log(other.m_log)
{
    other.m_value = Value::Nothing;
    m_log->pushBack(Event::MoveConstructed);
}

PtrReferenceLogger& PtrReferenceLogger::operator=(const PtrReferenceLogger& other)
{
    // m_log stays the same
    m_value = other.m_value;
    m_log->pushBack(Event::CopyAssigned);
    return *this;
}

PtrReferenceLogger& PtrReferenceLogger::operator=(PtrReferenceLogger&& other)
{
    // m_log stays the same
    m_value = other.m_value;
    other.m_value = Value::Nothing;
    m_log->pushBack(Event::MoveAssigned);
    return *this;
}

PtrReferenceLogger::~PtrReferenceLogger()
{
    m_log->pushBack(Event::Destructed);
}

void PtrReferenceLogger::onReferenceAdded() const
{
    m_log->pushBack(Event::ReferenceAdded);
}

void PtrReferenceLogger::onReferenceRemoved() const
{
    m_log->pushBack(Event::ReferenceRemoved);
}

}  // namespace hkPtrTypes

namespace hkPtrTypes
{

    template<>
    void s_addReferenceToPointed<hkPtrLogging::PtrReferenceLogger>(const hkRefPtr<hkPtrLogging::PtrReferenceLogger>& ptr)
    {
        ptr->onReferenceAdded();
        castToRefObj(ptr.val())->addReference();
    }

    template<>
    void s_removeReferenceFromPointed<hkPtrLogging::PtrReferenceLogger>(const hkRefPtr<hkPtrLogging::PtrReferenceLogger>& ptr)
    {
        // hkRefPtr calls this even if the pointer in the hkRefPtr is already null
        if (ptr)
        {
            ptr->onReferenceRemoved();
            castToRefObj(ptr.val())->removeReference();
        }
    }

}  // namespace hkPtrTypes

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
