// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/Types/Geometry/Plane/hkPlane.h>

int plane_main()
{
    hkPlane p1;
    p1.m_equation.set(0.0f, 2.0f, 0.0f);
    HK_TEST(p1.getDistance() == hkSimdReal_0);

    p1.normalize();
    HK_TEST(hkMath::abs(p1.m_equation(1) - 1.0f) <= HK_REAL_EPSILON);

    // Test half space
    hkVector4 pt1;
    pt1.set(1.0f, 2.0f, 0.0f);
    HK_TEST(p1.planePointDistance(pt1).isGreaterZero());

    hkVector4 pt2;
    pt2.set(1.0f, -1.0f, 0.0f);
    HK_TEST(p1.planePointDistance(pt2).isLessZero());

    // Test parallel planes - should give no intersection
    hkPlane p2;     p2.m_equation.set(0.0f, 4.0f, 0.0f);
    hkPlane p3;     p3.m_equation.set(0.0f, -1.0f, 0.0f);

    hkVector4 result;
    HK_TEST(!hkPlane::intersectThreePlanes(p1, p2, p3, result).isSuccess());

    // Non - parallel planes
    p2.m_equation.set(1.0f, 0.f, 0.0f);
    p3.m_equation.set(1.0f, 0.f, 1.0f);
    HK_TEST(hkPlane::intersectThreePlanes(p1, p2, p3, result).isSuccess());

    return 0;
}

HK_TEST_REGISTER(plane_main, "Fast", "Common/Test/UnitTest/Base/", __FILE__ );

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
