// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/Types/Geometry/Frustum/hkFrustum.h>
#include <Common/Base/Math/Matrix/hkMatrix4Util.h>
#include <Common/Base/Types/Geometry/Aabb/hkAabb.h>
#include <Common/Base/Types/Geometry/Sphere/hkSphere.h>


int frustum_main()
{
#if defined(HK_REAL_IS_FLOAT)
    // Run the tests for both depth range variants, hkMatrix4CameraUtil::ClipSpaceDepthRange::MinusOneToOne and hkMatrix4CameraUtil::ClipSpaceDepthRange::ZeroToOne.
    for ( int i = 0; i < 2; ++ i)
    {
        hkMatrix4CameraUtil::ClipSpaceDepthRange::Enum clipSpaceDepthRange = (hkMatrix4CameraUtil::ClipSpaceDepthRange::Enum)i;

        hkMatrix4 persp;
        hkMatrix4CameraUtil::setPerspectiveProjectionFromFovX(70.0f, 1280.0f / 720.0f, 0.3f, 500.0f, clipSpaceDepthRange, hkMatrix4CameraUtil::ClipSpaceYRange::MinusOneToOne, persp);

        hkMatrix4 view;
        view.setIdentity();

        hkMatrix4 viewPersp;
        viewPersp.setMul(persp, view);

        hkFrustum frustum;
        frustum.setFromViewProjection(viewPersp, clipSpaceDepthRange);

        hkAabb testAabb;
        testAabb.setEmpty();

        hkVector4 center;
        center.setZero();

        hkSimdReal radius = hkSimdReal::fromFloat(0.1f);

        testAabb.setFromCenterRadius(center, radius);

        HK_TEST(!frustum.containsOrIntersects(testAabb));

        hkSphere testSphere(center, radius);

        hkArray< hkVector4 > sphereSpecs;
        hkArray< bool > expectedResults;
        HK_TEST(!frustum.containsOrIntersects(testSphere));
        sphereSpecs.pushBack( testSphere.getPositionAndRadius() );
        expectedResults.pushBack( frustum.containsOrIntersects(testSphere) );

        radius = hkSimdReal::fromFloat(0.4f);

        testAabb.setFromCenterRadius(center, radius);
        HK_TEST(frustum.containsOrIntersects(testAabb));

        testSphere.setRadius(radius);
        HK_TEST(frustum.containsOrIntersects(testSphere));
        sphereSpecs.pushBack( testSphere.getPositionAndRadius() );
        expectedResults.pushBack( frustum.containsOrIntersects(testSphere) );

        // Test with look at matrix in direction of z axis
        hkVector4 start;
        start.setZero();

        hkVector4 target;
        target.set(0.0f, 0.0f, 1.0f);

        hkVector4 up;
        up.set(0.0f, 1.0f, 0.0f);

        hkMatrix4CameraUtil::setLookAtView(start, target, up, view);
        viewPersp.setMul(persp, view);
        frustum.setFromViewProjection(viewPersp, clipSpaceDepthRange);

        center.set(0.0f, 0.0f, 100.0f);
        radius = hkSimdReal::fromFloat(20.0f);

        testAabb.setFromCenterRadius(center, radius);
        HK_TEST(frustum.containsOrIntersects(testAabb));

        testSphere.setPositionAndRadius(center, radius);
        HK_TEST(frustum.containsOrIntersects(testSphere));
        sphereSpecs.pushBack( testSphere.getPositionAndRadius() );
        expectedResults.pushBack( frustum.containsOrIntersects(testSphere) );


        center.set(0.0f, 0.0f, 600.0f); // With far plane at 500 this shouldn't be visible

        testAabb.setFromCenterRadius(center, radius);
        HK_TEST(!frustum.containsOrIntersects(testAabb));

        testSphere.setPositionAndRadius(center, radius);
        HK_TEST(!frustum.containsOrIntersects(testSphere));
        sphereSpecs.pushBack( testSphere.getPositionAndRadius() );
        expectedResults.pushBack( frustum.containsOrIntersects(testSphere) );


        center.set(0.0f, 1000.0f, 100.0f); // Shouldn't be visible

        testAabb.setFromCenterRadius(center, radius);
        HK_TEST(!frustum.containsOrIntersects(testAabb));

        testSphere.setPositionAndRadius(center, radius);
        HK_TEST(!frustum.containsOrIntersects(testSphere));
        sphereSpecs.pushBack( testSphere.getPositionAndRadius() );
        expectedResults.pushBack( frustum.containsOrIntersects(testSphere) );


        center.set(0.0f, -1000.0f, 100.0f); // Shouldn't be visible

        testAabb.setFromCenterRadius(center, radius);
        HK_TEST(!frustum.containsOrIntersects(testAabb));

        testSphere.setPositionAndRadius(center, radius);
        HK_TEST(!frustum.containsOrIntersects(testSphere));
        sphereSpecs.pushBack( testSphere.getPositionAndRadius() );
        expectedResults.pushBack( frustum.containsOrIntersects(testSphere) );


        center.set(0.0f, 00.0f, -30.0f); // Shouldn't be visible because behind near plane

        testAabb.setFromCenterRadius(center, radius);
        HK_TEST(!frustum.containsOrIntersects(testAabb));

        testSphere.setPositionAndRadius(center, radius);
        HK_TEST(!frustum.containsOrIntersects(testSphere));
        sphereSpecs.pushBack( testSphere.getPositionAndRadius() );
        expectedResults.pushBack( frustum.containsOrIntersects(testSphere) );
    }
#endif
    return 0;
}

HK_TEST_REGISTER(frustum_main, "Fast", "Common/Test/UnitTest/Base/", __FILE__ );

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
