// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>

// This file tests that we can access and update enums using a statically determined integral type.

namespace
{
    // This enum has values which force it to be at least as capacious as the type T.
    template<typename T, bool isSigned> struct EnumLike { };
    template<typename T> struct EnumLike<T, true> {
        enum TestEnum
        {
            A_VAL = T(0),
            B_VAL = T(T(1) << ((sizeof(T) * 8) - 2)),
            C_VAL = T(-(T(1) << ((sizeof(T) * 8) - 2)))
        };
    };

    template<typename T> struct EnumLike<T, false> {
        enum TestEnum
        {
            A_VAL = T(0),
            B_VAL = T(T(1) << ((sizeof(T) * 8) - 2)),
            C_VAL = T(T(1) << ((sizeof(T) * 8) - 1))
        };
    };

    template<typename T>
    static void testEnumLike()
    {
        // The test enum has values which force it to be at least as capacious as the type T.
        typedef EnumLike<T, hkTrait::IsSigned<T>::result> EnumLike;
        typedef typename EnumLike::TestEnum TestEnum;

        // Note that the matching int type is not guaranteed to be the same as T.
        typedef typename hkTrait::MatchingIntType<sizeof(TestEnum), hkTrait::IsSigned<TestEnum>::result>::IntType IntType;

        // A local of the enum type.
        TestEnum e;

        // The local's memory, viewed as an instance of our statically determined IntType.
        IntType* eAsIntType = reinterpret_cast<IntType*>(&e);

        {
            // Test that an existing value is seen as the correct value through the IntType.
            e = EnumLike::A_VAL;
            HK_TEST( *eAsIntType == IntType(EnumLike::A_VAL) );

            // Test that assignment via the IntType leaves the enum in the correct state.
            e = EnumLike::C_VAL;
            *eAsIntType = IntType(EnumLike::A_VAL);
            HK_TEST( e == EnumLike::A_VAL );
        }

        {
            // Test that an existing value is seen as the correct value through the IntType.
            e = EnumLike::B_VAL;
            HK_TEST( *eAsIntType == IntType(EnumLike::B_VAL) );

            // Test that assignment via the IntType leaves the enum in the correct state.
            e = EnumLike::C_VAL;
            *eAsIntType = IntType(EnumLike::B_VAL);
            HK_TEST( e == EnumLike::B_VAL );
        }

        {
            // Test that an existing value is seen as the correct value through the IntType.
            e = EnumLike::C_VAL;
            HK_TEST( *eAsIntType == IntType(EnumLike::C_VAL) );

            // Test that assignment via the IntType leaves the enum in the correct state.
            e = EnumLike::A_VAL;
            *eAsIntType = IntType(EnumLike::C_VAL);
            HK_TEST( e == EnumLike::C_VAL );
        }
    };
}

int enumTraitTest_main()
{
    testEnumLike<hkInt8>();
    testEnumLike<hkUint8>();
    testEnumLike<hkInt16>();
    testEnumLike<hkUint16>();
    testEnumLike<hkInt32>();
    testEnumLike<hkUint32>();
    // Not necessarily supported.
    //testEnumLike<hkInt64>();
    //testEnumLike<hkUint64>();

    return 0;
}

HK_TEST_REGISTER(enumTraitTest_main,     "Fast", "Common/Test/UnitTest/Base/",     __FILE__    );

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
