// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/Types/Color/hkColor.h>

int colorTest_main()
{
    {
        hkColor::Argb notRed = 0xff00ffff;
        HK_TEST( hkColor::getRedAsChar(notRed) == 0x0 );
        HK_TEST( hkColor::getRedAsFloat(notRed) == 0.f );
        hkColor::Argb notGreen = 0xffff00ff;
        HK_TEST( hkColor::getGreenAsChar(notGreen) == 0x0 );
        HK_TEST( hkColor::getGreenAsFloat(notGreen) == 0.f );
        hkColor::Argb notBlue = 0xffffff00;
        HK_TEST( hkColor::getBlueAsChar(notBlue) == 0x0 );
        HK_TEST( hkColor::getBlueAsFloat(notBlue) == 0.f );
        hkColor::Argb notAlpha = 0x00ffffff;
        HK_TEST( hkColor::getAlphaAsChar(notAlpha) == 0x0 );
        HK_TEST( hkColor::getAlphaAsFloat(notAlpha) == 0.f );

        hkColor::Argb r = 0x00ff0000;
        HK_TEST( hkColor::getRedAsChar(r) == 0xff );
        HK_TEST( hkMath::equal(hkColor::getRedAsFloat(r), 1.f, 0.001f ) );
        hkColor::Argb g = 0x0000ff00;
        HK_TEST( hkColor::getGreenAsChar(g) == 0xff );
        HK_TEST( hkMath::equal(hkColor::getGreenAsFloat(g), 1.f, 0.001f ) );
        hkColor::Argb b = 0x000000ff;
        HK_TEST( hkColor::getBlueAsChar(b) == 0xff );
        HK_TEST( hkMath::equal(hkColor::getBlueAsFloat(b), 1.f, 0.001f ) );
        hkColor::Argb a = 0xff000000;
        HK_TEST( hkColor::getAlphaAsChar(a) == 0xff );
        HK_TEST( hkMath::equal(hkColor::getAlphaAsFloat(a), 1.f, 0.001f ) );

    }

    {
        hkColorf w(1.f, 1.f, 1.f, 1.f);
        hkColorUbGamma cg = w;
        HK_TEST(cg == hkColorUbGamma(0xff, 0xff, 0xff, 0xff));

        hkColorf wh(2.f, 2.f, 2.f, 2.f);
        cg = wh;
        HK_TEST(cg == hkColorUbGamma(0xff, 0xff, 0xff, 0xff)); // as meant to clamp

        hkColorf whh(0.5f, 0.f, 0.5f, 0.f);
        cg = whh;
        HK_TEST(cg == hkColorUbGamma(0xbc, 0x00, 0xbc, 0x00));

        hkColorf whf(-0.1f, -100.f, 100.0f, 0.5f);
        cg = whf;
        HK_TEST(cg == hkColorUbGamma(0x00, 0x00, 0xff, 0x80));
    }

    {
        const hkUint8 rgba[] = { 0x01, 0x02, 0x03, 0x04 };
        hkColorf cf(hkColorUbLinear::fromBuffer<hkColorUbLinear::ORDER_RGBA>(rgba));
        hkColorf t; t.set( ((float)rgba[0]) / 255.f, ((float)rgba[1]) / 255.f, ((float)rgba[2]) / 255.f, ((float)rgba[3]) / 255.f );
        hkColorf diff; diff.setSub(t,cf);
        hkColorf diffA; diffA.setAbs(diff);
        HK_TEST( diffA.lessEqual( hkVector4f::getConstant<HK_QUADREAL_INV_255>() ).allAreSet<hkVector4ComparisonMask::MASK_XYZW>()  );

        HK_TEST( cf.compare( cf, hkSimdFloat32::getConstant<HK_QUADREAL_INV_255>(), 4 ));
        HK_TEST(cf.compare(t, hkSimdFloat32::getConstant<HK_QUADREAL_INV_255>(), 4));

        hkColorf tc1;
        hkColor::getRgbaAsVector4(0x04010203, tc1);
        hkColorf tc2;
        hkColor::getRgbaAsVector4(rgba, tc2);
        HK_TEST( tc1.equal(tc2).allAreSet<hkVector4ComparisonMask::MASK_XYZW>() );
        HK_TEST(cf.compare(tc2, hkSimdFloat32::getConstant<HK_QUADREAL_INV_255>(), 4));

    }


    {
        // Invariant: R=0x12, G=0x23, B=0x34, A=0x45
        const hkUint32 colorArgb = 0x45122334;
        const hkUint32 colorAbgr = 0x45342312;
        const hkUint32 colorRgba = 0x12233445;
        const hkUint32 colorBgra = 0x34231245;

        {
            const hkColorUbGamma color = hkColorUbGamma::fromUint32<hkColorUbGamma::ORDER_ARGB>(colorArgb);
            HK_TEST(color.r == 0x12 && color.g == 0x23 && color.b == 0x34 && color.a == 0x45);
            const hkUint32 colorOut = color.toUint32<hkColorUbGamma::ORDER_ARGB>();
            HK_TEST(colorOut == colorArgb);
        }

        {
            const hkColorUbGamma color = hkColorUbGamma::fromUint32<hkColorUbGamma::ORDER_ABGR>(colorAbgr);
            HK_TEST(color.r == 0x12 && color.g == 0x23 && color.b == 0x34 && color.a == 0x45);
            const hkUint32 colorOut = color.toUint32<hkColorUbGamma::ORDER_ABGR>();
            HK_TEST(colorOut == colorAbgr);
        }

        {
            const hkColorUbGamma color = hkColorUbGamma::fromUint32<hkColorUbGamma::ORDER_RGBA>(colorRgba);
            HK_TEST(color.r == 0x12 && color.g == 0x23 && color.b == 0x34 && color.a == 0x45);
            const hkUint32 colorOut = color.toUint32<hkColorUbGamma::ORDER_RGBA>();
            HK_TEST(colorOut == colorRgba);
        }

        {
            const hkColorUbGamma color = hkColorUbGamma::fromUint32<hkColorUbGamma::ORDER_BGRA>(colorBgra);
            HK_TEST(color.r == 0x12 && color.g == 0x23 && color.b == 0x34 && color.a == 0x45);
            const hkUint32 colorOut = color.toUint32<hkColorUbGamma::ORDER_BGRA>();
            HK_TEST(colorOut == colorBgra);
        }
    }

    {
        // Invariant: R=0x12, G=0x23, B=0x34, A=0x45
        const hkUint8 colorArgb[] = { 0x45, 0x12, 0x23, 0x34 };
        const hkUint8 colorAbgr[] = { 0x45, 0x34, 0x23, 0x12 };
        const hkUint8 colorRgba[] = { 0x12, 0x23, 0x34, 0x45 };
        const hkUint8 colorBgra[] = { 0x34, 0x23, 0x12, 0x45 };

        {
            const hkColorUbGamma color = hkColorUbGamma::fromBuffer<hkColorUbGamma::ORDER_ARGB>(colorArgb);
            HK_TEST(color.r == 0x12 && color.g == 0x23 && color.b == 0x34 && color.a == 0x45);
            hkUint8 colorOut[4];
            color.toBuffer<hkColorUbGamma::ORDER_ARGB>(colorOut);
            for (int i = 0; i < 4; ++i)
            {
                HK_TEST(colorOut[i] == colorArgb[i]);
            }
        }

        {
            const hkColorUbGamma color = hkColorUbGamma::fromBuffer<hkColorUbGamma::ORDER_ABGR>(colorAbgr);
            HK_TEST(color.r == 0x12 && color.g == 0x23 && color.b == 0x34 && color.a == 0x45);
            hkUint8 colorOut[4];
            color.toBuffer<hkColorUbGamma::ORDER_ABGR>(colorOut);
            for (int i = 0; i < 4; ++i)
            {
                HK_TEST(colorOut[i] == colorAbgr[i]);
            }
        }

        {
            const hkColorUbGamma color = hkColorUbGamma::fromBuffer<hkColorUbGamma::ORDER_RGBA>(colorRgba);
            HK_TEST(color.r == 0x12 && color.g == 0x23 && color.b == 0x34 && color.a == 0x45);
            hkUint8 colorOut[4];
            color.toBuffer<hkColorUbGamma::ORDER_RGBA>(colorOut);
            for (int i = 0; i < 4; ++i)
            {
                HK_TEST(colorOut[i] == colorRgba[i]);
            }
        }

        {
            const hkColorUbGamma color = hkColorUbGamma::fromBuffer<hkColorUbGamma::ORDER_BGRA>(colorBgra);
            HK_TEST(color.r == 0x12 && color.g == 0x23 && color.b == 0x34 && color.a == 0x45);
            hkUint8 colorOut[4];
            color.toBuffer<hkColorUbGamma::ORDER_BGRA>(colorOut);
            for (int i = 0; i < 4; ++i)
            {
                HK_TEST(colorOut[i] == colorBgra[i]);
            }
        }
    }

    {
        hkSimdFloat32 colorEpsilonSmall = hkSimdFloat32::fromFloat(0.0001f);
        hkSimdFloat32 colorEpsilonLarge = hkSimdFloat32::getConstant<HK_QUADREAL_INV_255>();

        hkColorf colorBlack1(hkColors::Black);
        hkColorf colorBlack2(0.0f, 0.0f, 0.0f, 1.0f);
        HK_TEST(colorBlack1.compare(colorBlack2, colorEpsilonSmall, 4));

        hkColorf colorWhite1(hkColors::White);
        hkColorf colorWhite2(1.0f, 1.0f, 1.0f, 1.0f);
        HK_TEST(colorWhite1.compare(colorWhite2, colorEpsilonSmall, 4));

        hkColorf colorGreyLinear1(hkColorUbLinear(0x7F, 0x7F, 0x7F));
        hkColorf colorGreyLinear2(0.5f, 0.5f, 0.5f, 1.0f);
        HK_TEST(colorGreyLinear1.compare(colorGreyLinear2, colorEpsilonLarge, 4));
    }

    return 0;
}

HK_TEST_REGISTER(colorTest_main,   "Fast", "Common/Test/UnitTest/Base/",   __FILE__    );

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
