// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>

#include <Common/Base/Thread/ThreadSafeIntegerPool/hkThreadSafeIntegerPool.h>
#include <Common/Base/Thread/Pool/hkCpuThreadPool.h>
#include <Common/Base/System/Stopwatch/hkStopwatch.h>
#include <Common/Base/System/Hardware/hkHardwareInfo.h>

namespace HK_UNITY_ANONYMOUS_NAMESPACE
{
    static const int s_poolCapacity = 128;
    typedef hkThreadSafeIntegerPool<s_poolCapacity> IntPool;

    static void HK_CALL threadMain( void* workload )
    {
        IntPool& pool = *(IntPool*)workload;

        // Allocate and free in a ~random pattern for 50 milli seconds
        hkStopwatch stopWatch;
        stopWatch.start();
        while( stopWatch.getElapsedSeconds() < .05f )
        {
            int i1 = pool.allocate();
            int i2 = pool.allocate();
            int i3 = pool.allocate();
            pool.free(i1);
            pool.free(i3);
            int i4 = pool.allocate();
            pool.free(i4);
            int i5 = pool.allocate();
            pool.free(i2);
            pool.free(i5);
        }
    }
}

int threadSafeIntegerPoolTest_main()
{
    HK_UNITY_USING_ANONYMOUS_NAMESPACE;

    IntPool intPool;

    //
    // Single threaded tests
    //

    // Allocate then free all the elements
    for( int i=0; i<s_poolCapacity; i++ )
    {
        HK_TEST( intPool.allocate() == i );
    }
    intPool.checkConsistency();
    for( int i=s_poolCapacity-1; i>=0; i-- )
    {
        intPool.free( i );
    }
    intPool.checkConsistency();

    // Same again, but free in reverse order
    for( int i=0; i<s_poolCapacity; i++ )
    {
        HK_TEST( intPool.allocate() == i );
    }
    intPool.checkConsistency();
    for( int i=0; i<s_poolCapacity; i++ )
    {
        intPool.free( i );
    }
    intPool.checkConsistency();

    //
    // Multi threaded tests
    //

    // Start lots of threads working on it in parallel
    hkCpuThreadPoolCinfo cinfo;
    cinfo.m_numThreads = hkHardwareInfo::getNumHardwareThreads() - 1;
    hkCpuThreadPool threadPool( cinfo );
    threadPool.processWorkLoad( &threadMain, &intPool );
    threadPool.waitForCompletion();

    intPool.checkConsistency();

    //
    // More single threaded tests
    //

    // Reset then allocate all the elements again
    intPool.reset();
    for( int i=0; i<s_poolCapacity; i++ )
    {
        HK_TEST( intPool.allocate() == i );
    }
    intPool.checkConsistency();
    for( int i=s_poolCapacity-1; i>=0; i-- )
    {
        intPool.free( i );
    }
    intPool.checkConsistency();

    return 0;
}

HK_TEST_REGISTER(threadSafeIntegerPoolTest_main, "Fast", "Common/Test/UnitTest/Base/", __FILE__);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
