// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/Thread/Atomic/hkAtomicPrimitives.h>

struct DummyAtomicStruct
{
    HK_DECLARE_CLASS(DummyAtomicStruct, New, Pod);

    HK_INLINE DummyAtomicStruct(int aa, int bb)
    :   m_valA(hkUint16(aa))
    ,   m_valB(hkUint16(bb))
    {}

    // Don't add an operator ==, because we want to make sure the atomic
    // operations work with opaque data.
    bool equals(DummyAtomicStruct b) const
    {
        return m_valA == b.m_valA && m_valB == b.m_valB;
    }

    hkUint16 m_valA;
    hkUint16 m_valB;
};

// Mainly to see if it compiles, this doesn't actually test the memory ordering
// thing, which we can't do deterministically, let alone in a single thread.
template <typename T>
static void testLoadStore()
{
    T val = 0;

    hkAtomic::storeRelaxed<T>(&val, 1);
    HK_TEST(hkAtomic::loadRelaxed<T>(&val) == 1);

    hkAtomic::storeRelease<T>(&val, 2);
    HK_TEST(hkAtomic::loadAcquire<T>(&val) == 2);

    hkAtomic::storeSeqCst<T>(&val, 3);
    HK_TEST(hkAtomic::loadSeqCst<T>(&val) == 3);
}

static void testLoadStoreStruct()
{
    DummyAtomicStruct val(0, 0);

    hkAtomic::storeRelaxed<DummyAtomicStruct>(&val, DummyAtomicStruct(1, 1));
    HK_TEST(hkAtomic::loadRelaxed<DummyAtomicStruct>(&val).equals(DummyAtomicStruct(1, 1)));

    hkAtomic::storeRelease<DummyAtomicStruct>(&val, DummyAtomicStruct(2, 2));
    HK_TEST(hkAtomic::loadAcquire<DummyAtomicStruct>(&val).equals(DummyAtomicStruct(2, 2)));

    hkAtomic::storeSeqCst<DummyAtomicStruct>(&val, DummyAtomicStruct(3, 3));
    HK_TEST(hkAtomic::loadSeqCst<DummyAtomicStruct>(&val).equals(DummyAtomicStruct(3, 3)));
}

int atomicPrimitivesTest_main()
{
    DummyAtomicStruct testStorage(0, 0);
    DummyAtomicStruct valA(1, 0);
    DummyAtomicStruct valB(0, 1);
    DummyAtomicStruct valC(1, 1);
    DummyAtomicStruct valD(0, 0);

    HK_TEST(hkAtomic::compareAndSwap(&testStorage, valD, valA) == true);
    HK_TEST(hkAtomic::compareAndSwap(&testStorage, valD, valA) == false);

    HK_TEST(hkAtomic::compareAndSwap(&testStorage, valA, valB) == true);
    HK_TEST(hkAtomic::compareAndSwap(&testStorage, valB, valC) == true);
    HK_TEST(hkAtomic::compareAndSwap(&testStorage, valC, valD) == true);
    HK_TEST(hkAtomic::compareAndSwap(&testStorage, valC, valA) == false);

    testLoadStore<hkUint8>();
    testLoadStore<hkUint32>();
    testLoadStore<hkFloat32>();
    testLoadStoreStruct();

#if !defined(HK_ARCH_IA32) && !(defined(HK_ARCH_ARM) && !defined(HK_ARCH_ARM_64))
    testLoadStore<hkUint64>();
    testLoadStore<hkDouble64>();
#endif

    return 0;
}

HK_TEST_REGISTER(atomicPrimitivesTest_main, "Fast", "Common/Test/UnitTest/Base/", __FILE__);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
