// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/Reflection/ClangTest.h>
#include <Common/Base/UnitTest/Reflection/VarTest.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/UnitTest/Types/PropertyBagTest.h>
#include <Common/Base/UnitTest/String/stringformat.h>
#include <Common/Base/UnitTest/Types/ScopedPtrTest.h>

// Various static fields and functions from unit test classes are defined here
// Defining them in the unit test cpp would cause the tests to be linked unnecessarily

int UnitTestClang::TestCastAttr::s_int = 0;
float UnitTestClang::TestCastAttr::s_float = 0;
int UnitTestClang::TestAccessAttribute::s_dummy = 0;
int UnitTestClang::AttrAccess::s_privateMember = 0;
int UnitTestClang::AttrAccess::s_protectedMember = 0;
int UnitTestClang::NeedsValidation::s_validations = 0;

hkUlong VarTest::CustomMethods::s_lastDeleted;

void VarTest::InPadding::operator=(const VarTest::InPadding& rhs)
{
    // Test that nothing has been memcpied on this
    HK_TEST_EQ(m_data, 0);
    m_data = rhs.m_data;
}

namespace PropertyBagTest
{
    ComplexProperty::ComplexProperty()
        : m_afterReflectNewCalled(false)
    {
    }

    void ComplexProperty::afterReflectNew()
    {
        m_afterReflectNewCalled = true;
    }
}

void HK_CALL UnitTest::CustomFormatter::toString(const hkReflect::Var& var, hkStringBuf& sb, const hkStringView& extra)
{
    const CustomFormatter* c = var.dynCast<CustomFormatter>();
    HK_ASSERT_NO_MSG(0x2c2e8c54, c);
    // everything after the ':' in the format string is passed through in extra
    if (extra == "s1")
    {
        sb.printf("(%i%i) %i%i%i %i%i%i%i", c->m_buf[0], c->m_buf[1], c->m_buf[2], c->m_buf[3], c->m_buf[4], c->m_buf[5], c->m_buf[6], c->m_buf[7], c->m_buf[8]);
    }
    else
    {
        sb.printf("%i%i-%i%i%i-%i%i%i%i", c->m_buf[0], c->m_buf[1], c->m_buf[2], c->m_buf[3], c->m_buf[4], c->m_buf[5], c->m_buf[6], c->m_buf[7], c->m_buf[8]);
    }
}

bool hkScopedPtrTest::Foo::wasDeleted = false;

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
