// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <ctype.h>

namespace hkStringTest
{
    void test_toUpper()
    {
        // this only tests the ASCII range
        for (unsigned char i = 0; i < 128; ++i)
        {
            HK_TEST(hkString::toUpper(static_cast<char>(i)) == toupper(static_cast<char>(i)));
        }
    }

    void test_toLower()
    {
        // this only tests the ASCII range
        for (unsigned char i = 0; i < 128; ++i)
        {
            HK_TEST(hkString::toLower(static_cast<char>(i)) == tolower(static_cast<char>(i)));
        }
    }

    void test_isNullOrEmpty()
    {
        HK_TEST(hkString::isNullOrEmpty((char*) nullptr) == true);
        HK_TEST(hkString::isNullOrEmpty("") == true);

        // all other characters are not empty
        for (unsigned char c = 1; c < 255; c++)
        {
            HK_TEST(hkString::isNullOrEmpty(reinterpret_cast<char*>(&c)) == false);
        }
    }

    void test_strCmp()
    {
        // Not supported / asserts.
        //HK_TEST(hkString::strCmp(nullptr, nullptr) == 0);
        //HK_TEST(hkString::strCmp(nullptr, "") == 0);
        //HK_TEST(hkString::strCmp("", nullptr) == 0);
        HK_TEST(hkString::strCmp("", "") == 0);

        // Not supported / asserts.
        HK_TEST(hkString::strCmp("abc", "abc") == 0);
        HK_TEST(hkString::strCmp("abc", "abcd") < 0);
        HK_TEST(hkString::strCmp("abcd", "abc") > 0);

        //HK_TEST(hkString::Compare("a", nullptr) > 0);
        //HK_TEST(hkString::Compare(nullptr, "a") < 0);
    }

    void test_strNcmp()
    {
        // Not supported / asserts.
        //HK_TEST(hkString::strNcmp(nullptr, nullptr, 1) == 0);
        //HK_TEST(hkString::strNcmp(nullptr, "", 1) == 0);
        //HK_TEST(hkString::strNcmp("", nullptr, 1) == 0);
        HK_TEST(hkString::strNcmp("", "", 1) == 0);

        // as long as we compare 'nothing' the strings must be equal
        HK_TEST(hkString::strNcmp("abc", "", 0) == 0);
        HK_TEST(hkString::strNcmp("", "abc", 0) == 0);
        // Not supported / asserts.
        //HK_TEST(hkString::strNcmp("abc", nullptr, 0) == 0);
        //HK_TEST(hkString::strNcmp(nullptr, "abc", 0) == 0);

        HK_TEST(hkString::strNcmp("abc", "abcdef", 1) == 0);
        HK_TEST(hkString::strNcmp("abc", "abcdef", 2) == 0);
        HK_TEST(hkString::strNcmp("abc", "abcdef", 3) == 0);
        HK_TEST(hkString::strNcmp("abc", "abcdef", 4) < 0);

        HK_TEST(hkString::strNcmp("abcdef", "abc", 1) == 0);
        HK_TEST(hkString::strNcmp("abcdef", "abc", 2) == 0);
        HK_TEST(hkString::strNcmp("abcdef", "abc", 3) == 0);
        HK_TEST(hkString::strNcmp("abcdef", "abc", 4) > 0);
    }

    void test_strCasecmp()
    {
        // Not supported / asserts.
        //HK_TEST(hkString::strCasecmp(nullptr, nullptr) == 0);
        //HK_TEST(hkString::strCasecmp(nullptr, "") == 0);
        //HK_TEST(hkString::strCasecmp("", nullptr) == 0);
        HK_TEST(hkString::strCasecmp("", "") == 0);

        HK_TEST(hkString::strCasecmp("abc", "aBc") == 0);
        HK_TEST(hkString::strCasecmp("ABC", "abcd") < 0);
        HK_TEST(hkString::strCasecmp("abcd", "ABC") > 0);

        // Not supported / asserts.
        //HK_TEST(hkString::strCasecmp("a", nullptr) > 0);
        //HK_TEST(hkString::strCasecmp(nullptr, "a") < 0);
    }

    void test_strNcasecmp()
    {
        // Not supported / asserts.
        //HK_TEST(hkString::strNcasecmp(nullptr, nullptr, 1) == 0);
        //HK_TEST(hkString::strNcasecmp(nullptr, "", 1) == 0);
        //HK_TEST(hkString::strNcasecmp("", nullptr, 1) == 0);
        HK_TEST(hkString::strNcasecmp("", "", 1) == 0);

        // as long as we compare 'nothing' the strings must be equal
        HK_TEST(hkString::strNcasecmp("abc", "", 0) == 0);
        HK_TEST(hkString::strNcasecmp("", "abc", 0) == 0);
        // Not supported / asserts.
        //HK_TEST(hkString::strNcasecmp("abc", nullptr, 0) == 0);
        //HK_TEST(hkString::strNcasecmp(nullptr, "abc", 0) == 0);

        HK_TEST(hkString::strNcasecmp("aBc", "abcdef", 1) == 0);
        HK_TEST(hkString::strNcasecmp("aBc", "abcdef", 2) == 0);
        HK_TEST(hkString::strNcasecmp("aBc", "abcdef", 3) == 0);
        HK_TEST(hkString::strNcasecmp("aBc", "abcdef", 4) < 0);

        HK_TEST(hkString::strNcasecmp("abcdef", "Abc", 1) == 0);
        HK_TEST(hkString::strNcasecmp("abcdef", "Abc", 2) == 0);
        HK_TEST(hkString::strNcasecmp("abcdef", "Abc", 3) == 0);
        HK_TEST(hkString::strNcasecmp("abcdef", "Abc", 4) > 0);
    }


    void test_strCpy()
    {
        char szDest[256] = "";

        // large enough
        hkString::strCpy(szDest, 256, "Test ABC");
        HK_TEST(hkString::strCmp(szDest, "Test ABC") == 0);

        // exactly fitting
        hkString::strCpy(szDest, 13, "Humpf, humpf");
        HK_TEST(hkString::strCmp(szDest, "Humpf, humpf") == 0);

        // too small - crashes with message
        //hkString::strCpy(szDest, 8, "Test ABC");
        //HK_TEST(hkString::strCmp(szDest, "Test AB") == 0);

        const char* szUTF8 = "ABC \xe6\x97\xa5\xd1\x88"; // contains 'ABC ' + two UTF-8 chars (first is three bytes, second is two bytes)

        // large enough
        hkString::strCpy(szDest, 256, szUTF8);
        HK_TEST(hkString::strCmp(szDest, szUTF8) == 0);

        // exactly fitting
        hkString::strCpy(szDest, 10, szUTF8);
        HK_TEST(hkString::strCmp(szDest, szUTF8) == 0);
    }

    void test_strNcpy()
    {
        char szDest[256] = "";

        hkString::strNcpy(szDest, 256, "Test ABC", 4);
        HK_TEST(hkString::strCmp(szDest, "Test") == 0);

        const char* szUTF8 = "ABC \xe6\x97\xa5\xd1\x88"; // contains 'ABC ' + two UTF-8 chars (first is three bytes, second is two bytes)

        hkString::strNcpy(szDest, 256, szUTF8, 6);
        HK_TEST(hkString::strNcmp(szDest, szUTF8, 6) == 0);

        hkString::strNcpy(szDest, 256, szUTF8, 5);
        HK_TEST(hkString::strNcmp(szDest, szUTF8, 5) == 0);

        hkString::strNcpy(szDest, 256, szUTF8, 4);
        HK_TEST(hkString::strNcmp(szDest, szUTF8, 4) == 0);

        hkString::strNcpy(szDest, 256, szUTF8, 1);
        HK_TEST(hkString::strNcmp(szDest, szUTF8, 1) == 0);

        hkString::strNcpy(szDest, 256, szUTF8, 0);
        HK_TEST(hkString::strNcmp(szDest, szUTF8, 1) == 0); // Untouched, same as before
    }

    void test_strLen()
    {
        // Asserts
        //HK_TEST(hkString::strLen((char*) nullptr), 0);

        // Counts the Bytes
        HK_TEST_EQ(hkString::strLen(""), 0);
        HK_TEST_EQ(hkString::strLen("a"), 1);
        HK_TEST_EQ(hkString::strLen("ab"), 2);
        HK_TEST_EQ(hkString::strLen("abc"), 3);
    }

    void test_atoi()
    {
        HK_TEST_EQ(hkString::atoi("1234"), 1234);
        HK_TEST_EQ(hkString::atoi("0"), 0);
        HK_TEST_EQ(hkString::atoi("-0"), 0);

        // This works, but doe to the implicit cast from unsigned to signed in the atoi implementation this is actually undefined behavior!
        //HK_TEST(hkString::atoi("-1") == -1);
        HK_TEST_EQ(hkString::atoi("+-1"), 0); // can't handle this case

        // todo: overflow check
        // Due to our implicit cast to signed in the atoi implementation this is actually undefined behavior!
    }

    void test_atoll()
    {
        HK_TEST_EQ(hkString::atoll("1234"), 1234);
        HK_TEST_EQ(hkString::atoll("0"), 0);
        HK_TEST_EQ(hkString::atoll("-0"), 0);

        HK_TEST_EQ(hkString::atoll("-1"), -1);
#if !defined(HK_PLATFORM_PS4)
        HK_TEST_EQ(hkString::atoll("+-1"), 0); // can't handle this case
#endif
        // todo: overflow check
    }

    void test_atoull()
    {
        HK_TEST_EQ(hkString::atoull("1234"), 1234);
        HK_TEST_EQ(hkString::atoull("0"), 0);
        HK_TEST_EQ(hkString::atoull("-0"), 0);

        HK_TEST_EQ(hkString::atoull("-1"), -1);
        hkInt64 vv = hkString::atoull("+-1");
        HK_TEST_EQ(vv, 0); // can't handle this case

        // todo: overflow check
    }

    void test_atof()
    {
        HK_TEST(hkString::atof("0") == 0.0f);
        HK_TEST(hkString::atof("-0.0f") == -0.0f);
        HK_TEST_FLOAT_EQ(hkString::atof("23.45"), 23.45f, 0.001f, "");
        HK_TEST(hkString::atof("-2345") == -2345.0f);
        HK_TEST_FLOAT_EQ(hkString::atof(".123456789"), 0.123456789f, 0.001f, "");
        HK_TEST(hkString::atof("+123E1") == 1230.0f);
    }

    void test_atod()
    {
        HK_TEST(hkString::atod("0") == 0.0);
        HK_TEST(hkString::atod("-0.0") == -0.0);
        HK_TEST_FLOAT_EQ(hkString::atod("23.45"), 23.45, 0.001, "");
        HK_TEST(hkString::atod("-2345") == -2345.0);
        HK_TEST_FLOAT_EQ(hkString::atod(".123456789"), 0.123456789, 0.001, "");
        HK_TEST(hkString::atod("+123E1") == 1230.0f);
    }

    void test_strStr()
    {
        const char* s0 = "abc";
        const char* s1("abc def ghi");

        HK_TEST(hkString::strStr(s0, s0) == s0);
        HK_TEST(hkString::strStr(s0, "") == s0);
        HK_TEST(hkString::strStr("", "abc") == nullptr);
        // Crashes with message.
        //HK_TEST(hkString::strStr("abc", nullptr) == nullptr);
        //HK_TEST(hkString::strStr(nullptr, "abc") == nullptr);

        HK_TEST(hkString::strStr(s1, "abc") == s1);
        HK_TEST(hkString::strStr(s1, "def") == &s1[4]);
        HK_TEST(hkString::strStr(s1, "ghi") == &s1[8]);
    }

    void test_beginsWith()
    {
        //HK_TEST(hkString::beginsWith(nullptr, nullptr) == true);
        //HK_TEST(hkString::beginsWith(nullptr, "") == true);
        //HK_TEST(hkString::beginsWith("", nullptr) == true);
        HK_TEST(hkString::beginsWith("", "") == true);

        //HK_TEST(hkString::beginsWith("abc", nullptr) == true);
        //HK_TEST(hkString::beginsWith(nullptr, "abc") == false);
        HK_TEST(hkString::beginsWith("abc", "") == true);
        HK_TEST(hkString::beginsWith("", "abc") == false);

        HK_TEST(hkString::beginsWith("abc", "abc") == true);
        HK_TEST(hkString::beginsWith("abcdef", "abc") == true);
        HK_TEST(hkString::beginsWith("abcdef", "Abc") == false);
    }

    void test_beginsWithCase()
    {
        //HK_TEST(hkString::beginsWithCase(nullptr, nullptr) == true);
        //HK_TEST(hkString::beginsWithCase(nullptr, "") == true);
        //HK_TEST(hkString::beginsWithCase("", nullptr) == true);
        HK_TEST(hkString::beginsWithCase("", "") == true);

        //HK_TEST(hkString::beginsWithCase("abc", nullptr) == true);
        //HK_TEST(hkString::beginsWithCase(nullptr, "abc") == false);
        HK_TEST(hkString::beginsWithCase("abc", "") == true);
        HK_TEST(hkString::beginsWithCase("", "abc") == false);

        HK_TEST(hkString::beginsWithCase("abc", "ABC") == true);
        HK_TEST(hkString::beginsWithCase("aBCdef", "abc") == true);
        HK_TEST(hkString::beginsWithCase("aBCdef", "bc") == false);
    }

    void test_endsWith()
    {
        //HK_TEST(hkString::endsWith(nullptr, nullptr) == true);
        //HK_TEST(hkString::endsWith(nullptr, "") == true);
        //HK_TEST(hkString::endsWith("", nullptr) == true);
        HK_TEST(hkString::endsWith("", "") == true);

        //HK_TEST(hkString::endsWith("abc", nullptr) == true);
        //HK_TEST(hkString::endsWith(nullptr, "abc") == false);
        HK_TEST(hkString::endsWith("abc", "") == true);
        HK_TEST(hkString::endsWith("", "abc") == false);

        HK_TEST(hkString::endsWith("abc", "abc") == true);
        HK_TEST(hkString::endsWith("abcdef", "def") == true);
        HK_TEST(hkString::endsWith("abcdef", "Def") == false);
        HK_TEST(hkString::endsWith("def", "abcdef") == false);
    }

    void test_endsWithCase()
    {
        //HK_TEST(hkString::endsWithCase(nullptr, nullptr) == true);
        //HK_TEST(hkString::endsWithCase(nullptr, "") == true);
        //HK_TEST(hkString::endsWithCase("", nullptr) == true);
        HK_TEST(hkString::endsWithCase("", "") == true);

        //HK_TEST(hkString::endsWithCase("abc", nullptr) == true);
        //HK_TEST(hkString::endsWithCase(nullptr, "abc") == false);
        HK_TEST(hkString::endsWithCase("abc", "") == true);
        HK_TEST(hkString::endsWithCase("", "abc") == false);

        HK_TEST(hkString::endsWithCase("abc", "abc") == true);
        HK_TEST(hkString::endsWithCase("abcdef", "def") == true);
        HK_TEST(hkString::endsWithCase("abcdef", "Def") == true);

        HK_TEST(hkString::endsWithCase("def", "abcdef") == false);
    }
}

static int string_utils()
{
    hkStringTest::test_toUpper();
    hkStringTest::test_toLower();
    hkStringTest::test_isNullOrEmpty();

    //snPrintf
    //vsnPrintf
    //sprintf

    hkStringTest::test_strCmp();
    hkStringTest::test_strNcmp();
    hkStringTest::test_strCasecmp();
    hkStringTest::test_strNcasecmp();
    hkStringTest::test_strCpy();
    hkStringTest::test_strNcpy();
    hkStringTest::test_strLen();

    hkStringTest::test_atoi();
    hkStringTest::test_atoll();
    hkStringTest::test_atoull();
    hkStringTest::test_atof();
    hkStringTest::test_atod();

    hkStringTest::test_strStr();
    //findAllOccurrences
    //strChr
    //strRchr

    hkStringTest::test_beginsWith();
    hkStringTest::test_beginsWithCase();
    hkStringTest::test_endsWith();
    hkStringTest::test_endsWithCase();
    //endsWithAny
    //endsWithAnyCase
    //lastIndexOf
    //indexOf

    //strDup
    //strNdup
    //strFree
    //strFree

    //tokenize

    //strDup
    //strNdup
    //strLwr
    //strUpr

    //memCpy
    //memCpy4
    //memCpy16
    //memCpy16
    //memCpy16NonEmpty
    //memCpy128
    //memCpy256
    //memMove
    //memSet
    //memSet4
    //memClear16
    //memClear128
    //memSet16
    //memSet16
    //memCmp
    //memCmpUint32

    return 0;
}

HK_TEST_REGISTER(string_utils, "Fast", "Common/Test/UnitTest/Base/", __FILE__);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
