// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/UnitTest/String/stringformat.h>
#include <Common/Base/Container/String/hkStringBuf.h>
#include <Common/Base/Types/Geometry/Aabb/hkAabb.h>

template<int N>
static void xxxx() {}

static int stringformat_main()
{
    hkStringBuf sb;
    int minus1 = -1;

    // Test calling formatV directly
    sb.formatL(HK_VARARGS1("hello"));
    HK_TEST(sb == "hello");

    xxxx<0>();
    sb.formatL(HK_VARARGS1("hello {}", -1));
    xxxx<0>();
    HK_TEST(sb == "hello -1");

    // use the varargs overloads

    sb.format("{}", true);
    HK_TEST(sb=="true");

    sb.format("{}", false);
    HK_TEST(sb=="false");

    xxxx<1>();
    sb.format("{}", minus1);
    xxxx<1>();
    HK_TEST(sb == "-1");

    //sb.format("foo_{1} | bar:{0:x} | {2,10} | {0,44:o}\n", 45, "sasdklf", "-");
    //HK_TEST();

    hkReflect::Var var;
    sb.format("{0}", var);
    HK_TEST(sb == "((void*)0x0)");

    // char[N] decays to char*
    sb.format("{0}", "foobar");
    HK_TEST(sb == "foobar");

    // but all other T[N] are arrays
    const int arr[] = {1,2,3};
    sb.format("{0}", arr);
    HK_TEST(sb == "[ 1, 2, 3 ]");

    // reversed order
    sb.format("{1} {0}", 33, 55);
    HK_TEST( sb == "55 33" );

    // width specs
    sb.format("< {2,-4}:{0,5}:{1,3} >", 33, 55,99);
    HK_TEST( sb == "< 99  :   33: 55 >" );

    // integer
    {
        // Decimal 'D' or 'd'
        sb.format( "{:D}", 4250 );
        HK_TEST( sb == "4250" );
        sb.format( "{:D2}", 4250 );
        HK_TEST( sb == "4250" );
        sb.format( "{:D6}", 4250 );
        HK_TEST( sb == "004250" );
        sb.format( "{:d}", 4250 );
        HK_TEST( sb == "4250" );
        sb.format( "{:d2}", 4250 );
        HK_TEST( sb == "4250" );
        sb.format( "{:d6}", 4250 );
        HK_TEST( sb == "004250" );

        // Hexadecimal (uppercase) 'X'
        sb.format( "{:X}", 4250 );
        HK_TEST( sb == "109A" );
        sb.format( "{:X2}", 4250 );
        HK_TEST( sb == "109A" );
        sb.format( "{:X6}", 4250 );
        HK_TEST( sb == "00109A" );

        // Hexadecimal (lowercase) 'x'
        sb.format( "{:x}", 4250 );
        HK_TEST( sb == "109a" );
        sb.format( "{:x2}", 4250 );
        HK_TEST( sb == "109a" );
        sb.format( "{:x6}", 4250 );
        HK_TEST( sb == "00109a" );
    }

    // float
    {
        // Fixed 'f' or 'F'
        sb.format( "{:f}", 1.0f );
        HK_TEST( sb == "1.000000000" );
        sb.format( "{:F}", 1.0f );
        HK_TEST( sb == "1.000000000" );
        sb.format( "{:f2}", 1.0f );
        HK_TEST( sb == "1.00" );
        sb.format( "{:F2}", 1.0f );
        HK_TEST( sb == "1.00" );

        // Exponential 'e' or 'E'
        sb.format( "{:e}", 1.0f );
        HK_TEST( sb == "1.000000000e+0" );
        sb.format( "{:E}", 1.0f );
        HK_TEST( sb == "1.000000000E+0" );
        sb.format( "{:e2}", 1.0f );
        HK_TEST( sb == "1.00e+0" );
        sb.format( "{:E2}", 1.0f );
        HK_TEST( sb == "1.00E+0" );

        // General 'g' or 'G'
        sb.format( "{:g}", 1.0f );
        HK_TEST( sb == "1" );
        sb.format( "{:G}", 1.0f );
        HK_TEST( sb == "1" );
        sb.format( "{:g2}", 1.0f );
        HK_TEST( sb == "1" );
        sb.format( "{:G2}", 1.0f );
        HK_TEST( sb == "1" );
        sb.format( "{:g2}", 1000000.0f );
        HK_TEST( sb == "1e+6" );
        sb.format( "{:G2}", 1000000.0f );
        HK_TEST( sb == "1E+6" );
    }

    // double
    {
        // Fixed 'f' or 'F'
        sb.format( "{:f}", 1.0 );
        HK_TEST( sb == "1.00000000000000000" );
        sb.format( "{:F}", 1.0 );
        HK_TEST( sb == "1.00000000000000000" );
        sb.format( "{:f2}", 1.0 );
        HK_TEST( sb == "1.00" );
        sb.format( "{:F2}", 1.0 );
        HK_TEST( sb == "1.00" );

        // Exponential 'e' or 'E'
        sb.format( "{:e}", 1.0 );
        HK_TEST( sb == "1.00000000000000000e+0" );
        sb.format( "{:E}", 1.0 );
        HK_TEST( sb == "1.00000000000000000E+0" );
        sb.format( "{:e2}", 1.0 );
        HK_TEST( sb == "1.00e+0" );
        sb.format( "{:E2}", 1.0 );
        HK_TEST( sb == "1.00E+0" );

        // General 'g' or 'G'
        sb.format( "{:g}", 1.0 );
        HK_TEST( sb == "1" );
        sb.format( "{:G}", 1.0 );
        HK_TEST( sb == "1" );
        sb.format( "{:g2}", 1.0 );
        HK_TEST( sb == "1" );
        sb.format( "{:G2}", 1.0 );
        HK_TEST( sb == "1" );
        sb.format( "{:g2}", 1000000.0 );
        HK_TEST( sb == "1e+6" );
        sb.format( "{:G2}", 1000000.0 );
        HK_TEST( sb == "1E+6" );
    }

    hkVector4 v1; v1.set( 1, 2, 3, 4 );
    hkVector4 v2; v2.set( 11, 12, 13, 14 );

    // Array
    {
        // default
        sb.format("{0}",v1);
        HK_TEST( sb == "[ 1, 2, 3, 4 ]");

        // "offset,length" extra spec (array slice)
        sb.format( "{:1}", v1 );
        HK_TEST( sb == "[ 2, 3, 4 ]" );
        sb.format( "{:3}", v1 );
        HK_TEST( sb == "[ 4 ]" );
        sb.format( "{:5}", v1 );
        HK_TEST( sb == "[  ]" );
        sb.format( "{:,1}", v1 );
        HK_TEST( sb == "[ 1 ]" );
        sb.format( "{:,2}", v1 );
        HK_TEST( sb == "[ 1, 2 ]" );
        sb.format( "{:,5}", v1 );
        HK_TEST( sb == "[ 1, 2, 3, 4 ]" );
        sb.format( "{:2,1}", v1 );
        HK_TEST( sb == "[ 3 ]" );
    }

    // format a record
    hkAabb aabb; aabb.setEmpty();
    aabb.includePoint(v1);
    aabb.includePoint(v2);
    sb.format("{0}",aabb);
    HK_TEST( sb == "hkAabb{ min=[ 1, 2, 3, 4 ], max=[ 11, 12, 13, 14 ] }");

    // custom formatting
    UnitTest::CustomFormatter fmt = { {0,1,2,3,4,5,6,7,8} };
    sb.format("{}",fmt);
    HK_TEST( sb == "01-234-5678");

    // custom formatting with custom "extra" flags
    sb.format("{:s1}", fmt);
    HK_TEST(sb == "(01) 234 5678");

    return 0;
}

HK_TEST_REGISTER(stringformat_main, "Fast", "Common/Test/UnitTest/Base/", __FILE__);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
