// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/Thread/Pool/hkCpuThreadPool.h>
#include <Common/Base/Algorithm/PseudoRandom/hkPseudoRandomGenerator.h>
#include <Common/Base/Container/String/hkInternedStringRegistry.h>

namespace HK_UNITY_ANONYMOUS_NAMESPACE
{
    struct InternedStringTestTheadInfo
    {
        hkInternedStringRegistryBase * registry;
        const hkArray<char> * largeRandomStringChunks;
    };

    static void HK_CALL threadMain(void* data)
    {
        InternedStringTestTheadInfo& info = *reinterpret_cast<InternedStringTestTheadInfo*>(data);

        for (int i = 0; i < info.largeRandomStringChunks->getSize(); ++i)
        {
            info.registry->_addCopy(info.largeRandomStringChunks->begin() + i);
        }
    }
}

static int internedstring_main()
{
    HK_UNITY_USING_ANONYMOUS_NAMESPACE;

    hkArray<char> largeRandomStringChunks;
    hkInternedStringRegistryBase registry;

    const int fullSize = 65536;
    const int strSize = 16;
    largeRandomStringChunks.reserve(fullSize);

    hkPseudoRandomGenerator rand(173);

    for (int i = 0; i < fullSize; ++i)
    {
        largeRandomStringChunks.pushBack(char(((i + 1) % strSize) ? 'a' + rand.getRandChar('z' - 'a') : 0));
    }

    hkCpuThreadPoolCinfo cinfo;
    cinfo.m_numThreads = 4; 
    hkCpuThreadPool threadPool(cinfo);

    InternedStringTestTheadInfo info;
    info.registry = &registry;
    info.largeRandomStringChunks = &largeRandomStringChunks;

    threadPool.processWorkLoad(&threadMain, &info);
    threadPool.waitForCompletion();

    return 0;
}

HK_TEST_REGISTER(internedstring_main, "Fast", "Common/Test/UnitTest/Base/", __FILE__);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
