// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/System/Io/Structured/hkStructuredStream.h>
#include <Common/Base/Serialize/Detail/hkReadBuffer.h>

namespace
{
    #define FOUR_CC(a,b,c,d) (((a)<<24)|((b)<<16)|((c)<<8)|((d)<<0))
    const hkUint32 TAG_TAGF = FOUR_CC('T','A','G','F');
    const hkUint32 TAG_VALS = FOUR_CC('v','a','l','s');
    const hkUint32 TAG_CTRL = FOUR_CC('C','T','R','L');
    const hkUint32 TAG_DATA = FOUR_CC('D','A','T','A');
    const hkUint32 TAG_ALGN = FOUR_CC('A','L','G','N');
}

static void writeStreamy(hkArray<char>& buffer)
{
    using namespace hkSerialize;
    hkIo::WriteBuffer wb(&buffer);
    HffWriter writer(wb);

    writer.openBranch(TAG_TAGF);
        writer.writeLeaf(TAG_CTRL, "asdf", 4);
        writer.openBranch(TAG_ALGN);
            writer.writeLeaf(TAG_DATA, "asdfasdfas",6);
        writer.close();
        writer.openLeaf(TAG_VALS);
        wb.writePod<hkUint32Be>(44);
        wb.writePod<hkUint32Be>(441);
        wb.writePod<hkUint32Be>(442);
        wb.writePod<hkUint32Be>(443);
        writer.close();
    writer.close();
}


static void writeBuilder(hkArray<char>& buffer)
{
    using namespace hkSerialize;
    typedef HffBuilder::BranchId BranchId;
    HffMemoryBuilder writer;
    BranchId TAGF = writer.openRoot(TAG_TAGF);
    hkIo::WriteBuffer* tag0 = writer.openLeaf(TAGF, FOUR_CC('t','a','g','0'));
    hkIo::WriteBuffer* tag1 = writer.openLeaf(TAGF, FOUR_CC('t','a','g','1'));

    BranchId META = writer.openBranch( TAGF, FOUR_CC('M','E','T','A'));
    hkIo::WriteBuffer* met0 = writer.openLeaf(META, FOUR_CC('m','e','t','0'));

    BranchId DATA = writer.openBranch( TAGF, TAG_DATA);
    hkIo::WriteBuffer* met1 = writer.openLeaf(META, FOUR_CC('m','e','t','1'));
    hkIo::WriteBuffer* dat0 = writer.openLeaf(DATA, FOUR_CC('d','a','t','0'));

    hkIo::WriteBuffer* tag2 = writer.openLeaf(TAGF, FOUR_CC('t','a','g','2'));


    met0->writeRaw("lasjdflajsd;fljasdlfjasdlk", 20);
    met1->writeRaw("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX", 30);
    dat0->writeRaw("mmmmmmmmmmmmmmmmmmmmm", 11);

    tag0->writePod<hkUint32Be>(0);
    tag1->writePod<hkUint8>(0xff);
    tag2->writePod<hkFloat32>(1.0f);

    tag0->writePod<hkUint32Be>(1);
    tag1->writePod<hkUint8>(0xfe);

    tag0->writePod<hkUint32Be>(2);
    tag1->writePod<hkUint8>(0xfa);

    //      writer.setAlign(met1, 16);
    //      writer.setAlign(met0, 8);

    writer.close();
    writer.writeTo(&buffer);
}


static void readStreamy(const hkArray<char>& buffer)
{
    using namespace hkSerialize;
    HffMemoryReader reader(buffer.begin(), buffer.getSize());

    if( Ident tag2 = reader.enter(0x1234) )
    {
        reader.leave(TAG_TAGF);
    }

    if( reader.enter(TAG_TAGF) )
    {
        hkArray<char> ctrl;
        hkArray<char> data;
        bool ok = true;
        while( ok )
        {
            switch( reader.enter(0) )
            {
                case TAG_CTRL:
                case TAG_DATA:
                case TAG_VALS:
                {
                    reader.skipContent();
                    break;
                }
                case TAG_ALGN:
                {
                    reader.enter(TAG_DATA);
                    reader.skipContent();
                    reader.leave(TAG_DATA);
                    break;
                }
                case HffBase::IDENT_IO_ERROR:
                {
                    HK_TEST(0);
                    return; //FAIL
                }
                case HffBase::IDENT_NONE:
                {
                    reader.leave(TAG_TAGF);
                    return; // SUCCESS
                }
                default:
                {
                    reader.skipContent();
                    break;
                }
            }
            if( HK_TEST(ok) )
            {
                reader.leave();
            }
        }
    }
    HK_TEST(0);
}


static int structuredstream()
{
    using namespace hkSerialize;

    {
        hkArray<char> buffer;
        writeStreamy(buffer);
        //hkArray<Detail::HffSection> sections;Detail::indexHff(sections, buffer.begin(), buffer.getSize());
        readStreamy(buffer);
    }


    {
        hkArray<char> buffer;
        writeBuilder(buffer);
        readStreamy(buffer);
    }

    return 0;
}


HK_TEST_REGISTER(structuredstream, "Fast", "Common/Test/UnitTest/Base/", __FILE__);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
