// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/System/Io/FileSystem/hkFileSystem.h>
#include <Common/Base/System/Io/Reader/hkStreamReader.h>
//#include <stdio.h>

static void fs_iterator()
{
    hkFileSystem& fs = hkFileSystem::getInstance();
    const char Resources_Common_Textures[] = "Resources/Common/Textures";

    {
        hkFileSystem::Entry entry;
        HK_TEST2(fs.stat(Resources_Common_Textures, entry).isSuccess(), "Folder missing (missing files from deploy?)");
        HK_TEST(entry.isDir());
    }

    hkFileSystem::Iterator iter(&fs, Resources_Common_Textures);
    int count = 0;
    bool recursed = false;
    while(iter.advance())
    {
        count += 1;

        const hkFileSystem::Entry& e = iter.current();
        //printf("%10x, %s\n", int(e.getMtime()>>32), e.getPath());
        if(e.isDir() && !recursed)
        {
            iter.recurseInto(e.getPath());
        }
    }
    HK_TEST(count != 0);
}

static void fs_openwrite()
{
    hkFileSystem& fs = hkFileSystem::getInstance();
    {
        hkRefPtr<hkStreamWriter> w0 = fs.openWriter("test.txt");
        if(HK_TEST(w0))
        {
            w0->write("helloblah", 9);
        }
    }
    {
        hkRefPtr<hkStreamReader> r0 = fs.openReader("test.txt");
        if(HK_TEST(r0))
        {
            char buf[100] = {};
            int n = r0->read(buf, sizeof(buf) - 1);
            HK_TEST(n == 9);
            HK_TEST(hkString::strCmp(buf, "helloblah") == 0);
        }
    }
}

static void fs_append()
{
    hkFileSystem& fs = hkFileSystem::getInstance();
    {
        hkRefPtr<hkStreamWriter> w0 = fs.openWriter("test.txt");
        if(HK_TEST(w0))
        {
            w0->write("hello", 5);
        }
    }
    {
        hkRefPtr<hkStreamWriter> w0 = fs.openWriter("test.txt", hkFileSystem::OpenFlags(hkFileSystem::OPEN_DEFAULT_WRITE & (~hkFileSystem::OPEN_TRUNCATE)));
        if(HK_TEST(w0))
        {
            w0->seek(0, hkStreamWriter::STREAM_END);
            w0->write("world", 5);
        }
    }
    {
        hkRefPtr<hkStreamReader> r0 = fs.openReader("test.txt");
        if(HK_TEST(r0))
        {
            char buf[100] = {};
            int n = r0->read(buf, sizeof(buf) - 1);
            HK_TEST(n == 10);
            HK_TEST(hkString::strCmp(buf, "helloworld") == 0);
        }
    }

    fs.remove("test.txt");
}

// Try appending to an initially empty file. hkStdioStreamWriter has trouble with this if you're not careful.
static void fs_append_empty()
{
    hkFileSystem& fs = hkFileSystem::getInstance();

    // Remove the file if it's already there
    hkResult removeRes = fs.remove("test.txt");
    if(removeRes.isExactly(HK_E_NOT_IMPLEMENTED))
    {
        // Can't remove files, so can't really proceed.
        return;
    }

    hkFileSystem::Entry entry;
    hkResult statRes = fs.stat("test.txt", entry);

    // Make sure the file doesn't exist anymore
    HK_TEST(statRes.isFailure());

    hkFileSystem::OpenFlags openFlags = hkFileSystem::OpenFlags(hkFileSystem::OPEN_DEFAULT_WRITE & (~hkFileSystem::OPEN_TRUNCATE));
    {
        hkRefPtr<hkStreamWriter> w0 = fs.openWriter("test.txt", openFlags);
        if(HK_TEST(w0))
        {
            w0->seek(0, hkStreamWriter::STREAM_END);
            w0->write("jello", 5);
        }
    }
    {
        // Don't seek. This should overwrite the first character.
        hkRefPtr<hkStreamWriter> w0 = fs.openWriter("test.txt", openFlags );
        if(HK_TEST(w0))
        {
            w0->write("h",1);
        }
    }
    {
        // Seek so we're writing at the end.
        hkRefPtr<hkStreamWriter> w0 = fs.openWriter("test.txt", openFlags );
        if(HK_TEST(w0))
        {
            w0->seek(0, hkStreamWriter::STREAM_END);
            w0->write("world", 5);
        }
    }

    {
        hkRefPtr<hkStreamReader> r0 = fs.openReader("test.txt");
        if(HK_TEST(r0))
        {
            char buf[100] = {};
            int n = r0->read(buf, sizeof(buf)-1);
            HK_TEST(n == 10);
            HK_TEST( hkString::strCmp(buf, "helloworld") == 0);
        }
    }
}

int filesystem_main()
{
    fs_openwrite();
    fs_iterator();
    fs_append();
    fs_append_empty();
    return 0;
}

HK_TEST_REGISTER(filesystem_main, "Fast", "Common/Test/UnitTest/Base/", __FILE__     );

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
