// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/System/Io/Writer/Crc/hkCrcStreamWriter.h>

static int crcStream_main()
{
    {
        hkCrc32StreamWriter w;
        hkUint32 u;
        u = w.getCrc();
        static char buf0[] = "Test the CRC-32 of";
        w.write(buf0, sizeof(buf0)-1);
        u = w.getCrc();
        static char buf1[] = " this string.";
        w.write(buf1, sizeof(buf1)-1);
        u = w.getCrc();
        HK_TEST( u == 0x5da6eb6a );
    }
    {
        hkCrc64StreamWriter w;
        hkUint64 u;
        u = w.getCrc();
        static char buf0[] = "Test the CRC-64 of";
        w.write(buf0, sizeof(buf0)-1);
        u = w.getCrc();
        static char buf1[] = " this string.";
        w.write(buf1, sizeof(buf1)-1);
        u = w.getCrc();
        HK_TEST( u == 0x777255cea39aa012 );
    }
    return 0;
}

HK_TEST_REGISTER(crcStream_main, "Fast", "Common/Test/UnitTest/Base/", __FILE__     );

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
