// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/Serialize/Detail/hkWriteBuffer.h>
#include <Common/Base/Serialize/Detail/hkReadBuffer.h>
#include <Common/Base/System/Io/FileSystem/hkFileSystem.h>

static const char testStr[] = "Hello world";

static void writeTestData(hkIo::WriteBuffer& writeBuffer)
{
    writeBuffer.write32i(12345);
    writeBuffer.writeRaw(testStr, sizeof(testStr));
}

static void readAndVerifyTestData(hkIo::ReadBuffer& readBuffer)
{
    hkInt32 v = readBuffer.read32i();
    HK_TEST(v == 12345);

    char read[sizeof(testStr)] = { 0 };
    hkLong numRead = readBuffer.read(read, sizeof(testStr));
    HK_TEST(numRead == sizeof(testStr));
    hkMemUtil::memCmp(read, testStr, sizeof(testStr));
}

static void testWriteToFile()
{
    {
        hkIo::WriteBuffer writeBuffer("test.txt");
        writeTestData(writeBuffer);
    }

    {
        hkIo::ReadBuffer readBuffer("test.txt");
        readAndVerifyTestData(readBuffer);
    }

    hkFileSystem& fs = hkFileSystem::getInstance();
    fs.remove("test.txt");
}

static void testWriteToMemBlock()
{
    char memBlock[32];
    hkLong usedSize;

    {
        hkIo::WriteBuffer writeBuffer(memBlock, sizeof(memBlock), &usedSize);
        writeTestData(writeBuffer);
    }

    HK_TEST(usedSize == 16);

    {
        hkIo::ReadBuffer readBuffer(memBlock, usedSize);
        readAndVerifyTestData(readBuffer);
    }
}

static void testWriteToMemBlockPastEnd()
{
    char memBlock[10];
    hkLong usedSize;

    {
        hkIo::WriteBuffer writeBuffer(memBlock, sizeof(memBlock), &usedSize);
        writeBuffer.write32i(12345);
        hkLong numWritten = writeBuffer.writeRaw(testStr, sizeof(testStr));
        HK_TEST(numWritten == 6);
    }

    HK_TEST(usedSize == 10);

    {
        hkIo::ReadBuffer readBuffer(memBlock, usedSize);
        hkInt32 v = readBuffer.read32i();
        HK_TEST(v == 12345);

        char read[sizeof(testStr)] = { 0 };
        hkLong numRead = readBuffer.read(read, sizeof(testStr));
        HK_TEST(numRead == 6);
        hkMemUtil::memCmp(read, testStr, 6);
    }
}

static void testMemBlockAdapter()
{
    char memBlock[32];
    hkLong usedSize;

    {
        hkIo::WriteBuffer writeBuffer(hkIo::Detail::WriteBufferAdapter(memBlock, sizeof(memBlock), &usedSize));
        writeTestData(writeBuffer);
    }

    HK_TEST(usedSize == 16);

    {
        hkIo::ReadBuffer readBuffer(memBlock, usedSize);
        readAndVerifyTestData(readBuffer);
    }
}

static int writebuffer_main()
{
    testWriteToFile();
    testWriteToMemBlock();
    testWriteToMemBlockPastEnd();
    testMemBlockAdapter();
    return 0;
}

HK_TEST_REGISTER(writebuffer_main, "Fast", "Common/Test/UnitTest/Base/", __FILE__);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
