// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/System/Stopwatch/hkStopwatch.h>

static unsigned fib(unsigned n)
{
    if (n==0)
        return 1;

    if (n==1)
        return 1;

    return fib(n-1) + fib(n-2);
}

void stopwatch_test()
{
    {
        // Single stopwatch accuracy
        if(0)
                // disabled - breaks too easily
        {
            const int testIterations = 10;
            const int computeIters = 10;    // Don't go much higher!

            for (int iters = 0; iters < testIterations; iters++)
            {
                hkStopwatch sw;
                volatile int x;
                int i;

                x = fib(10); // fill $I cache

                sw.start();
                for(i = 0; i < computeIters; ++i)
                {
                    x = fib(i) + x; // assume running time is reasonably constant.
                }
                sw.stop();
                hkReal time0 = sw.getElapsedSeconds();

                sw.reset();
                sw.start();
                for (int j=0; j < 10; j++)
                {
                    for(i = 0; i < computeIters ; ++i)
                    {
                        x = fib(i) + x;
                    }
                }

                sw.stop();
                hkReal time1 = sw.getElapsedSeconds();

                hkReal ratio = time1/time0;

                HK_TEST2( ratio >= 9 && ratio <= 11, "times were " << time0 << ' ' << time1 << " ratio " << ratio );
            }
        }
        // Multiple stopwatch accuracy
        {
            const int testIterations = 10;
            const int computeIters = 100;
            hkReal ratio = 100;

            for (int iters = 0; iters < testIterations; iters++)
            {
                hkStopwatch sw1;
                hkStopwatch sw2;
                volatile unsigned x;
                int i;

                x = fib(10); // fill $I cache

                sw1.start();
                for(i = 0; i < computeIters; ++i)
                {
                    x = fib(i) + x; // assume running time is reasonably constant.
                }
                sw1.stop();
                hkReal time0 = sw1.getElapsedSeconds();

                sw2.start();
                for (int j=0; j < 10; j++)
                {
                    for(i = 0; i < computeIters ; ++i)
                    {
                        x = fib(i) + x;
                    }
                }
                sw2.stop();
                hkReal time1 = sw2.getElapsedSeconds();

                hkReal thisRatio = time1/time0;
                if(thisRatio < ratio)
                {
                    ratio = thisRatio;
                }
            }
            //HK_TEST2( ratio >= 9.9 && ratio <= 10.1, " ratio " << ratio );
        }
    }
}

int stopwatch_main()
{


    stopwatch_test();


    return 0;
}

//HK_TEST_REGISTER(stopwatch_main,     "Broken", "Test/Test/UnitTest/UnitTest/UnitTest/Base/",     __FILE__    );

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
