// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>


#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/System/Io/IStream/hkIStream.h>
#include <Common/Base/System/Io/Reader/Memory/hkMemoryStreamReader.h>
#include <Common/Base/Serialize/Util/Xml/hkXmlParser.h>

static void xmlparser_test()
{
    const char xml[] =
        "<hkparam name=\"blahhhh\">\n"
        "\t<struct>\n"
        "\t\t<hkparam name=\"blahhhh1\">0</hkparam>\n"
        "\t\t<hkparam name=\"blahhhh1\">0</hkparam>\n"
        "\t\t<hkparam name=\"blahhhh1\">0</hkparam>\n"
        "\t\t<hkparam name=\"blahhhh1\">0</hkparam>\n"
        "\t\t<hkparam name=\"blahhhh1\">0</hkparam>\n"
        "\t</struct>\n"
        "</hkparam>";
    hkXmlParser parser;
    hkMemoryStreamReader sr(xml, HK_COUNT_OF(xml), hkMemoryStreamReader::MEMORY_INPLACE);
    hkXmlParser::Node* root;
    parser.nextNode(&root, &sr);
    if( hkXmlParser::StartElement* start = root->asStart())
    {
        hkTree< hkRefPtr<hkXmlParser::Node> > xmltree;
        parser.expandNode(start, xmltree, &sr);
    }
    else
    {
        HK_TEST(0);
    }

    root->removeReference();
}

int xmlTest_main()
{
    xmlparser_test();
    return 0;
}

HK_TEST_REGISTER(xmlTest_main, "Fast", "Common/Test/UnitTest/Base/", __FILE__     );

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
