// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Container/Array/hkVariantArray.h>
#include <Common/Base/Serialize/Core/hkSerializeCore.h>
#include <Common/Base/Serialize/Detail/hkSerializeDetail.h>


namespace UnitTest
{
    template<hkSerialize::Detail::FileFormatRegNode* regNode>
    class OptionalReadFormatWrapper : public hkSerialize::ReadFormat
    {
    public:

        static bool isAvailable()
        {
            return regNode->m_readFormatCreateFunc != HK_NULL;
        }

        OptionalReadFormatWrapper()
        {
            m_format = regNode->createReadFormat();
        }

        virtual hkViewPtr<hkSerialize::Bundle> read(hkIo::ReadBuffer& rb) HK_OVERRIDE
        {
            return m_format->read(rb);
        }
        virtual hkViewPtr<hkSerialize::Bundle> view(const void* buf, hkUlong bufLen, hkUlong* usedOut) HK_OVERRIDE
        {
            return m_format->view(buf, bufLen, usedOut);
        }
        virtual hkViewPtr<hkSerialize::Bundle> inplace(const void* buf, hkUlong bufLen, hkUlong* usedOut, const hkReflect::TypeReg* typeReg) HK_OVERRIDE
        {
            return m_format->inplace(buf, bufLen, usedOut, typeReg);
        }

        hkRefPtr<hkSerialize::ReadFormat> m_format;
    };

    template<hkSerialize::Detail::FileFormatRegNode* regNode>
    class OptionalWriteFormatWrapper : public hkSerialize::WriteFormat
    {
    public:
        static bool isAvailable()
        {
            return regNode->m_writeFormatCreateFunc != HK_NULL;
        }

        OptionalWriteFormatWrapper()
        {
            m_format = regNode->createWriteFormat();
        }

        virtual void beginBundle(_In_ hkIo::WriteBuffer* writeBuffer) HK_OVERRIDE
        {
            return m_format->beginBundle(writeBuffer);
        }
        virtual void endBundle() HK_OVERRIDE
        {
            return m_format->endBundle();
        }
        virtual hkResult write(const hkReflect::Var& var, hkSerialize::IdFromVar& idFromVar) HK_OVERRIDE
        {
            return m_format->write(var, idFromVar);
        }
        virtual hkResult writeNote(hkSerialize::VarId vid, const hkReflect::Var& note, hkSerialize::IdFromVar& idFromVar) HK_OVERRIDE
        {
            return m_format->writeNote(vid, note, idFromVar);
        }
        virtual void beginTypeCompendium(const hkIo::Detail::WriteBufferAdapter& sink) HK_OVERRIDE
        {
            return m_format->beginTypeCompendium(sink);
        }
        virtual void endTypeCompendium() HK_OVERRIDE
        {
            return m_format->endTypeCompendium();
        }

        hkRefPtr<hkSerialize::WriteFormat> m_format;
    };

    namespace UrlObject
    {
        // Simple classes for test
        class Shape : public hkReferencedObject
        {
        public:
            HK_DECLARE_CLASS(Shape, New, Reflect, BypassCtor);
            HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

            Shape(float size) : m_size(size) {}

            float m_size;
        };

        class Body
        {
        public:
            HK_DECLARE_CLASS(Body, New, Reflect, BypassCtor);
            HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

            Body(Shape* shape) : m_shape(shape), m_child(HK_NULL) {}
            ~Body() { }

            hkRefPtr<Shape> m_shape;
            Body* m_child;
        };

        class TestGraph : public hkReferencedObject
        {
        public:
            HK_DECLARE_CLASS(TestGraph, New, Reflect, BypassCtor);
            HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

            TestGraph(int id) : m_id(id), m_childA(HK_NULL), m_childB(HK_NULL), m_childC(HK_NULL) {}

            int m_id;
            hkRefPtr<TestGraph> m_childA;
            hkRefPtr<TestGraph> m_childB;
            hkRefPtr<TestGraph> m_childC;
        };

        class VariantTest
        {
        public:
            HK_DECLARE_CLASS(VariantTest, New, Reflect);
            HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

            hkVariantArray m_array1;
            int m_a1;
            hkVariantArray m_array2;
            float m_a4;
        };


        class ObjectWithTypedNull
        {
        public:
            HK_DECLARE_CLASS(ObjectWithTypedNull, New, Reflect);
            HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

            hkArray<const hkReflect::Type*> m_typeRef;
            hkStringPtr m_name;
        };

        class Import
        {
        public:
            HK_DECLARE_CLASS(Import, New, Reflect);
            HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

            Import() {}
            Import(int id, bool strong) : m_id(id), m_strong(strong) {}

            int m_id;
            bool m_strong;
        };
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
