// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/System/Io/IStream/hkIStream.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/Serialize/Util/Xml/hkXmlObjectReader.h>
#include <Common/Base/Serialize/Util/Xml/hkXmlObjectWriter.h>

static const char asciiData[] = "This is the original data!!!";
static const char base64Data[] = "VGhpcyBpcyB0aGUgb3JpZ2luYWwgZGF0YSEhIQA=";

/*
** These tests check that the ascii<->base64 routines for the xml serializer
** work and are platform-independant
*/

int base64Test_main()
{
    // We work including the zero at the end of the ascii data
    const int asciiLen = hkString::strLen(asciiData)+1;
    const int base64Len = hkString::strLen(base64Data);

    // Test 1 : conversion from ASCII into base64
    {
        hkArray<char> result;
        hkOstream out(result);

        hkResult res = hkXmlObjectWriter::base64write(out.getStreamWriter(), asciiData, asciiLen );

        // We test the output is what we expected
        HK_TEST( res.isSuccess() );
        HK_TEST( result.getSize() == base64Len );
        HK_TEST( hkString::strNcmp(base64Data, result.begin(), base64Len) == 0 );
    }

    // Test 2 : conversion from base64 into ASCII
    {
        hkIstream base64stream(base64Data, sizeof(base64Data));

        char asciiResult[50];
        hkResult res = hkXmlObjectReader::base64read( base64stream.getStreamReader(), asciiResult, sizeof(asciiData) );

        // We test the output is the original, including the ending 0
        HK_TEST( res.isSuccess() );
        HK_TEST(hkString::strCmp(asciiData, asciiResult)==0);
    }

    return 0;
}

HK_TEST_REGISTER(base64Test_main, "Fast", "Common/Test/UnitTest/Base/", __FILE__     );

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
