// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Reflect/Util/hkReflectSyntheticUtil.h>

namespace UnitTest
{
    class Interface : public hkReferencedObject
    {
    public:
        HK_DECLARE_CLASS(Interface, New, Reflect, BypassCtor);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
        HK_RECORD_ATTR(hk::SyntheticBase( InterfaceSynthetic ));
        Interface() {}

        virtual const char* doIt() const = 0;
    };

    class InterfaceImpl0 : public Interface
    {
    public:
        HK_DECLARE_CLASS(InterfaceImpl0, New, Reflect, BypassCtor);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
        InterfaceImpl0() {}
        virtual const char* doIt() const { return "InterfaceImpl0"; }
    };

    class InterfaceImpl1 : public Interface
    {
    public:
        HK_DECLARE_CLASS(InterfaceImpl1, New, Reflect, BypassCtor);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
        InterfaceImpl1() {}
        virtual const char* doIt() const HK_OVERRIDE { return "InterfaceImpl1"; }
    };

    class InterfaceUnregistered0 : public Interface
    {
    public:
        HK_DECLARE_CLASS(InterfaceUnregistered0, New, Reflect, BypassCtor);
        HK_RECORD_ATTR(hk::RegisterType(false)); // this is intentionally not registered to simulate missing type on load
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

        InterfaceUnregistered0() {}
        virtual const char* doIt() const HK_OVERRIDE { return "InterfaceUnregistered0"; }

        int m_int;
        hkStringPtr m_foo;
    };

    class InterfaceUnregistered1 : public InterfaceUnregistered0
    {
    public:
        HK_DECLARE_CLASS(InterfaceUnregistered1, New, Reflect, BypassCtor);
        HK_RECORD_ATTR(hk::RegisterType(false)); // this is intentionally not registered to simulate missing type on load
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

        InterfaceUnregistered1() {}
        virtual const char* doIt() const HK_OVERRIDE { return "InterfaceUnregistered1"; }

        hkVector4 m_pos;
        hkArray<hkStringPtr> m_strings;
    };

        // Abstract classes need a stub which implements the abstract methods.
    class InterfaceSynthetic : public Interface
    {
    public:
        HK_DECLARE_CLASS(InterfaceSynthetic, New, Reflect, BypassCtor);
        HK_RECORD_ATTR(hk::GenerateExactTypeMethod(false)); // we have a custom dymamicType based on m_type
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

        // implement any abstract methods
        virtual const char* doIt() const HK_OVERRIDE{ return m_syntheticUtil.getType()->getName(); }

        // Placeholder "synthetic" types must have a field of this type
        // It knows that there are extra fields after this class and how to clean them up.
        hkReflect::Detail::SyntheticUtil m_syntheticUtil HK_ATTR(hk::Serialize(false));
    };
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
