// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/UnitTest/Serialize/Unregistered/UnregisteredType.h>
#include <Common/Base/Serialize/hkSerialize.h>
#include <Common/Base/Reflect/TypeReg/hkTypeReg.h>
#include <Common/Base/Container/Hash/hkHashSet.h>
#include <Common/Base/Reflect/Detail/hkTypeHasher.h>

hkReflect::Detail::AddrAndType UnitTest::InterfaceSynthetic::getExactType() const
{
    return hkReflect::Detail::AddrAndType(this, m_syntheticUtil.getType());
}

namespace
{
    struct Synthetic
    {
        Synthetic(const hkReflect::Type* t) : m_type(t) {}
        const hkReflect::Type* m_type;
    };
    static hkUint32 hkHashValue(Synthetic s)
    {
        hkUint32 sig = hkReflect::TypeHasher::_addTypeName(0, s.m_type);
        return hkReflect::TypeHasher::_addTypeTemplate(sig, s.m_type);
    }
    bool operator==(Synthetic a, Synthetic b)
    {
        return hkReflect::Type::compareName(a.m_type, b.m_type);
    }

    struct PlaceholderTypeReg : public hkReflect::TypeReg
    {
        ~PlaceholderTypeReg()
        {
            for (hkHashSet< Synthetic >::Iterator it(m_synthetics.getIterator()); m_synthetics.isValid(it); it = m_synthetics.getNext(it))
            {
                Synthetic s = m_synthetics.get(it);
                hk::DeleteTypeInfo::deleteType( const_cast<hkReflect::Type*>(s.m_type));
            }
        }
        virtual const hkReflect::Type* typeFromName(const char* name) const HK_OVERRIDE
        {
            if( const hkReflect::Type* t = hkReflect::typeFromName(name) )
            {
                return t;
            }
            return HK_NULL;
        }

        virtual const hkReflect::Type* typeFromType(const hkReflect::Type* type) const HK_OVERRIDE
        {
            if( const hkReflect::Type* t = hkReflect::typeFromType(type) )
            {
                return t;
            }
            auto iter = m_synthetics.find( type);
            if (m_synthetics.isValid(iter))
            {
                return m_synthetics.get(iter).m_type;
            }
            const hkReflect::Type* syn = hkReflect::Detail::SyntheticUtil::build(type);
            m_synthetics.insert(syn);
            return syn;
        }
        mutable hkHashSet< Synthetic > m_synthetics;
    };
}

typedef hkArray< hkRefPtr<UnitTest::Interface> > ArrayOfInterface;

static void loadWithNull(hkArrayView<char> buf)
{
    hkReflect::Var var = hkSerialize::Load().withIgnoreInvalid().toVar(hkArrayViewT::make(buf.begin(),buf.getSize()));
    if( HK_TEST(var) )
    {
        ArrayOfInterface* arr = var.dynCast<ArrayOfInterface>();
        if( HK_TEST(arr) )
        {
            HK_TEST( (*arr)[0] );
            HK_TEST( (*arr)[1] == HK_NULL );
            HK_TEST( (*arr)[2] );
            HK_TEST( (*arr)[3] == HK_NULL );

            for( int i = 0; i< arr->getSize(); ++i )
            {
                if( UnitTest::Interface* o = (*arr)[i] )
                {
                    o->doIt();
                }
            }
        }
        delete arr;
    }
}

static void loadWithPlaceholder(hkArrayView<char> buf)
{
    // Utility which tries to build a type on the fly for an unregistered type.
    PlaceholderTypeReg holder;

    hkReflect::Var var = hkSerialize::Load().withTypeReg(&holder).toVar(buf.begin(), buf.getSize());
    if( HK_TEST(var) )
    {
        ArrayOfInterface* arr = var.dynCast<ArrayOfInterface>();
        if( HK_TEST(arr) )
        {
            HK_TEST( (*arr)[0] );
            HK_TEST( (*arr)[1] );
            HK_TEST( (*arr)[2] );
            HK_TEST( (*arr)[3] );

            for( int i = 0; i< arr->getSize(); ++i )
            {
                if( UnitTest::Interface* o = (*arr)[i] )
                {
                    o->doIt();
                }
            }
        }

        
        
        
        
        
        

        
        
        
        

        delete arr;
    }
}


static int TestUnregisteredType()
{
    hkArray<char> buf;

    // set up a test case
    // Save an array of 4 pointers
    {
        using namespace hkSerialize;

        UnitTest::InterfaceImpl0 obj0;
        UnitTest::InterfaceUnregistered0 obj1;
        obj1.m_int = 101;
        obj1.m_foo = "foofoo"; // add a member with nontrivial destructor
        UnitTest::InterfaceImpl1 obj2;
        UnitTest::InterfaceUnregistered1 obj3;
        obj3.m_int = 202;
        obj3.m_foo = "barbar";
        obj3.m_pos.set(4,5,6);
        obj3.m_strings.pushBack("hello");
        obj3.m_strings.pushBack("world");


        ArrayOfInterface arr;
        arr.pushBack(&obj0); // "normal" (reflected, registered) type
        arr.pushBack(&obj1); // reflected but not registered. i.e. customer type which we don't have
        arr.pushBack(&obj2); // "normal" (reflected, registered) type
        arr.pushBack(&obj3); // reflected but not registered. i.e. customer type which we don't have

        // Types don't need to be registered in order to save them.
        // Type hierarchies have a ExactTypeFunction attribute which allows finding the exact type.
        hkSerialize::Save().contentsPtr(&arr, &buf);
    }

    loadWithNull(buf);
    loadWithPlaceholder(buf);
    return 0;
}

HK_TEST_REGISTER(TestUnregisteredType, "Fast", "Common/Test/UnitTest/Base/", __FILE__);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
