// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/Serialize/hkSerialize.h>
#include <Common/Base/System/Io/FileSystem/hkFileSystem.h>
#include <Common/Base/Serialize/Format/Tagfile/hkTagfileWriteFormat.h>
#include <Common/Base/Serialize/Format/Tagfile/hkTagfileReadFormat.h>
#include <Common/Base/System/Stopwatch/hkStopwatch.h>
#include <Common/Base/Reflect/Version/hkReflectPatchRegistry.h>
#include <Common/Base/System/Io/Reader/hkStreamReader.h>
#include <Common/Base/UnitTest/hkPath.h>


static void createTypeCompendium(const hkIo::Path& testRoot)
{
    using namespace hkIo;
    hkSerialize::Save save;
    save.withFormat<hkSerialize::TagfileWriteFormat>().beginTypeCompendium(testRoot / "Compendium.man");

    for(hkFileSystem::Iterator it(hkFileSystem::getInstancePtr(), testRoot.cString()); it.advance();)
    {
        const hkFileSystem::Entry& entry = it.current();
        Path path( entry.getPath() );
        if(entry.isDir())
        {
            it.recurseInto(path.cString());
        }
        else if(path.endsWith(".hkt"))
        {
            hkIo::ReadBuffer buf(path);
            hkLong bufSize = buf.prefetchAll();
            if(hkReflect::Var v = hkSerialize::Load().toVar(buf.peekAt<void>(), bufSize))
            {
                hkSerialize::Save().contentsVar(v, path + ".sk.nt6");
                hkSerialize::Save().withFormat<hkSerialize::TagfileWriteFormat>().contentsVar(v, path + ".sk.new");

                save.contentsVar(v, path + ".sk.man");
                v.destroy();
            }
            else
            {
                HK_WARN(0x66f39789, "couldn't load " << entry.getPath());
            }
        }
    }
    save.endTypeCompendium();
}

static int numCOMP;
static int numNORM;
static hkUint64 ticksCOMP;
static hkUint64 ticksNORM;

static void readTypeCompendium(const hkIo::Path& testRoot, bool enableVersioning, int sizeLimit)
{
    using namespace hkIo;
    hkSerialize::Load loader;
    loader.withVersioning(enableVersioning).toVar(testRoot / "Compendium.man");

    for(hkFileSystem::Iterator it(hkFileSystem::getInstancePtr(), testRoot.cString()); it.advance();)
    {
        const hkFileSystem::Entry& entry = it.current();
        Path path( entry.getPath() );
        if(sizeLimit && entry.isFile())
        {
            if(entry.getSize() > sizeLimit)
            {
                continue;
            }
        }
        if(entry.isDir())
        {
            it.recurseInto(path.cString());
        }
        // Compendium load version
        else if(path.endsWith(".sk.man"))
        {
            hkIo::ReadBuffer buf(path);
            hkLong bufSize = buf.prefetchAll();
            hkStopwatch s; s.start();
            if(hkReflect::Var v = loader.toVar(buf.peekAt<void>(), bufSize))
            {
                s.stop();
//              hkSerialize::Save(path + ".new").withFormat<hkSerialize::Format::Tagfile>().contentsVar(v);
                v.destroy();
            }
            else
            {
                HK_ASSERT_NO_MSG(0xdaddce3, 0);
            }
            numCOMP += 1;
            ticksCOMP += s.getElapsedTicks();
        }
        // Normal load version
        else if(path.endsWith(".sk.new"))
        {
            hkIo::ReadBuffer buf(path);
            hkLong bufSize = buf.prefetchAll();
            hkStopwatch s; s.start();
            if(hkReflect::Var v = hkSerialize::Load().withFormat<hkSerialize::TagfileReadFormat>().withVersioning(enableVersioning).toVar(buf.peekAt<void>(), bufSize))
            {
                s.stop();
                v.destroy();
            }
            else
            {
                HK_ASSERT_NO_MSG(0x69836ec7, 0);
            }
            numNORM += 1;
            ticksNORM += s.getElapsedTicks();
        }
    }
}

static void brokenTypeCompendium(const hkIo::Path& testRoot)
{
    using namespace hkIo;
    //Load without loading compendium first
    if(0)
    {
        hkSerialize::TagfileReadFormat readFormat;
        //  hkSerialize::Load().withFormatState(&readFormat).toVar(testRoot / "Compendium.man");

        for(hkFileSystem::Iterator it(hkFileSystem::getInstancePtr(), testRoot.cString()); it.advance();)
        {
            const hkFileSystem::Entry& entry = it.current();
            Path path( entry.getPath() );
            if(entry.isDir())
            {
                it.recurseInto(path.cString());
            }
            else if(path.endsWith(".sk.man"))
            {
                if(hkReflect::Var v = hkSerialize::Load().withFormatState(&readFormat).toVar(path))
                {
                    HK_ASSERT_NO_MSG(0x5fb741fa, 0);
                }
                else
                {
                    HK_ASSERT_NO_MSG(0x2f588828, 0);
                }
                break;
            }
        }
    }
    // load 2 compendiums
    {
        hkSerialize::TagfileReadFormat readFormat;
        hkSerialize::Load().withFormatState(&readFormat).toVar(testRoot / "Compendium.man");
        hkSerialize::Load().withFormatState(&readFormat).toVar(testRoot / "Compendium.man");
    }
}

#include <stdio.h>

static int testTypeCompendium()
{
#if 0
    static const char* tests[] =
    {
        "Resources/Destruction/Scenes",
        "Resources/Destruction/Models",
        "Resources/Cloth/Hair",
        "Resources/Ai/Pathfinding",
        "Resources/Animation",
        "Resources/Physics",
        "Resources/Physics2012",
        //"Resources/Common/Graphics",
        //"Resources/Ai/ShowCase/Internal/Gdc2009/Final",
        "Resources/Behavior/GameAssets/Soldier",
    };
    struct Case { bool ver; int lim; };
    static Case runCases[] =
    {
        { true, 0 },
//      { false, 0 },
//      { true, 100 * 1024 },
//      { false, 100 * 1024 },
    };
    for(int run = 0; run < HK_COUNT_OF(runCases); ++run)
    {
//      bool version = runCases[run].ver;
//      int sizeLimit = runCases[run].lim;
        //for(int c = 0; c < 10; ++c)
        {
            for(int i = 0; i < HK_COUNT_OF(tests); ++i)
            {
                createTypeCompendium(tests[i]);
                //readTypeCompendium(tests[i], version, sizeLimit);
                //brokenTypeCompendium(tests[i]);
            }
        }
        hkStringBuf sn; sn.format("{} {}", numNORM, ticksNORM);
        hkStringBuf sc; sc.format("{} {}", numCOMP, ticksCOMP);
        printf("NORM %s\n", sn.cString());
        printf("COMP %s\n", sc.cString());
        numNORM = numCOMP = 0;
        ticksCOMP = ticksNORM = 0;
    }

#endif
    return 0;
}

HK_TEST_REGISTER(testTypeCompendium, "Slow", "Common/Test/UnitTest/Base/", __FILE__);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
