// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/System/Io/Reader/hkStreamReader.h>
#include <Common/Base/System/Io/Writer/hkStreamWriter.h>

#include <Common/Base/UnitTest/Cloning/CloneTestClasses.h>
#include <Common/Base/Serialize/hkSerialize.h>
#include <Common/Serialize/Util/hkSerializeUtil.h>
#include <Common/Base/Serialize/Resource/hkObjectResource.h>
#include <Common/Base/System/Io/Util/hkLoadUtil.h>
#include <Common/Base/Reflect/TypeReg/hkTypeReg.h>
#include <Common/Base/UnitTest/Cloning/CloneTest.h>
#include <Common/Base/Serialize/Format/Tagfile/hkTagfileWriteFormat.h>
#include <Common/Base/Serialize/Format/Tagfile/hkTagfileReadFormat.h>
#include <Common/Base/Reflect/Builder/hkTypeCopier.h>
#include <Common/Base/Serialize/Detail/hkSerializeDetail.h>
#include <Common/Base/Config/hkOptionalComponent.h>
#include <Common/Base/Serialize/Util/hkExtraInplaceLoadUtil.h>
#include <Common/Base/UnitTest/Serialize/urlObjects.h>
#include <Common/Base/Serialize/Format/Compression/hkCompressionWriteFormat.h>
#include <Common/Base/Serialize/Format/Compression/hkCompressionReadFormat.h>

#ifndef HK_NONSDK_BUILD
    #include <Common/Base/Serialize/Format/Xml/hkXmlWriteFormat.h>
    #include <Common/Base/Serialize/Format/Xml/hkXmlReadFormat.h>
#endif

struct IdentTypeReg : public hkReflect::TypeReg
{
    virtual const hkReflect::Type* typeFromName(const char* name) const { HK_ASSERT_NO_MSG(0x2dbb5a05,0); return 0; }
    virtual void appendAllTypesToArray(hkArray<const hkReflect::Type*>& types) const { HK_ASSERT_NO_MSG(0x7146c2,0); }
    virtual const hkReflect::Type* typeFromType(const hkReflect::Type* type) const { return type; }
};

// test inplace serialization using native types
struct InplaceSerializer : public UnitTest::Cloning::Serializer
{
    InplaceSerializer() : m_targetPlatform(HK_NULL) {}

    void unload()
    {
        for ( int i = 0; i < m_loaded.getSize(); ++i )
        {
            // don't try to destroy if load failed
            if(m_loaded[i].m_var)
            {
                hkArray<char>& a = m_loaded[i].m_buf;
                HK_TEST(hkSerialize::InplaceLoad::unload(a.begin(), a.getSize()).isSuccess());
            }
        }
        m_loaded.clear();
    }
    ~InplaceSerializer()
    {
        unload();
    }
    virtual void serialize(const char* testName, const hkReflect::Var& root, hkStreamWriter* sw) HK_OVERRIDE
    {
        hkSerialize::Save().withTarget(m_targetPlatform).contentsVar(root, sw);
    }

    virtual hkReflect::Var deserialize(const char* testname, hkStreamReader* sr) HK_OVERRIDE
    {
        VarInBuf& varInBuf = m_loaded.expandOne();
        hkArray<char>& buf = varInBuf.m_buf;
        hkLoadUtil(sr).toArray( buf );
        varInBuf.m_var = hkSerialize::InplaceLoad().toVar(buf.begin(), buf.getSize());
        return varInBuf.m_var;
    }

    virtual bool mustDeleteCopy() HK_OVERRIDE
    {
        return false;
    }

    struct VarInBuf
    {
        hkReflect::Var m_var;
        hkArray<char> m_buf;
    };
    const char* m_targetPlatform;
    hkArray<VarInBuf> m_loaded;
};

// test inplace serialization using type retargeting.
struct InplaceSerializerWithRetarget : public InplaceSerializer
{
    InplaceSerializerWithRetarget() { m_targetPlatform = hkReflect::TypeCopier::getHostString(); }
};

struct InplaceSerializerWithCompendium : public InplaceSerializer
{
    ~InplaceSerializerWithCompendium()
    {
        unload();
    }
    virtual void serialize(const char* testName, const hkReflect::Var& root, hkStreamWriter* sw) HK_OVERRIDE
    {
        hkSerialize::Save save;
        save.withTarget(m_targetPlatform);
        save.beginTypeCompendium(&m_compendiums.expandOne());
        save.contentsVar(root, sw);
        save.endTypeCompendium();
    }
    virtual hkReflect::Var deserialize(const char* testname, hkStreamReader* sr) HK_OVERRIDE
    {
        VarInBuf& varInBuf = m_loaded.expandOne();
        hkArray<char>& buf = varInBuf.m_buf;
        hkLoadUtil(sr).toArray(buf);
        varInBuf.m_var = hkSerialize::InplaceLoad()
            .withCompendium(m_compendiums.back().begin(), m_compendiums.back().getSize())
            .toVar(buf.begin(), buf.getSize());
        return varInBuf.m_var;
    }
    hkArray< hkArray<char> > m_compendiums;
};

// test inplace serialization using unload and reload.
struct InplaceSerializerWithUnloadReload : public InplaceSerializer
{
    virtual hkReflect::Var deserialize(const char* testname, hkStreamReader* sr) HK_OVERRIDE
    {
        VarInBuf& varInBuf = m_loaded.expandOne();
        hkArray<char>& buf = varInBuf.m_buf;
        hkLoadUtil(sr).toArray(buf);

        // First load.
        hkReflect::Var var = hkSerialize::InplaceLoad().toVar(buf.begin(), buf.getSize());

        if (HK_TEST(var.isValid()))
        {
            // Safe unload.
            hkResult res = hkSerialize::ExtraInplaceLoadUtil::unloadAndPrepareForInplaceReload(buf.begin(), buf.getSize());
            if (HK_TEST(res.isSuccess()))
            {
                // Reload.
                varInBuf.m_var = hkSerialize::InplaceLoad().toVar(buf.begin(), buf.getSize());
            }
        }

        return varInBuf.m_var;
    }
};

// test inplace serialization using inplace file relocation.
struct InplaceSerializerWithRelocate : public InplaceSerializer
{
    virtual hkReflect::Var deserialize(const char* testname, hkStreamReader* sr) HK_OVERRIDE
    {
        VarInBuf& varInBuf = m_loaded.expandOne();
        hkArray<char>& buf = varInBuf.m_buf;
        hkLoadUtil(sr).toArray(buf);

        // Load.
        varInBuf.m_var = hkSerialize::InplaceLoad().toVar(buf.begin(), buf.getSize());
        if (HK_TEST(varInBuf.m_var))
        {
            // Relocate the buffer.
            const void* oldAddress = buf.begin();
            hkArray<char> newBuf = buf;
            buf.swap(newBuf);
            hkResult relocateRes = hkSerialize::ExtraInplaceLoadUtil::relocateInplaceLoadBuffer(
                oldAddress, buf.begin(), buf.getSize());
            if (HK_TEST(relocateRes.isSuccess()))
            {
                // Relocate the var reference.
                varInBuf.m_var.setAddress(hkAddByteOffset(varInBuf.m_var.getAddress(), hkGetByteOffset(oldAddress, buf.begin())));
            }
        }

        return varInBuf.m_var;
    }
};

template<typename WFORMAT, typename RFORMAT, bool VERSIONING>
struct GenericSerializer : public UnitTest::Cloning::Serializer
{
    virtual void serialize(const char* testName, const hkReflect::Var& root, hkStreamWriter* sw) HK_OVERRIDE
    {
        hkSerialize::Save().withFormat<WFORMAT>().contentsVar(root, sw);
    }
    virtual hkReflect::Var deserialize(const char* testname, hkStreamReader* sr) HK_OVERRIDE
    {
        hkRefPtr<hkObjectResource> res = hkSerialize::Load().withVersioning(VERSIONING).withFormat<RFORMAT>().toResource(sr);

        if(HK_TEST(res))
        {
            const hkReflect::Type *const contentsType = res->getContentsType();
            return hkReflect::Var(res->stealContentsPointer(res->getContentsTypeName()), contentsType);
        }
        return hkReflect::Var();
    }
};


template<typename WFORMAT, typename RFORMAT, bool VERSIONING>
struct GenericSerializerCompendium : public UnitTest::Cloning::Serializer
{
    hkArray<char> m_compendium;
    virtual void serialize(const char* testName, const hkReflect::Var& root, hkStreamWriter* sw) HK_OVERRIDE
    {
        m_compendium.clear();
        hkSerialize::Save save;
        save.withFormat<WFORMAT>().beginTypeCompendium(&m_compendium);
        save.contentsVar(root, sw);
        save.endTypeCompendium();
    }

    virtual hkReflect::Var deserialize(const char* testname, hkStreamReader* sr) HK_OVERRIDE
    {
        HK_ASSERT_NO_MSG(0x350f05d1, m_compendium.getSize());
        hkSerialize::Load load; load.withFormat<RFORMAT>().withVersioning(VERSIONING);
        load.loadCompendium(m_compendium);
        m_compendium.clear();
        hkRefPtr<hkObjectResource> res = load.toResource(sr);

        if(HK_TEST(res))
        {
            const hkReflect::Type *const contentsType = res->getContentsType();
            return hkReflect::Var(res->stealContentsPointer(res->getContentsTypeName()), contentsType);
        }
        return hkReflect::Var();
    }
};



template<typename Serializer>
static void testNoVersion(UnitTest::Cloning::DisableFlags flags)
{
    Serializer ser;
    
    ser.m_targetPlatform = hkReflect::TypeCopier::getHostString();
    UnitTest::Cloning::TEST_MAIN_BREAK_HERE(ser, flags);
}

template<typename WFORMAT, typename RFORMAT>
static void testNormal(UnitTest::Cloning::DisableFlags flags)
{
    using namespace UnitTest::Cloning;
    // test without versioning, then with.
    {
        GenericSerializer<WFORMAT, RFORMAT, false> ser;
        TEST_MAIN_BREAK_HERE(ser, flags);
    }
    {
        GenericSerializer<WFORMAT, RFORMAT, true> ser;
        TEST_MAIN_BREAK_HERE(ser, flags);
    }
}

template<typename WFORMAT, typename RFORMAT>
static void testWithCompendium(UnitTest::Cloning::DisableFlags flags)
{
    {
        GenericSerializerCompendium<WFORMAT, RFORMAT, false> ser;
        TEST_MAIN_BREAK_HERE(ser, flags);
    }
    {
        GenericSerializerCompendium<WFORMAT, RFORMAT, true> ser;
        TEST_MAIN_BREAK_HERE(ser, flags);
    }
}

// test that when saving as inplace loadable, it is loadable as non-inplace
struct InplaceToNormalSerializer : public UnitTest::Cloning::Serializer
{
    typedef hkRefNew<hkObjectResource> (InplaceToNormalSerializer::*LoadFunc)(const char* testname, hkStreamReader* sr);

    LoadFunc m_loadFunc;
    InplaceToNormalSerializer(LoadFunc func) : m_loadFunc(func) {}

    virtual void serialize(const char* testName, const hkReflect::Var& root, hkStreamWriter* sw) HK_OVERRIDE
    {
        
        hkSerialize::Save().withTarget(hkReflect::TypeCopier::getHostString()).contentsVar(root, sw);
    }
    virtual hkReflect::Var deserialize(const char* testname, hkStreamReader* sr) HK_OVERRIDE
    {
        hkRefPtr<hkObjectResource> res = (this->*m_loadFunc)(testname, sr);

        if(HK_TEST(res))
        {
            const hkReflect::Type *const contentsType = res->getContentsType();
            return hkReflect::Var(res->stealContentsPointer(res->getContentsTypeName()), contentsType);
        }
        return hkReflect::Var();
    }

    hkRefNew<hkObjectResource> deserializeStreamy(const char* testname, hkStreamReader* sr)
    {
        return hkSerialize::Load().toResource(sr);
    }

    hkRefNew<hkObjectResource> deserializeBuffer(const char* testname, hkStreamReader* sr)
    {
        hkArray<char> buf; hkLoadUtil(sr).toArray(buf);
        return hkSerialize::Load().toResource(buf.begin(), buf.getSize());
    }

    static void testStream(UnitTest::Cloning::DisableFlags flags)
    {
        InplaceToNormalSerializer ser(&InplaceToNormalSerializer::deserializeStreamy);
        TEST_MAIN_BREAK_HERE(ser, flags);
    }
    static void testBuffer(UnitTest::Cloning::DisableFlags flags)
    {
        InplaceToNormalSerializer ser(&InplaceToNormalSerializer::deserializeBuffer);
        TEST_MAIN_BREAK_HERE(ser, flags);
    }
};


void testSignatureMismatch()
{
    //typedef hkDouble64Be TESTTYPE;
    typedef double TESTTYPE;
    TESTTYPE orig = 3.14;
    hkArray<char> origBuf;
    hkSerialize::Save().withTarget(HK_NULL).contentsPtr(&orig, &origBuf);

    TESTTYPE* copy = HK_NULL;
    copy = hkSerialize::Load().toObject<TESTTYPE>(origBuf.begin(), origBuf.getSize());
    if(HK_TEST(copy))
    {
        HK_TEST(*copy == orig);
        hkMemHeapDestroy(copy);
        copy = HK_NULL;
    }

    {
        hkArray<char> buf = origBuf; // copy for inplace
        copy = hkSerialize::InplaceLoad()
            .toObject<TESTTYPE>(buf.begin(), buf.getSize());
        if(HK_TEST(copy))
        {
            HK_TEST(*copy == orig);
            HK_TEST(hkSerialize::InplaceLoad::unload(buf.begin(), buf.getSize()).isSuccess());
            copy = HK_NULL;
        }
    }

    {
        struct FakeReg : public hkReflect::TypeReg
        {
            virtual const hkReflect::Type* typeFromName(const char* name) const { HK_TEST(false); return HK_NULL; }
            virtual const hkReflect::Type* typeFromType(const hkReflect::Type* type) const
            {
                //HK_TEST(false);
                return hkReflect::getType<hkFloat64Le>();
            }
        };
        FakeReg fakereg;
        hkArray<char> buf = origBuf; // copy for inplace
        UnitTest::Raii::CaptureThreadLogOutput capture;
        copy = hkSerialize::InplaceLoad()
            .withTypeReg(&fakereg)
            .toObject<TESTTYPE>(buf.begin(), buf.getSize());
        HK_TEST(copy == HK_NULL);
        hkStringBuf sb;
        HK_TEST(capture.getText(sb));
    }
}

static int testTagFileSaveLoad_main()
{
    testSignatureMismatch();
    testWithCompendium<hkSerialize::TagfileWriteFormat, hkSerialize::TagfileReadFormat>(UnitTest::Cloning::DISABLE_NONE);

    // Dynamic types are not supported in-place since they don't correspond to pre-existing builtin types
    testNoVersion<InplaceSerializer>(UnitTest::Cloning::DISABLE_INPLACE | UnitTest::Cloning::DISABLE_DYNAMICTYPES);
    testNoVersion<InplaceSerializerWithRetarget>(UnitTest::Cloning::DISABLE_INPLACE | UnitTest::Cloning::DISABLE_DYNAMICTYPES);
    testNoVersion<InplaceSerializerWithCompendium>(UnitTest::Cloning::DISABLE_INPLACE | UnitTest::Cloning::DISABLE_DYNAMICTYPES);

#if HK_ENDIAN_LITTLE
    testNoVersion<InplaceSerializerWithUnloadReload>(UnitTest::Cloning::DISABLE_INPLACE | UnitTest::Cloning::DISABLE_NULL_VARIANT | UnitTest::Cloning::DISABLE_DYNAMICTYPES);
    testNoVersion<InplaceSerializerWithRelocate>(UnitTest::Cloning::DISABLE_INPLACE | UnitTest::Cloning::DISABLE_NON_RELOCATABLE | UnitTest::Cloning::DISABLE_DYNAMICTYPES);
#endif

    testNormal<hkSerialize::TagfileWriteFormat, hkSerialize::TagfileReadFormat>(UnitTest::Cloning::DISABLE_NONE);

    InplaceToNormalSerializer::testStream(UnitTest::Cloning::DISABLE_INPLACE | UnitTest::Cloning::DISABLE_INPLACE);
    InplaceToNormalSerializer::testBuffer(UnitTest::Cloning::DISABLE_INPLACE | UnitTest::Cloning::DISABLE_INPLACE);

    testNormal<hkSerialize::CompressionWriteFormat, hkSerialize::CompressionReadFormat>(UnitTest::Cloning::DISABLE_NONE);

#ifndef HK_NONSDK_BUILD
    
    testNormal<hkSerialize::XmlWriteFormat, hkSerialize::XmlReadFormat>( UnitTest::Cloning::DISABLE_NO_XML | UnitTest::Cloning::DISABLE_DYNAMICTYPES );

#if defined(HK_BUILDING_WITH_ENGINE)
    typedef UnitTest::OptionalReadFormatWrapper<&hkSerialize::Detail::fileFormatYamlfile> YamlReadFormat;
    typedef UnitTest::OptionalWriteFormatWrapper<&hkSerialize::Detail::fileFormatYamlfile> YamlWriteFormat;

    if ( HK_TEST( YamlReadFormat::isAvailable() ) && HK_TEST( YamlWriteFormat::isAvailable() ) )
    {
        testNormal<YamlWriteFormat, YamlReadFormat>( UnitTest::Cloning::DISABLE_NONE );
    }
#endif
#endif


    return 0;
}

HK_TEST_REGISTER(testTagFileSaveLoad_main, "Fast", "Common/Test/UnitTest/Base/", __FILE__);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
