// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/Reflect/TypeReg/hkTypeReg.h>

#include <Common/Base/Reflect/Builder/hkRecordLayout.h>
#include <Common/Base/Reflect/Core/Detail/hkReflectTypeDetail.h>

namespace
{
    bool s_canBeRecomputed(const hkReflect::Type* type)
    {
        // skip non-serializable types
        if ( hkReflect::TypeDetail::getFlags(type).anyIsSet(hkReflect::Type::TYPE_NOT_SERIALIZABLE | hkReflect::Type::TYPE_ABSTRACT)) 
        {
            return false;
        }

        if (const hkReflect::RecordType* rec = type->asRecord())
        {
            // skip classes with incomplete fields
            for( hkReflect::DeclIter<hkReflect::DataFieldDecl> ci(rec); ci.advance(); )
            {
                if (ci.current().getType()->asOpaque())
                {
                    return false;
                }
            }
        }
        return true;
    }
}

int testRecordLayout_main()
{
    hkReflect::TypeRegIterator it(hkReflect::getTypeReg());

    while(it.advance())
    {
        const hkReflect::Type* currentType = it.current();

        if (!s_canBeRecomputed(currentType))
        {
            continue;
        }

        // check that running the recomputation on native types does not break anything
        int origSize = currentType->getSizeOf();
        int origAlign = currentType->getAlignOf();

        hkReflect::RecordLayout::recomputeNative(const_cast<hkReflect::Type*>(currentType));

        HK_TEST(currentType->getSizeOf() == origSize);
        HK_TEST(currentType->getAlignOf() == origAlign);
    }
    return 0;
}

// Test registration
HK_TEST_REGISTER(testRecordLayout_main, "Fast", "Common/Test/UnitTest/Base/", __FILE__);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
