// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/Serialize/hkSerialize.h>

namespace UnitTest
{
    static void testVar(const hkReflect::Var& testObject)
    {
        // For each field of the input testObject, we send it in a separate "packet".
        // After reading, we clear the packet to try to catch any stray pointers
        // which should have copied the data out of a previous packet.

        hkSerialize::Load load;
        hkSerialize::Save save; save.withMultiBundle();
        hkArray< hkArray<char> > buffers;

        using namespace hkReflect;
        for(DeclIter<FieldDecl> it(testObject.getType()); it.advance();)
        {
            const FieldDecl& decl = it.current();
            Var fieldVar = testObject[decl];
            Var var(fieldVar.getAddress(), decl.getType()->getParent());
            hkArray<char>& buf = buffers.expandOne();
            save.contentsVar(var, &buf);
            Var v = load.toVar(hkArrayViewT::make(buf.begin(),buf.getSize()));
            hkMemUtil::memSet(buf.begin(), 0xff, buf.getSize());
            v.destroy();
        }
        buffers.clear();
    }

    template<typename T>
    static void testObj(const T& t)
    {
        testVar(&t);
    }
}

static int MultiPacket_SaveLoad()
{
    using namespace UnitTest;

    // Create some test data.
    hkArray<int> iarr;
    iarr.pushBack(101);
    iarr.pushBack(102);
    iarr.pushBack(103);

    testObj(hkTupleT::make(10, 20, 30, 20));
    testObj(hkTupleT::make(10, iarr, iarr, 20, iarr, 20));

    return 0;
}

HK_TEST_REGISTER(MultiPacket_SaveLoad, "Fast", "Common/Test/UnitTest/Base/", __FILE__);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
