// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#if 0
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/Reflect/TypeReg/hkTypeReg.h>

#include <Common/Base/UnitTest/Serialize/PatchTest/TestTemplatePatches.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Serialize/Provider/Versioning/hkVersioningProvider.h>
#include <Common/Base/Reflection/TypeVmOld/Compiler/hkTypeVmCachingCompiler.h>
#include <Common/Serialize/Util/hkTodoList.h>
#include <Common/Base/Reflect/TypeVm/hkTypeVmInterpreter.h>
#include <Common/Base/Serialize/Format/Tagfile2014/hkTagfileCommon2014.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>

void templateTopLevel_patch_1_2(hkDataObject& obj)
{
    hkDataObject intContainer = obj["intContainer"].asObject();
    intContainer["data"] = 10;
    intContainer["data3"] = -10;

    {
        const hkUlong valueParam = intContainer.getClass().getValueParameter("N");
        printf("Int container: %llu\n", valueParam);
    }

    hkDataObject realContainer = obj["realContainer"].asObject();
    realContainer["data"] = 27.3f;
    realContainer["data3"] = -55.2f;

    {
        const hkUlong valueParam = realContainer.getClass().getValueParameter("N");
        printf("Real container: %llu\n", valueParam);
    }

    printf("Hit\n");
}

namespace TTP
{
    void registerPatches(hkVersionPatchManager& man)
    {
#   define HK_PATCHES_FILE <Common/Serialize/UnitTest/PatchTest/TestTemplatePatches.hxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>
#   undef HK_PATCHES_FILE
    }

    int testTemplatePatches()
    {
#if 1
        return 0;
#else

        hkVersionPatchManager patchSet;
        registerPatches(patchSet);

        patchSet.recomputePatchDependencies();

        hkObjectVersioning versioning(hkReflect::getTypeReg(), patchSet);
        hkSet<const hkReflect::Type*> types;
        hkTransientAllocator objectAllocator(hkMemHeapAllocator());

        {
            TestTemplateTopLevelStart thing;

            hkObjectStreamCommon::LoadedObjects sourceObj; sourceObj.set(&thing, hkReflect::getType<TestTemplateTopLevelStart>(), hkObjectStreamCommon::ObjectId::create(1));
            versioning.addInputObject(sourceObj);

            versioning.performVersioning();

            hkObjectCopyToNative copyToNative(hkReflect::getTypeReg());

            hkObjectStreamCommon::LoadedObjects nextObjects;
            hkStringPtr nameOutUnused;
            bool isTopLevelOutUnused;

            while(versioning.getNextObject(nextObjects, nameOutUnused, isTopLevelOutUnused).isSuccess())
            {
                copyToNative.addInputObject(nextObjects);
            }

            hkArray<hkObjectStreamCommon::LoadedObjects> loadedObjectsOut;
            hkArray<hkObjectStreamCommon::ObjectWithId> danglingReferencesOut;
            copyToNative.performCopy(loadedObjectsOut, danglingReferencesOut);

            const TestTemplateTopLevelEnd* obj = loadedObjectsOut[0].object().dynCast<TestTemplateTopLevelEnd>();
            if(HK_TEST(obj))
            {
                HK_TEST(obj->m_intContainer.m_data == 10);
                HK_TEST(obj->m_intContainer.m_data3 == -10);
                HK_TEST(obj->m_realContainer.m_data == 27.3f);
                HK_TEST(obj->m_realContainer.m_data3 == -55.2f);
            }

            delete obj;
        }

        return 0;
#endif
    }
}
using namespace TTP;
HK_TEST_DONT_REGISTER(testTemplatePatches, "Fast", "Common/Test/UnitTest/Serialize/", __FILE__ );
#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
