// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/Serialize/hkSerialize.h>
#include <Common/Base/System/Log/hkLog.h>
#include <Common/Base/Types/Geometry/Aabb/hkAabb.h>

template<typename T>
static T peek()
{
    return T();
}
static void* read(hkLong l)
{
    return HK_NULL;
}
static void tellUser(const char*)
{
}

// Don't care about unused variables
HK_DETAIL_DIAG_MSVC_OFF(4189)

static void quickIntro_buffers()
{
    typedef int MyObject;
    {
        
        if(MyObject* myLoaded = hkSerialize::Load().toObject<MyObject>("filename"))
        {
            // load succeeded
        }
        
    }
    {
        
        MyObject obj;
        if(hkSerialize::Save().contentsPtr(&obj, "filename").isSuccess())
        {
            // save succeeded
        }
        
    }
    {
        MyObject obj;
        
        //error checking elided
        hkArray<char> buf;
        hkSerialize::Save().contentsPtr(&obj, &buf);
        MyObject* loaded = hkSerialize::Load().toObject<MyObject>(hkArrayViewT::make(buf.begin(), buf.getSize()));
        
        loaded = HK_NULL;
    }
    {
        
        hkLog::Raii::CaptureOutput capture;
        // if a load or save failed
        {
            hkStringBuf buf; // storage for "why"
            const char* whyNot = capture.getText(buf);
            tellUser(whyNot);
        }
        
    }
    {
        
        hkAabb original;
        hkSerialize::Save().contentsPtr(&original, "aabb.hkt"); //save to file
        hkAabb* loaded = hkSerialize::Load().withVersioning(false).toObject<hkAabb>("aabb.hkt");
        hkArray<char> buf;
        hkSerialize::Save().withTarget("64g").contentsPtr(loaded, &buf); // save to in memory buffer
        
    }

    {
        
        void* buffer = 0; hkLong bufferSize = 0;
        // fill buffer
        MyObject* object = hkSerialize::InplaceLoad().toObject<MyObject>(buffer, bufferSize);
        // use object
        // buffer must remain valid
        hkSerialize::InplaceLoad::unload(buffer, bufferSize);
        // discard buffer
        
        object = HK_NULL;
    }

    {
        typedef int MyObject1;
        typedef int MyObject2;
        
        hkSerialize::Save save;
        {
            hkArray<char> buf;
            MyObject1 obj1;
            save.contentsPtr(&obj1, &buf);
            //send buf over socket
        }
        {
            hkArray<char> buf;
            MyObject2 obj2;
            save.contentsPtr(&obj2, &buf);
            //send buf over socket
        }
        


        
        hkSerialize::Load load;
        {
            // assuming appropriate peek() and read() methods.
            hkUint32 len = peek<hkUint32Be>();
            void* data = read(len);
            MyObject1* obj1 = load.toObject<MyObject1>(hkArrayViewT::make((char*)data, len));
            delete obj1;
        }
        {
            hkUint32 len = peek<hkUint32Be>();
            void* data = read(len);
            // initialize data & size here
            MyObject2* obj2 = load.toObject<MyObject2>(hkArrayViewT::make((char*)data, len));
            delete obj2;
        }
        
    }

    {
        MyObject obj1;
        MyObject obj2;
        
        hkSerialize::Save save;
        save.beginTypeCompendium("Compendium.bin");

        save.contentsPtr(&obj1, "file1");
        save.contentsPtr(&obj2, "file2");

        save.endTypeCompendium();
        
    }

    {
        typedef int MyObject1;
        typedef int MyObject2;
        
        hkSerialize::Load load;
        load.loadCompendium("Compendium.bin");

        MyObject2* obj2 = load.toObject<MyObject2>("file2");
        MyObject1* obj1 = load.toObject<MyObject1>("file1");
        
        delete obj1;
        delete obj2;
    }

    {
        
        const hkReflect::Type* type = 0;
        if(const hk::Presets* presets = type->findAttribute<hk::Presets>()) {
            // this type has presets
        } else {
            // it doesn't
        }
        
    }
    {
        
        using namespace hkReflect;
        Var var;
        if(StringVar svar = var) {
            // "var" and "svar" refer to the same object
            // but now more specialized operations are available via "svar"
            const char* str = svar.getValue();
            svar.setValue("newvalue");
        }
        else if(FloatVar fvar = var) {
            double dbl = fvar.getValue();
            fvar.setValue(3.141);
        }
        else {} // also check other kinds
        
    }

    {
        
        using namespace hkReflect;
        Var var;
        if(PointerVar pvar = var) {
            Var target = pvar.getValue(); // dereference pointer
        }
        else if(ArrayVar avar = var) {
            hkReflect::ArrayValue arr = avar.getValue();
            for(int i = 0; i < arr.getCount(); ++i) {
                Var elem = arr[i];
            }
        }
        else if(RecordVar rv = var) {
            for(DeclIter<FieldDecl> iter(rv.getType()); iter.advance(); ) {
                FieldDecl field = iter.current();
                const char* fieldName = field.getName();
                Var fieldVar = rv[field];
            }
        }
        
    }

//  {
//      using namespace hkReflect;
//      
//      hkBaseObject* pointer = new hkReferencedObject();
//
//      PointerVar pvar(&pointer);
//      pvar.getType()->getSubType(); // hkBaseObject
//      pvar.getSubType(); // MyBase
//
//      
//  }
#if 0
    {
        extern int read(void*, int);
        extern int fail();
        hkArray<char> buf;
        if(read(buf.expandBy(4), 4) == 4)
        {
            hkUint32 totalSize = *(hkUint32Be*)buf.begin();
            int rest = totalSize - 4;
            if(read(buf.expandBy(rest), rest) == rest)
            {
                return hkSerialize::Load(buf.begin(), totalSize).etc();
            }
        }
        return fail();
    }
#endif
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
