// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/Serialize/hkSerialize.h>
#include <Common/Base/Reflect/Util/hkReflectAny.h>

static int testSerializeErrors()
{
    // load src asset
    hkReflect::Any srcAsset;
    srcAsset.stealOwnership( hkSerialize::Load().toVar("Resources/Common/Api/Serialize/CrossPlatformTests/Portable/UnitTest__WithTypeRef.hkt") );
    HK_TEST(srcAsset.containsObject());

    // save as targeted binary
    hkArray<char> srcDataFull;
    HK_TEST_SUCCESS( hkSerialize::Save().withTarget(nullptr).contentsVar(srcAsset.var(), &srcDataFull) );

    // check it loads normally
    {
        hkReflect::Var tmp = hkSerialize::Load().toVar(srcDataFull);
        HK_TEST(tmp);
        tmp.destroy();
    }

    // create a compendium
    hkArray<char> srcComp;
    hkArray<char> srcData;
    {
        hkSerialize::Save save;
        save.withTarget(nullptr).beginTypeCompendium(&srcComp);
        HK_TEST_SUCCESS( save.contentsVar(srcAsset.var(), &srcData) );
        save.endTypeCompendium();
    }

    //
    // On-heap loading
    //

    // check compendium load works
    {
        hkSerialize::Load load;
        if (HK_TEST_SUCCESS(load.loadCompendium(srcComp)))
        {
            hkReflect::Var tmp = load.toVar(srcData);
            if (HK_TEST(tmp))
            {
                tmp.destroy();
            }
        }
    }

    // loading needs types from either compendium or embedded
    //[s11n.TagfileReadFormat] Encountered compendium reference, but no compendium loaded
    {
        hkSerialize::Load load;
        UnitTest::Raii::CaptureThreadLogOutput capture; // don't pollute console
        hkReflect::Var tmp = load.toVar(srcData);
        HK_TEST(!tmp); // loading should have failed
        HK_TEST(capture.hasText()); // and we should have a log message
    }

    // loading both compendium & embedded types is an error
    // [s11n.TagfileReadFormat] Types cannot be added to when using a compendium.
    {
        hkSerialize::Load load;
        HK_TEST_SUCCESS(load.loadCompendium(srcComp));
        UnitTest::Raii::CaptureThreadLogOutput capture; // don't pollute console
        hkReflect::Var tmp = load.toVar(srcDataFull);
        HK_TEST(!tmp); // loading should have failed
        HK_TEST(capture.hasText()); // and we should have a log message
    }

    //
    // Inplace loading
    //

    // Test inplace loading with a compendium
    {
        // inplace loading is destructive, use copies;
        hkArray<char> copyComp = srcComp;
        hkArray<char> copyData = srcData;
        hkSerialize::InplaceLoad load;
        load.withCompendium(copyComp.begin(), copyComp.getSize()); //todo-no return value
        hkReflect::Var var = load.toVar(copyData.begin(), copyData.getSize());
        HK_TEST(var);
        hkSerialize::InplaceLoad::unload(copyData.begin(), copyData.getSize());
    }

    // loading needs types from either compendium or embedded
    // [s11n.TagfileReadFormat] Encountered compendium reference, but no compendium loaded
    {
        // inplace loading is destructive, use copies;
        hkArray<char> copyData = srcData;
        hkSerialize::InplaceLoad load;

        UnitTest::Raii::CaptureThreadLogOutput capture; // don't pollute console
        hkReflect::Var var = load.toVar(copyData.begin(), copyData.getSize());
        HK_TEST(!var); // loading should have failed
        HK_TEST(capture.hasText()); // and we should have a log message
    }

#if 0 
    // loading both compendium & embedded types is an error
    {
        // inplace loading is destructive, use copies;
        hkArray<char> copyComp = srcComp;
        hkArray<char> copyDataFull = srcDataFull;
        hkSerialize::InplaceLoad load;
        load.withCompendium(copyComp.begin(), copyComp.getSize()); //todo-no return value

        UnitTest::Raii::CaptureThreadLogOutput capture; // don't pollute console
        hkReflect::Var var = load.toVar(copyDataFull.begin(), copyDataFull.getSize());
        HK_TEST(!var);
        HK_TEST(capture.hasText()); // and we should have a log message
    }
#endif

    return 0;
}

HK_TEST_REGISTER(testSerializeErrors, "Fast", "Common/Test/UnitTest/Base/", __FILE__);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
