// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/Serialize/Detail/hkUintVle.h>
#include <Common/Base/Algorithm/PseudoRandom/hkPseudoRandomGenerator.h>

static void s_roundTripSigned(hkInt64 s)
{
    hkUintVle v = hkUintVle::encodeSigned(s);
    hkInt64 i = hkUintVle::decodeSigned(v);
    HK_TEST_EQ(s, i);
}

static int testSerializeDetail()
{
    hkPseudoRandomGenerator prng(0);
    for( int i = 0; i < 1000; ++i )
    {
        hkUint64 u = prng.getRand32();
        u = (u<<32) | prng.getRand32();

        // ensure lower values get more coverage
        for( ; u > 128; u >>= 1 )
        {
            hkUintVle vw(u);

            hkUint8 buf[9] = {};
            int nw = vw.write(buf);

            int nr;
            hkUintVle vr = hkUintVle::read(buf, nr);

            HK_TEST( nr == nw );
            HK_TEST( hkUint64(vw) == hkUint64(vr) );
        }
    }

    {
        s_roundTripSigned(-1);
        s_roundTripSigned(0);
        s_roundTripSigned(2);
        s_roundTripSigned(hkTrait::NumericLimits<hkInt64>::minValue());
        s_roundTripSigned(hkTrait::NumericLimits<hkInt64>::maxValue());
    }
    return 0;
}

HK_TEST_REGISTER(testSerializeDetail, "Fast", "Common/Test/UnitTest/Base/", __FILE__);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
