// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

namespace castTest
{
    struct Root
    {
        HK_DECLARE_CLASS(Root, NewPlacement, ReflectVirtualBase);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

        Root() {}
        virtual ~Root() {}
    };

    struct Leaf : public Root
    {
        HK_DECLARE_REFLECTION();
        HK_DECLARE_PLACEMENT_ALLOCATOR();
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
        Leaf() {}
    };

    struct OtherLeaf : public Root
    {
        HK_DECLARE_REFLECTION();
        HK_DECLARE_PLACEMENT_ALLOCATOR();
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
        OtherLeaf() {}
    };

    struct NonLeaf
    {
        HK_DECLARE_REFLECTION();
        HK_DECLARE_PLACEMENT_ALLOCATOR();
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
        NonLeaf() {}
    };

    template<typename T>
    struct TemplatedLeaf : public Root
    {
        HK_DECLARE_CLASS(TemplatedLeaf, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

        TemplatedLeaf() {}
    };

    struct InterfaceBase
    {
        HK_DECLARE_CLASS(InterfaceBase, New, ReflectVirtualBase);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
        virtual ~InterfaceBase() {}
    };

    struct InterfaceOtherBase
    {
        HK_DECLARE_CLASS(InterfaceOtherBase, New, ReflectVirtualBase);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
        virtual ~InterfaceOtherBase() {}
    };

    struct Interface0 : public InterfaceBase, InterfaceOtherBase
    {
        HK_DECLARE_CLASS(Interface0, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
        virtual ~Interface0() {}
        const char* func0() { return "Interface0.func0"; }
    };
    struct Interface1 : public InterfaceBase
    {
        HK_DECLARE_CLASS(Interface1, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
        virtual ~Interface1() {}
        virtual const char* func1() { return "Interface1.func1"; }
    };
    struct Interface2 : public InterfaceBase
    {
        HK_DECLARE_CLASS(Interface2, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
        virtual ~Interface2() {}
        virtual const char* func2() { return "Interface1.func2"; }
    };

    struct WithInterfaces : public hkReferencedObject
        , public Interface1
        , public Interface0
        , public Interface2
    {
        HK_DECLARE_CLASS(WithInterfaces, New, Reflect, BypassCtor);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
        WithInterfaces() {}
        virtual const char* func2() HK_OVERRIDE { return "WithInterfaces.func2"; }
    };

    template<typename T>
    struct TemplateWithInterfaces : public hkReferencedObject
        , public Interface1
        , public Interface0
        , public Interface2
    {
        HK_DECLARE_CLASS(TemplateWithInterfaces, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
        TemplateWithInterfaces() {}
        virtual const char* func2() HK_OVERRIDE { return "TemplateWithInterfaces.func2"; }
    };
}

#include <Common/Base/_Auto/TemplateTypes/castsTest_Types.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
