// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/UnitTest/Reflection/castsTest.h>

#define TEST_BOTH_DYNCAST(To, obj, result) \
    do { \
        HK_TEST(hkDynCast<To>(obj) result); \
        HK_TEST(((const To*)hkDynCast(obj)) result); \
    } while(0)

static void castTests1()
{
    const hkReflect::ArrayType* integer_array = hkReflect::getType<hkArray<int> >()->asArray();
    const hkReflect::IntType* integer = hkReflect::getType<int>()->asInteger();
    const hkReflect::Type* base_integer = hkReflect::getType<int>();
    const hkReflect::Type* base_integer_array = integer_array;

    /////////////////// hkDynCast //////////////////////////////////
    TEST_BOTH_DYNCAST(hkReflect::IntType, integer, != HK_NULL);
    TEST_BOTH_DYNCAST(hkReflect::IntType, base_integer, != HK_NULL);

    TEST_BOTH_DYNCAST(hkReflect::ValueType, integer, != HK_NULL);
    TEST_BOTH_DYNCAST(hkReflect::ValueType, base_integer, != HK_NULL);

    TEST_BOTH_DYNCAST(hkReflect::Type, integer, != HK_NULL);
    //HK_TEST(hkDynCast<hkReflect::Type>(static_cast<const void*>(integer), hkReferencedObject::staticType()) == HK_NULL);
    TEST_BOTH_DYNCAST(hkReflect::Type, base_integer, != HK_NULL);

    //HK_TEST(hkDynCast<hkReflect::FloatType>(integer) == HK_NULL); // Rightfully doesn't compile
    TEST_BOTH_DYNCAST(hkReflect::FloatType, base_integer, == HK_NULL);

    TEST_BOTH_DYNCAST(hkReflect::IntType, base_integer_array, == HK_NULL);
    TEST_BOTH_DYNCAST(hkReflect::ArrayType, base_integer_array, != HK_NULL);
    TEST_BOTH_DYNCAST(hkReflect::Type, base_integer_array, != HK_NULL);

    /////////////////// isExactlyA //////////////////////////////////
    HK_TEST(hkReflect::exactMatchDynCast<hkReflect::IntType>(integer) != HK_NULL);
    HK_TEST(hkReflect::exactMatchDynCast<hkReflect::IntType>(base_integer) != HK_NULL);

    HK_TEST(hkReflect::exactMatchDynCast<hkReflect::ValueType>(integer) == HK_NULL);
    //HK_TEST(hkReflect::exactMatchDynCast<hkReflect::ValueType>(base_integer) == HK_NULL);

    HK_TEST(hkReflect::exactMatchDynCast<hkReflect::Type>(integer) == HK_NULL);
    //HK_TEST(hkReflect::exactMatchDynCast<hkReflect::Type>(static_cast<const void*>(integer), hkReferencedObject::staticType()) == HK_NULL);
    //HK_TEST(hkReflect::exactMatchDynCast<hkReflect::Type>(base_integer) == HK_NULL);

    //HK_TEST(hkReflect::exactMatchDynCast<hkReflect::FloatType>(integer) == HK_NULL); // Rightfully doesn't compile
    HK_TEST(hkReflect::exactMatchDynCast<hkReflect::FloatType>(base_integer) == HK_NULL);

    HK_TEST(hkReflect::exactMatchDynCast<hkReflect::IntType>(base_integer_array) == HK_NULL);
    HK_TEST(hkReflect::exactMatchDynCast<hkReflect::ArrayType>(base_integer_array) != HK_NULL);
    //HK_TEST(hkReflect::exactMatchDynCast<hkReflect::Type>(base_integer_array) == HK_NULL);

    HK_TEST(base_integer->asInteger());
    HK_TEST(base_integer->asValue());

    HK_TEST(base_integer_array->asArray());
    //HK_TEST(base_integer_array->isContainer());

    const hkReflect::Type* base_string = hkReflect::getType<const char*>();
    HK_TEST(base_string->asString());
    HK_TEST(base_string->asValue());

}

static void castTests2()
{
    using namespace castTest;

    Leaf leaf_var;
    Leaf* leaf_ptr = &leaf_var;
    Root* root_ptr = leaf_ptr;
    TemplatedLeaf<int> templated_leaf_var;
    //NonLeaf nonLeaf_var;
    //NonLeaf* nonLeaf_ptr = &nonLeaf_var;

    HK_TEST(hkReflect::exactMatchDynCast<Leaf>(leaf_ptr) == leaf_ptr);
    HK_TEST(hkReflect::exactMatchDynCast<Leaf>(root_ptr) == leaf_ptr);

    //HK_TEST(hkReflect::exactMatchDynCast<OtherLeaf>(leaf_ptr) == HK_NULL); // Doesn't compile
    HK_TEST(hkReflect::exactMatchDynCast<OtherLeaf>(root_ptr) == HK_NULL);

    //HK_TEST(hkReflect::exactMatchDynCast<NonLeaf>(leaf_ptr) == HK_NULL); // Doesn't compile
    //HK_TEST(hkReflect::exactMatchDynCast<NonLeaf>(root_ptr) == HK_NULL); // Doesn't compile

    HK_TEST(hkReflect::exactMatchDynCast<Root>(leaf_ptr) == HK_NULL);
    HK_TEST(hkReflect::exactMatchDynCast<Root>(root_ptr) == HK_NULL);


    HK_TEST(hkDynCast<Leaf>(leaf_ptr) == leaf_ptr);
    HK_TEST(hkDynCast<Leaf>(root_ptr) == leaf_ptr);

    //HK_TEST(hkDynCast<OtherLeaf>(leaf_ptr) == HK_NULL); // Doesn't compile
    HK_TEST(hkDynCast<OtherLeaf>(root_ptr) == HK_NULL);

    //HK_TEST(hkDynCast<NonLeaf>(leaf_ptr) == HK_NULL); // Doesn't compile
    //HK_TEST(hkDynCast<NonLeaf>(root_ptr) == HK_NULL); // Doesn't compile

    HK_TEST(hkDynCast<Root>(leaf_ptr) == leaf_ptr);
    HK_TEST(hkDynCast<Root>(root_ptr) == leaf_ptr);

    // These don't work until templated types are registered
    //HK_TEST(hkDynCast<Root>(&templated_leaf_var) != HK_NULL);
    //HK_TEST(hkDynCast< TemplatedLeaf<int> >(root_ptr) == HK_NULL);

    const hkReflect::Type* leaf_type = hkReflect::exactTypeOf(leaf_ptr);
    const hkReflect::Type* root_type = hkReflect::getType<Root>();

    // Considering hkTypes as objects
    HK_TEST(hkReflect::exactMatchDynCast<hkReflect::RecordType>(leaf_type) != HK_NULL);
    HK_TEST(hkDynCast<hkReflect::RecordType>(leaf_type) != HK_NULL);

    // Considering hkTypes as types
    HK_TEST(leaf_type->equals(leaf_type));
    HK_TEST(root_type->equals(leaf_type) == false);
    HK_TEST(leaf_type->equals<hkReflect::RecordType>() == false);
    HK_TEST(leaf_type->equals<hkReflect::IntType>() == false);
    HK_TEST(leaf_type->equals<Leaf>() );
    HK_TEST(leaf_type->equals<Root>() == false);

    HK_TEST(leaf_type->extendsOrEquals(root_type) );
    HK_TEST(leaf_type->extendsOrEquals<hkReflect::RecordType>() == false);
    HK_TEST(leaf_type->extendsOrEquals<hkReflect::IntType>() == false);
    HK_TEST(leaf_type->extendsOrEquals<Leaf>() );
    HK_TEST(leaf_type->extendsOrEquals<Root>() );

    HK_TEST(leaf_type->asRecord() == leaf_type);

    HK_TEST(leaf_type->asRecord() == leaf_type);
    HK_TEST(leaf_type->asInteger() == HK_NULL);
}

static void valueTests()
{
    /****************** Integer::get/setValue **********************/

    hkInt8 i8; hkReflect::IntVar vi8(&i8);
    hkInt16 i16; hkReflect::IntVar vi16(&i16);
    hkInt32 i32; hkReflect::IntVar vi32(&i32);
    hkInt64 i64; hkReflect::IntVar vi64(&i64);
    hkUint8 u8; hkReflect::IntVar vu8(&u8);
    hkUint16 u16; hkReflect::IntVar vu16(&u16);
    hkUint32 u32; hkReflect::IntVar vu32(&u32);
    hkUint64 u64; hkReflect::IntVar vu64(&u64);

    HK_TEST(vi8.setValue(0).isSuccess());
    HK_TEST(vi8.setValue(0x7f).isSuccess());
    HK_TEST(vi8.setValue(-0x80).isSuccess());
    HK_TEST(vi8.setValue(0x80).isFailure());
    HK_TEST(vi8.setValue(-0x81).isFailure());
    HK_TEST(vi16.setValue(0x7fff).isSuccess());
    HK_TEST(vi16.setValue(-0x8000).isSuccess());
    HK_TEST(vi16.setValue(0x8000).isFailure());
    HK_TEST(vi16.setValue(-0x8001).isFailure());
    HK_TEST(vi32.setValue(0x7fffffff).isSuccess());
    HK_TEST(vi32.setValue(-0x80000000LL).isSuccess());
    HK_TEST(vi32.setValue(0x80000000).isFailure());
    HK_TEST(vi32.setValue(-0x80000001LL).isFailure());
    HK_TEST(vi64.setValue(0x7fffffffffffffffLL).isSuccess());
    HK_TEST(vi64.setValue((signed long long)0x8000000000000000LL).isSuccess());
    HK_TEST(vi64.setValue(0x8000000000000000ULL).isFailure());
    HK_TEST(vu8.setValue(0xff).isSuccess());
    HK_TEST(vu8.setValue(0x100).isFailure());
    HK_TEST(vu8.setValue(-1).isFailure());
    HK_TEST(vu16.setValue(0xffff).isSuccess());
    HK_TEST(vu16.setValue(0x10000).isFailure());
    HK_TEST(vu16.setValue(-1).isFailure());
    HK_TEST(vu32.setValue(0xffffffff).isSuccess());
    HK_TEST(vu32.setValue(0x100000000).isFailure());
    HK_TEST(vu32.setValue(-1).isFailure());
    HK_TEST(vu64.setValue(0xffffffffffffffffULL).isSuccess());
    HK_TEST(vu64.setValue(-1).isFailure());

    char c; hkReflect::IntVar vc(&c);
    HK_TEST(vc.setValue(0xff).isSuccess());
    HK_TEST(vc.setValue(-0x80).isSuccess());
    HK_TEST(vc.setValue(0x100).isFailure());
    HK_TEST(vc.setValue(-0x81).isFailure());

    //****************** FloatingPoint::get/setValue **********************//

    float vFloat; hkReflect::FloatVar fpFloat(&vFloat);
    double vDouble; hkReflect::FloatVar fpDouble(&vDouble);

    volatile double zero = 0.0;
    HK_TEST(fpFloat.setValue(0.0f).isSuccess());
    HK_TEST(fpFloat.setValue(0.0).isSuccess());
    HK_TEST(fpFloat.setValue(3.4e38f).isSuccess());
    HK_TEST(fpFloat.setValue(3.5e38).isSuccess());
    HK_TEST(fpFloat.setValue(1.4e-46).isSuccess());
    HK_TEST(fpDouble.setValue(0.0).isSuccess());
    HK_TEST(fpDouble.setValue(3.4e38f).isSuccess());
    HK_TEST(fpDouble.setValue(3.5e38).isSuccess());
    HK_TEST(fpFloat.setValue(-1.0/zero).isSuccess());
    HK_TEST(fpFloat.setValue(zero/zero).isSuccess());

}

static hkUlong thunkTests()
{
    using namespace castTest;
    // we use 128 offset hack because a static_cast of 0 stays 0
    hkUlong d0 = hkUlong( static_cast<Interface0*>((WithInterfaces*)128) ) - 128;
    hkUlong d1 = hkUlong( static_cast<Interface1*>((WithInterfaces*)128) ) - 128;
    hkUlong d2 = hkUlong( static_cast<Interface2*>((WithInterfaces*)128) ) - 128;
    hkReflect::BypassCtorFlag f;
    WithInterfaces wi(f);
    Interface0* i0 = &wi;
    Interface1* i1 = &wi;
    Interface2* i2 = &wi;
    hkUlong e0 = hkUlong(i0) - hkUlong(&wi);
    hkUlong e1 = hkUlong(i1) - hkUlong(&wi);
    hkUlong e2 = hkUlong(i2) - hkUlong(&wi);

    const char* r0 = i0->func0();
    const char* r1 = i1->func1();
    const char* r2 = i2->func2();
    r0 = r1 = r2 = HK_NULL;
    return d0 + d1 + d2 + e0 + e1 + e2;
}

static void interfaceCasts()
{
    castTest::WithInterfaces obj;
    const hkReflect::Var baseVar(&obj);

    const hkReferencedObject* refObjPtr = &obj;
    const castTest::Interface0* iface0Ptr = &obj;
    const castTest::Interface1* iface1Ptr = &obj;
    const castTest::Interface2* iface2Ptr = &obj;
    const castTest::InterfaceBase* ifaceBasePtr = iface1Ptr;
    const castTest::InterfaceBase* ifaceBasePtr2 = iface0Ptr;
    const castTest::InterfaceOtherBase* ifaceOtherBasePtr = iface0Ptr;

    HK_TEST(refObjPtr == baseVar.castToInterface<hkReferencedObject>());
    HK_TEST(iface0Ptr == baseVar.castToInterface<castTest::Interface0>());
    HK_TEST(iface1Ptr == baseVar.castToInterface<castTest::Interface1>());
    HK_TEST(iface2Ptr == baseVar.castToInterface<castTest::Interface2>());
    HK_TEST(ifaceBasePtr == baseVar.castToInterface<castTest::InterfaceBase>());
    HK_TEST(ifaceOtherBasePtr == baseVar.castToInterface<castTest::InterfaceOtherBase>());

    hkArray<const hkReflect::Type*> interfaces;
    baseVar.getType()->getImplemented(interfaces);
    if (HK_TEST(interfaces.getSize() == 8))
    {
        HK_TEST(interfaces.indexOf(hkReflect::getType<castTest::WithInterfaces>()) >= 0);
        HK_TEST(interfaces.indexOf(hkReflect::getType<hkReferencedObject>()) >= 0);
        HK_TEST(interfaces.indexOf(hkReflect::getType<hkBaseObject>()) >= 0);
        HK_TEST(interfaces.indexOf(hkReflect::getType<castTest::Interface0>()) >= 0);
        HK_TEST(interfaces.indexOf(hkReflect::getType<castTest::Interface1>()) >= 0);
        HK_TEST(interfaces.indexOf(hkReflect::getType<castTest::Interface2>()) >= 0);
        HK_TEST(interfaces.indexOf(hkReflect::getType<castTest::InterfaceBase>()) >= 0);
        HK_TEST(interfaces.indexOf(hkReflect::getType<castTest::InterfaceOtherBase>()) >= 0);
    }

    const hkReflect::Type* interface0Type = hkReflect::getType<castTest::Interface0>();
    const hkReflect::Type* interface1Type = hkReflect::getType<castTest::Interface1>();
    const hkReflect::Type* interfaceBaseType = hkReflect::getType<castTest::InterfaceBase>();

    HK_TEST( hkReflect::Type::getCommonAncestor(interface0Type, interfaceBaseType) == interfaceBaseType);
    HK_TEST( hkReflect::Type::getCommonAncestor(interfaceBaseType, interface0Type) == interfaceBaseType);
    HK_TEST( hkReflect::Type::getCommonAncestor(interface0Type, interface1Type) == interfaceBaseType);
    HK_TEST( hkReflect::Type::getCommonAncestor(interface1Type, interface0Type) == interfaceBaseType);

    HK_TEST_EQ(hkDynCast<castTest::WithInterfaces>(refObjPtr), &obj);
    HK_TEST_EQ(hkDynCast<castTest::WithInterfaces>(iface0Ptr), &obj);
    HK_TEST_EQ(hkDynCast<castTest::WithInterfaces>(iface1Ptr), &obj);
    HK_TEST_EQ(hkDynCast<castTest::WithInterfaces>(iface2Ptr), &obj);
    HK_TEST_EQ(hkDynCast<castTest::WithInterfaces>(ifaceBasePtr), &obj);
    HK_TEST_EQ(hkDynCast<castTest::WithInterfaces>(ifaceBasePtr2), &obj);
    HK_TEST_EQ(hkDynCast<castTest::WithInterfaces>(ifaceOtherBasePtr), &obj);
}


int castTests_main()
{
    castTest::Leaf l;
    l.getExactType();

    castTests1();
    castTests2();
    interfaceCasts();

    valueTests();

    thunkTests();

    return 0;
}

HK_TEST_REGISTER(castTests_main, "Fast", "Common/Test/UnitTest/Base/", __FILE__);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
