// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

namespace VarTest
{
    class Bar : public hkReferencedObject
    {
    public:

        HK_DECLARE_CLASS(Bar, New, Reflect, BypassCtor);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

        Bar(int id) : m_id(id) { }


        int getId() const { return m_id; }
        bool setId(int id) { m_id = id; return true; }
        HK_PROPERTY(idProp, getId, setId);

        bool operator==(const Bar& rhs) const
        {
            return m_id == rhs.m_id;
        }

        int m_id;
    };

    struct Interface
    {
        HK_DECLARE_CLASS(Interface, New, ReflectVirtualBase);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
    };

    struct Implements : public hkReferencedObject, public Interface
    {
        HK_DECLARE_CLASS(Implements, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

        int m_i;
    };

    class Foo : public hkReferencedObject
    {
    public:

        HK_DECLARE_CLASS(Foo, New, Reflect, BypassCtor, Validate);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

        enum HK_ATTR(hk::ManualTypeRegistration) Things
        {
            NOTHING,
            SOMETHING,
            ANOTHER_THING
        };

        Foo(Bar* bar) : m_things(NOTHING), m_things2(SOMETHING), m_things3(42), m_things4(21), m_hidden(51), m_rawPtr(bar) { }
        Foo(const Foo& foo)
            : hkReferencedObject(), m_things(foo.m_things), m_things2(foo.m_things2), m_things3(foo.m_things3), m_things4(foo.m_things4),
            m_hidden(foo.m_hidden), m_rawPtr(foo.m_rawPtr)
        {
            m_intArray = foo.m_intArray;
        }

        virtual ~Foo() {}


        bool operator==(const Foo& rhs) const
        {
            const bool simpleFields =
                m_things == rhs.m_things &&
                m_things2 == rhs.m_things2 &&
                m_things3 == rhs.m_things3 &&
                m_things4 == rhs.m_things4 &&
                m_hidden == rhs.m_hidden &&
                m_intArray.getSize() == rhs.m_intArray.getSize();


            if(simpleFields && hkString::memCmp(m_intArray.begin(), rhs.m_intArray.begin(), m_intArray.getSize()) == 0)
            {
                const Bar* b = m_rawPtr;
                const Bar* rhsB = rhs.m_rawPtr;
                if(bool(b) ^ bool(rhsB))
                {
                    return false;
                }
                else if(b)
                {
                    return *b == *rhsB;
                }
                else
                {
                    return true;
                }
            }

            return false;
        }

        Things m_things;
        hkEnum<Things, hkUint8> m_things2;
        int m_things3 HK_ATTR( hk::Presets(strict=false, {NOTHING=0, SOMETHING=1, ANOTHER_THING=2}) );
        int m_things4 HK_ATTR( hk::AbsMin(0), hk::AbsMax(42) );
        int m_hidden HK_ATTR( hk::Ui_Hidden );

        hkArray<int> m_intArray;

        hkRefPtr<Bar> m_rawPtr;

        hkRefPtr<Bar> getPtr() const { return m_rawPtr; }
        HK_PROPERTY(property, getPtr);

        hkViewPtr<Interface> m_iface;
    };

    class CustomMethods
    {
    public:
        HK_DECLARE_CLASS(CustomMethods, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

        CustomMethods() : m_int(1) {}
        CustomMethods(const CustomMethods& rhs) : m_int(2 * rhs.m_int) {}

        void operator=(const CustomMethods& rhs) { m_int = 4 * rhs.m_int; }

        ~CustomMethods() { s_lastDeleted = reinterpret_cast<hkUlong>(this); }

        int m_int;
        static hkUlong s_lastDeleted;
    };

    class ImplicitMethods : public CustomMethods
    {
    public:
        HK_DECLARE_CLASS(ImplicitMethods, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

        void init()
        {
            m_i = 42;
            m_a.setSize(10, 42);
            m_s = "someString";
            m_x.m_int = 10;
            m_as.expandOne() = "someOtherString";
        }

        bool validate(bool assign) const
        {
            hkBool32 res = true;
            res &= m_i == 42;
            res &= m_a.getSize() == 10;
            for (int i = 0; i < m_a.getSize(); ++i)
            {
                res &= m_a[i] == 42;
            }
            res &= m_s == "someString";
            res &= (m_x.m_int == (assign ? 40 : 20));
            res &= hkDynCast<hkReferencedObject>(&m_b) != HK_NULL;
            res &= m_as.getSize() == 1;
            res &= m_as[0] == "someOtherString";
            return res;
        }

        int m_i;
        hkArray<int> m_a;
        CustomMethods m_x;
        hkReferencedObject m_b;
        hkStringPtr m_s;
        hkArray<hkStringPtr> m_as;
    };

    class NonReflectedField
    {
    public:
        HK_DECLARE_CLASS(NonReflectedField, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

        int m_i;
        hkStringPtr m_s HK_ATTR( hk::Reflect(false) );
    };

    class NonCopyable
    {
    public:
        HK_DECLARE_CLASS(NonCopyable, New, Reflect);
        HK_RECORD_ATTR(hk::Serialize(false), hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

        NonCopyable() {}

    protected:
        NonCopyable(const NonCopyable&) {}
        void operator=(const NonCopyable&) {}
    };

    class PodLike
    {
    public:
        HK_DECLARE_CLASS(PodLike, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

        bool operator==(const PodLike& rhs) const
        {
            bool res = m_float == rhs.m_float;
            for (hkUint16 i = 0; i < 10; ++i)
            {
                res = res && (m_array[i] == rhs.m_array[i]);
            }
            return res;
        }

        hkHandle<int, 0, PodLike> m_handle;
        hkReal m_float;
        hkUint16 m_array[10];
    };

    template <typename T>
    class TrivialTemplate
    {
    public:
        HK_DECLARE_CLASS(TrivialTemplate, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
        int m_int;
    };

    template <typename T>
    class NonTrivialTemplate
    {
    public:
        HK_DECLARE_CLASS(NonTrivialTemplate, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
        T m_t;
    };

    
#if 0
    struct MultiMap
    {
        HK_DECLARE_CLASS(MultiMap, New, Reflect, BypassCtor);
        HK_REFLECT_AS_CONTAINER(&VarTest::MultiMap::s_impl, VarTest::MultiMap::Pair);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
        MultiMap() {}

        void insert(const char* s, int i)
        {
            m_pairs.expandOne().set(s,i);
        }
        struct Pair
        {
            HK_DECLARE_CLASS(Pair, New, Reflect, BypassCtor);
            HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
            Pair() {}
            void set(const char*s, int i) { m_s =s; m_i=i;}
            bool operator==(const Pair&p) const { return m_i&&p.m_i && m_s==p.m_s; }
            hkStringPtr m_s;
            int m_i;
        };

        hkArray<Pair> m_pairs;
        struct ContainerImpl;
        static const ContainerImpl s_impl;
    };
#endif
    class RefPtrField
    {
    public:
        HK_DECLARE_CLASS(RefPtrField, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

        hkReferencedObject* m_ptr;
    };

    struct NoCopy
    {
    public:
        HK_DECLARE_CLASS(NoCopy, New, Reflect, BypassCtor);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
        NoCopy() {}
        hkRefPtr<hkReferencedObject> m_ptr;

    protected:
        NoCopy(const NoCopy&);
    };

    struct InPadding
    {
        HK_DECLARE_CLASS(InPadding, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

        InPadding() : m_data(0) {}
        void operator=(const InPadding& rhs);
        hkInt8 m_data;
    };

    struct WithPadding
    {
        HK_DECLARE_CLASS(WithPadding, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
        WithPadding() : m_i64(42), m_i8(42) {}
        hkInt64 m_i64;
        hkInt8 m_i8;
    };

    struct ReusePadding : public WithPadding
    {
        HK_DECLARE_CLASS(ReusePadding, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
        InPadding m_p;
    };

    struct Empty
    {
        HK_DECLARE_CLASS(Empty, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
        void operator=(const Empty&) {}
    };

    struct ReuseEmpty : public Empty
    {
        HK_DECLARE_CLASS(ReuseEmpty, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
        InPadding m_p;
    };
}

HK_REFLECT_ENUM(HK_EXPORT_COMMON, VarTest::Foo::Things);

#include <Common/Base/_Auto/TemplateTypes/VarTest_Types.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
