// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/UnitTest/Cloning/CloneTest.h>
#include <Common/Base/UnitTest/Reflection/VarTest.h>
#include <Common/Base/Container/StringMap/hkStringMap.h>
#include <Common/Base/Container/Array/hkVariantArray.h>
#include <Common/Base/Reflect/Core/Detail/hkReflectTypeDetail.h>
#include <Common/Base/Reflect/Util/hkReflectUtil.h>
#include <Common/Base/Reflect/Attributes/hkToolAttributes.h>
#include <Common/Base/Reflect/Util/hkVarCoerce.h>
#include <Common/Base/Reflect/Util/hkReflectAny.h>

#define HK_DETAIL_REFLECT_DEFINITIONS
#include "Common/Base/_Auto/Types/VarTest_Types.cxx"
#undef HK_DETAIL_REFLECT_DEFINITIONS

HK_MANUALLY_REGISTER_TYPE(VarTest::Bar, VarTest_Bar);
HK_MANUALLY_REGISTER_TYPE(VarTest::Interface, VarTest_Interface);
HK_MANUALLY_REGISTER_TYPE(VarTest::Implements, VarTest_Implements);
HK_MANUALLY_REGISTER_TYPE(VarTest::Foo, VarTest_Foo);
HK_MANUALLY_REGISTER_TYPE(VarTest::Foo::Things, VarTest_Foo_Things);
HK_MANUALLY_REGISTER_TYPE(VarTest::CustomMethods, VarTest_CustomMethods);
HK_MANUALLY_REGISTER_TYPE(VarTest::ImplicitMethods, VarTest_ImplicitMethods);
HK_MANUALLY_REGISTER_TYPE(VarTest::NonReflectedField, VarTest_NonReflectedField);
HK_MANUALLY_REGISTER_TYPE(VarTest::NonCopyable, VarTest_NonCopyable);
HK_MANUALLY_REGISTER_TYPE(VarTest::PodLike, VarTest_PodLike);
HK_MANUALLY_REGISTER_TYPE(VarTest::RefPtrField, VarTest_RefPtrField);
HK_MANUALLY_REGISTER_TYPE(VarTest::NoCopy, VarTest_NoCopy);
HK_MANUALLY_REGISTER_TYPE(VarTest::InPadding, VarTest_InPadding);
HK_MANUALLY_REGISTER_TYPE(VarTest::WithPadding, VarTest_WithPadding);
HK_MANUALLY_REGISTER_TYPE(VarTest::ReusePadding, VarTest_ReusePadding);
HK_MANUALLY_REGISTER_TYPE(VarTest::Empty, VarTest_Empty);
HK_MANUALLY_REGISTER_TYPE(VarTest::ReuseEmpty, VarTest_ReuseEmpty);


#if 0
struct VarTest::MultiMap::ContainerImpl : public hkReflect::Detail::ContainerImpl
{
    ContainerImpl() {}
    virtual hkReflect::ContainerValue getContainerValue(const void* conAddr, const hkReflect::ContainerType* conType) const HK_OVERRIDE
    {
        const VarTest::MultiMap* m = static_cast<const VarTest::MultiMap*>(conAddr);
        return hkReflect::ContainerValue( m->m_pairs.getSize(), conType->getSubType() );
    }

    hkReflect::VarIter find(const hkReflect::VarIter& prev, hkReflect::Var key) const
    {
        VarTest::MultiMap* m = static_cast<VarTest::MultiMap*>(prev.m_compound.getAddress());
        int startIdx = prev.isValid() ? int(prev.m_data+1) : 0;

        if( hkReflect::StringVar skey = key ) // find by key
        {
            hkStringPtr keyVal = (const char*)skey.getValue();
            for( int i = startIdx; i < m->m_pairs.getSize(); ++i )
            {
                if( m->m_pairs[i].m_s == keyVal )
                {
                    return hkReflect::VarIter(prev.m_compound, &m->m_pairs[i], i);
                }
            }
        }
        else if( hkReflect::RecordVar rkey = key ) // find by pair
        {
            if( const VarTest::MultiMap::Pair* elem = rkey.dynCast<VarTest::MultiMap::Pair>() )
            {
                for( int i = startIdx; i < m->m_pairs.getSize(); ++i )
                {
                    if( m->m_pairs[i] == *elem)
                    {
                        return hkReflect::VarIter(prev.m_compound, &m->m_pairs[i], i);
                    }
                }
            }
        }

        return hkReflect::VarIter();
    }

    virtual hkReflect::VarIter iterBegin(const void* comAddr, const hkReflect::CompoundType* comType) const HK_OVERRIDE
    {
        VarTest::MultiMap* m = (VarTest::MultiMap*)(comAddr);
        if( m->m_pairs.getSize() )
        {
            hkReflect::Var cv(comAddr, comType);
            return hkReflect::VarIter(cv, hkReflect::Var(&m->m_pairs[0]), 0);
        }
        return hkReflect::VarIter();
    }
    virtual void iterNext(hkReflect::VarIter& prev) const HK_OVERRIDE
    {
        VarTest::MultiMap* m = static_cast<VarTest::MultiMap*>(prev.m_compound.getAddress());
        if( prev.isValid() && static_cast<int>(prev.m_data+1) < m->m_pairs.getSize() )
        {
            prev.m_data += 1;
            prev.m_cur = hkReflect::Var(&m->m_pairs[int(prev.m_data)]);
            return;
        }
        prev.setInvalid();
    }

    bool insert(hkReflect::Var var, const hkReflect::VarIter& hint) const HK_OVERRIDE
    {
        HK_ASSERT_NO_MSG(0x4545d922, hint.m_compound.dynCast<VarTest::MultiMap>());
        const VarTest::MultiMap* m = reinterpret_cast<const VarTest::MultiMap*>(hint.m_compound.getAddress());
        if( const VarTest::MultiMap::Pair* e = var.dynCast<VarTest::MultiMap::Pair>() )
        {
            const_cast<VarTest::MultiMap*>(m)->m_pairs.expandOne() = *e;
            return true;
        }
        return false;
    }

    bool remove(const hkReflect::VarIter& iter) const HK_OVERRIDE
    {
        HK_ASSERT_NO_MSG(0x494367d8, iter.m_compound.dynCast<VarTest::MultiMap>());
        if( iter.isValid() )
        {
            VarTest::MultiMap* m = reinterpret_cast<VarTest::MultiMap*>(iter.m_compound.getAddress());
            m->m_pairs.removeAt( int(iter.m_data) );
            return true;
        }
        return false;
    }
};
const VarTest::MultiMap::ContainerImpl VarTest::MultiMap::s_impl;
#endif

namespace
{
#if defined(HK_BUILDING_WITH_ENGINE)

    template<typename FieldIterator>
    int test_FieldIteration(FieldIterator it, hkStringMap<bool>& fields)
    {
        fields.insert("hidden", false);
        fields.insert("things", false);
        fields.insert("things2", false);
        fields.insert("things3", false);
        fields.insert("things4", false);
        fields.insert("intArray", false);
        fields.insert("rawPtr", false);
        fields.insert("iface", false);
        fields.insert("property", false);
        fields.insert("memSizeAndFlags", false);
        fields.insert("refCount", false);
        fields.insert("propertyBag", false);
        int count = 0;
        while(it.advance())
        {
            hkReflect::FieldDecl field = it.current();
            hkStringMap<bool>::Iterator f = fields.findKey(field.getName());
            HK_TEST(fields.isValid(f));
            if(fields.isValid(f))
            {
                HK_TEST(!fields.getValue(f));
                fields.setValue(f, true);
            }

            ++count;
        }
        return count;
    }

    HK_INLINE bool isNotHiddenFilter(const hkReflect::FieldDecl& field)
    {
        {
            if(!field.isPublic())
            {
                return false;
            }

            // We hide non-serializable fields that aren't properties
            if( !field.isSerializable() && !field.asPropertyField() )
            {
                return false;
            }
        }
        const hkReflect::Type* type = field.getType();
        // We also hide explicitly hidden fields and ones with incomplete type.
        const hk::Ui_Hidden *const hidden =  type->findAttribute<hk::Ui_Hidden>();
        return (!hidden || !hidden->m_value) && !type->asOpaque();
    }
#endif

    void test_RecordVar()
    {
        VarTest::Bar bar1(1);
        VarTest::Bar bar2(2);
        VarTest::Foo foo(&bar1);

        hkReflect::Var barVar(&bar1, hkReflect::getType<VarTest::Bar>());
        hkReflect::Var fooVar(&foo, hkReflect::getType<VarTest::Foo>());

        hkReflect::RecordVar recVar = fooVar;
        if(HK_TEST(recVar))
        {
            // Test if random access to fields by name works
            hkReflect::Var thingsVar_fromString = recVar["things"];

            HK_TEST(thingsVar_fromString);

            HK_TEST(recVar["things2"]);
            HK_TEST(recVar["things3"]);
            HK_TEST(recVar["things4"]);
            HK_TEST(!recVar["FieldThatDoesntExist"]);

            // Access should also work via member pointer
            hkReflect::Var thingsVar_fromMemberPointer = hkReflect::Var::fromField(&foo, &VarTest::Foo::m_things);
            HK_TEST(thingsVar_fromMemberPointer);
            HK_TEST(thingsVar_fromString.getAddress() == thingsVar_fromMemberPointer.getAddress());
            HK_TEST(thingsVar_fromString.getType() == thingsVar_fromMemberPointer.getType());

#if defined(HK_BUILDING_WITH_ENGINE)
            // Test iterating over all the fields
            {
                hkStringMap<bool> fields;
                hkReflect::DeclIter<hkReflect::FieldDecl> it(recVar.getType());
                int count = test_FieldIteration(it, fields);
                HK_TEST(count == fields.getSize());
                // hidden fields shouldn't be hidden with the record iterator
                HK_TEST(fields.getValue(fields.findKey("hidden")) == true);
            }

            // Test iterating over all the non-hidden fields
            {
                hkStringMap<bool> fields;
                hkReflect::FilteredDeclIter<hkReflect::FieldDecl> it(recVar.getType(), isNotHiddenFilter);
                int count = test_FieldIteration(it, fields);
                HK_TEST(count == fields.getSize() - 4); // 3 hidden fields in hkReferencedObject, one from the test
                // hidden fields shouldn't show up during iteration
                HK_TEST(fields.getValue(fields.findKey("hidden")) == false);
            }

            // Test to iterate on the array field
            {
                hkReflect::ArrayVar a = recVar["intArray"];
                if(HK_TEST(a.isValid()))
                {
                    // Using iterators
                    hkInt64 count = 0;
                    hkReflect::ArrayValue aval = a.getValue();
                    for(int i = 0; i < aval.getCount(); ++i )
                    {
                        hkReflect::IntVar cur = aval[i];
                        if(HK_TEST(cur.isValid()))
                        {
                            HK_TEST(cur.getValue().convertTo<hkInt64>() == count++);
                        }
                    }

                    // Using random access
                    for(int i = 0; i < a.getCount(); ++i)
                    {
                        hkReflect::IntVar cur = a[i];
                        if(HK_TEST(cur.isValid()))
                        {
                            HK_TEST(cur.getValue().convertTo<hkInt64>() == i);
                        }
                    }

                    // Check if setValue works on array elements
                    for(int i = 0; i < a.getCount(); ++i)
                    {
                        hkReflect::IntVar cur = a[i];
                        if(HK_TEST(cur.isValid()))
                        {
                            cur.setValue(i + 1);
                            HK_TEST(cur.getValue().convertTo<hkInt64>() == i + 1);
                        }
                    }

                    for(int i = 0; i < a.getCount(); ++i)
                    {
                        hkReflect::IntVar cur = a[i];
                        if(HK_TEST(cur.isValid()))
                        {
                            HK_TEST(cur.getValue().convertTo<hkInt64>() == i + 1);
                        }
                    }
                }
            }
#endif
            // Test presets
            const char* fieldsWithPresets[] = { "things", "things2", "things3" };
            const char* presetNames[] = { "NOTHING", "SOMETHING", "ANOTHER_THING" };
            for(int fieldIdx = 0; fieldIdx < sizeof(fieldsWithPresets)/sizeof(fieldsWithPresets[0]); ++fieldIdx)
            {
                if(hkReflect::Var field = recVar[fieldsWithPresets[fieldIdx]])
                {
                    const hk::Presets* presets = field.getType()->findAttribute<hk::Presets>();
                    if(HK_TEST(presets))
                    {
                        HK_TEST(presets->m_numPresets == 3);
                        if( fieldIdx<2 )/*things2 is an int*/ HK_TEST(presets->m_valueType->extendsOrEquals<VarTest::Foo::Things>());
                        for(int presetIdx = 0; presetIdx < presets->m_numPresets; ++presetIdx)
                        {
                            hkReflect::IntVar p = presets->getPreset(presetIdx);
                            if(HK_TEST(p.isValid()))
                            {
                                hkStringBuf buf;
                                HK_TEST(hkString::strCmp(presets->getPresetName(presetIdx), presetNames[presetIdx]) == 0);
                                HK_TEST(p.getValue().convertTo<int>() == presetIdx);
                            }
                        }
                    }
                }
            }

            // Test AbsMin and AbsMax attributes
            if(hkReflect::Var field = recVar["things4"]) // things4 has a min and max
            {
                const hk::AbsMin* absMinAttr = field.getType()->findAttribute<hk::AbsMin>();
                const hk::AbsMax* absMaxAttr = field.getType()->findAttribute<hk::AbsMax>();
                if(HK_TEST(absMinAttr) && HK_TEST(absMaxAttr))
                {
                    hkReflect::Var absMinVar = absMinAttr->get(field.getType());
                    hkReflect::Var absMaxVar = absMaxAttr->get(field.getType());
                    if(HK_TEST(absMinVar) && HK_TEST(absMaxVar))
                    {
                        hkReflect::IntVar absMin = absMinVar;
                        hkReflect::IntVar absMax = absMaxVar;
                        HK_TEST(absMin.getValue().convertTo<int>() == 0);
                        HK_TEST(absMax.getValue().convertTo<int>() == 42);
                    }
                }
            }
            if(hkReflect::Var field = recVar["things3"]) // things3 has neither of them
            {
                HK_TEST(field.getType()->findAttribute<hk::AbsMin>() == HK_NULL);
                HK_TEST(field.getType()->findAttribute<hk::AbsMax>() == HK_NULL);
            }

            // Check that pointer fields work (read, assign, ...)
            hkReflect::PointerVar ptr = recVar["rawPtr"];
            if(HK_TEST(ptr.isValid()))
            {
                // Test reading the record through the pointer
                {
                    hkReflect::RecordVar rec = ptr.getValue();
                    if(HK_TEST(rec.isValid()))
                    {
                        hkReflect::IntVar id = rec["id"];
                        if(HK_TEST(id.isValid()))
                        {
                            HK_TEST(id.getValue().convertTo<int>() == 1);

                            // Compare the field value to the property
                            hkReflect::IntVar idProp = rec["idProp"];
                            if(HK_TEST(idProp.isValid()))
                            {
                                HK_TEST(id.getValue().convertTo<int>() == idProp.getValue().convertTo<int>());
                            }
                        }
                    }
                }

                // Set the pointer to point to bar2
                ptr.setValue(&bar2);

                // Check that we know see bar2 when dereferencing the pointer
                {
                    hkReflect::RecordVar rec = ptr.getValue();
                    if(HK_TEST(rec.isValid()))
                    {
                        hkReflect::IntVar id = rec["id"];
                        if(HK_TEST(id.isValid()))
                        {
                            HK_TEST(id.getValue().convertTo<int>() == bar2.m_id);

                            // Compare the field value to the property
                            hkReflect::IntVar idProp = rec["idProp"];
                            if(HK_TEST(idProp.isValid()))
                            {
                                HK_TEST(id.getValue().convertTo<int>() == idProp.getValue().convertTo<int>());
                            }
                        }
                    }
                }

                // Create another PointerVar...
                hkRefPtr<VarTest::Bar> pbar(hkRefNew<VarTest::Bar>(new VarTest::Bar(3)));
                hkReflect::PointerVar pvar((void*)&pbar, hkReflect::getType< hkRefPtr<VarTest::Bar> >()->asPointer());

                /// ...and replace ptr with it
                ptr.copyFrom(pvar);

                // Check that we now see the new pointer
                {
                    hkReflect::RecordVar rec = ptr.getValue();
                    if(HK_TEST(rec.isValid()))
                    {
                        hkReflect::IntVar id = rec["id"];
                        if(HK_TEST(id.isValid()))
                        {
                            HK_TEST(id.getValue().convertTo<int>() == pbar->m_id);

                            // Compare the field value to the property
                            hkReflect::IntVar idProp = rec["idProp"];
                            if(HK_TEST(idProp.isValid()))
                            {
                                HK_TEST(id.getValue().convertTo<int>() == idProp.getValue().convertTo<int>());
                            }
                        }
                    }
                }
            }

            // Get and set an interface pointer.
            hkReflect::PointerVar iPtr = recVar[&VarTest::Foo::m_iface];
            VarTest::Implements implObj;

            // This will not work.
            //iPtr.setValue(&implObj);
            foo.m_iface = &implObj;

            VarTest::Interface* asIface = static_cast<VarTest::Interface*>(&implObj);
            HK_TEST((void*)asIface != (void*)&implObj);

            hkReflect::Var ptd = iPtr.getValue();
            HK_TEST(ptd.getType()->equals<VarTest::Implements>());
            HK_TEST(hkDynCast<VarTest::Implements>(ptd) == &implObj);
        }
    }

    template <typename T>
    T* getTypedBuffer(hkArray<hkUint8>& buf)
    {
        buf.setSize(sizeof(T), 0xff);
        return reinterpret_cast<T*>(buf.begin());
    }

    void testCustomMethods(hkReflect::Var var, VarTest::CustomMethods* cm, const void* rhs)
    {
        hkResult res;

        res = hkReflect::TypeDetail::defaultConstruct(var.getAddress(), var.getType());
        HK_TEST(res.isSuccess());
        HK_TEST(cm->m_int == 1);

        res = hkReflect::TypeDetail::copyConstruct(var.getAddress(), rhs, var.getType());
        HK_TEST(res.isSuccess());
        HK_TEST(cm->m_int == 20);

        res = hkReflect::TypeDetail::copyAssign(var.getAddress(), rhs, var.getType());
        HK_TEST(res.isSuccess());
        HK_TEST(cm->m_int == 40);

        var.destroy(hkReflect::Var::FLAG_DESTRUCT);
    }

    void test_specialMethods()
    {
        hkArray<hkUint8> buffer;

        {
            VarTest::CustomMethods* obj = getTypedBuffer<VarTest::CustomMethods>(buffer);
            VarTest::CustomMethods rhs;
            rhs.m_int = 10;
            testCustomMethods(obj, obj, &rhs);
        }

        {
            VarTest::ImplicitMethods* obj = getTypedBuffer<VarTest::ImplicitMethods>(buffer);
            VarTest::ImplicitMethods rhs;
            rhs.m_int = 10;
            rhs.m_x.m_int = 10;
            testCustomMethods(obj, obj, &rhs);
            testCustomMethods(obj, &obj->m_x, &rhs);
        }

        {
            VarTest::ImplicitMethods (&arr)[3] = *getTypedBuffer<VarTest::ImplicitMethods[3]>(buffer);
            hkReflect::Var var(&arr);
            hkResult res;

            const hkReflect::Type* type = hkReflect::getType<VarTest::ImplicitMethods>();
            HK_TEST(hkReflect::TypeDetail::getDefaultConstructionFunction(type) == &hkReflect::Detail::Implicit<hkReflect::Opt::DEF_CONSTRUCTOR>::func);
            HK_TEST(hkReflect::TypeDetail::getCopyConstructionFunction(type) == &hkReflect::Detail::Implicit<hkReflect::Opt::COPY_CONSTRUCTOR>::func);
            HK_TEST(hkReflect::TypeDetail::getCopyAssignmentFunction(type) == &hkReflect::Detail::Implicit<hkReflect::Opt::COPY_ASSIGNMENT>::func);
            HK_TEST(hkReflect::TypeDetail::getDestructionFunction(type) == &hkReflect::Detail::Implicit<hkReflect::Opt::DESTRUCTOR>::func);

            res = hkReflect::TypeDetail::defaultConstruct(var.getAddress(), var.getType());
            HK_TEST(res.isSuccess());
            for (int i = 0; i < 3; ++i)
            {
                HK_TEST(arr[i].m_a.getCapacity() == 0);
                HK_TEST(hkDynCast<hkReferencedObject>(&arr[i].m_b));
            }

            VarTest::ImplicitMethods rhs[3];
            for (int i = 0; i < 3; ++i)
            {
                rhs[i].init();
            }

            res = hkReflect::TypeDetail::copyAssign(var.getAddress(), &rhs, var.getType());
            HK_TEST(res.isSuccess());

            for (int i = 0; i < 3; ++i)
            {
                HK_TEST(arr[i].validate(true));
            }

            var.destroy(hkReflect::Var::FLAG_DESTRUCT);
            res = hkReflect::TypeDetail::copyConstruct(var.getAddress(), &rhs, var.getType());
            HK_TEST(res.isSuccess());

            for (int i = 0; i < 3; ++i)
            {
                HK_TEST(arr[i].validate(false));
            }
            var.destroy(hkReflect::Var::FLAG_DESTRUCT);
        }

        {
            VarTest::NonReflectedField* obj = getTypedBuffer<VarTest::NonReflectedField>(buffer);
            hkReflect::Var var(obj);

            hkResult res;

            res = hkReflect::TypeDetail::defaultConstruct(var.getAddress(), var.getType());
            HK_TEST(res.isSuccess());
            HK_TEST(obj->m_s == HK_NULL);

            VarTest::NonReflectedField rhs;
            rhs.m_i = 10;
            rhs.m_s = "test";
            res = hkReflect::TypeDetail::copyAssign(var.getAddress(), &rhs, var.getType());
            HK_TEST(res.isSuccess());
            HK_TEST_EQ(obj->m_i, rhs.m_i);
            HK_TEST_EQ(obj->m_s, rhs.m_s);
            HK_TEST(obj->m_s.cString() != rhs.m_s.cString());

            var.destroy(hkReflect::Var::FLAG_DESTRUCT);

            res = hkReflect::TypeDetail::copyConstruct(var.getAddress(), &rhs, var.getType());
            HK_TEST(res.isSuccess());
            HK_TEST_EQ(obj->m_i, rhs.m_i);
            HK_TEST_EQ(obj->m_s, rhs.m_s);
            HK_TEST(obj->m_s.cString() != rhs.m_s.cString());

            var.destroy(hkReflect::Var::FLAG_DESTRUCT);
        }

        {
            VarTest::NonCopyable* obj = getTypedBuffer<VarTest::NonCopyable>(buffer);
            hkReflect::Var var(obj);

            hkResult res;

            res = hkReflect::TypeDetail::copyConstruct(HK_NULL, HK_NULL, var.getType());
            HK_TEST(!res.isSuccess());

            res = hkReflect::TypeDetail::copyAssign(HK_NULL, HK_NULL, var.getType());
            HK_TEST(!res.isSuccess());
        }

        // Vars of different sizes can (and should!) still be equal
        {
            // int
            {
                char v0 = 10;
                hkUint64 v1 = 10;
                hkReflect::IntVar iv0 = hkReflect::Var(&v0);
                hkReflect::IntVar iv1 = hkReflect::Var(&v1);
                HK_TEST( iv0.getType()->equals(iv1.getType()) == false );
                HK_TEST( iv0.equals(iv1) );
            }

            // float
            {
                float v0 = 10.1f;
                double v1 = 10.1f; //round to float
                hkReflect::FloatVar fv0 = hkReflect::Var(&v0);
                hkReflect::FloatVar fv1 = hkReflect::Var(&v1);
                HK_TEST( fv0.getType()->equals(fv1.getType()) == false );
                HK_TEST( fv0.equals(fv1) );
            }

            // arrays same
            {
                char a0[] = { 1,2,3,4,5 };
                int  a1[] = { 1,2,3,4,5 };

                hkReflect::ArrayVar av0 = hkReflect::Var(a0);
                hkReflect::ArrayVar av1 = hkReflect::Var(a1);
                HK_TEST( av0.equals(av1) );
            }
        }

        // Container Type
        {
            int a0[] = { 00,10,20,30,40,50 };
            hkReflect::CompoundVar cv = hkReflect::Var(&a0);
            int idx = 0;
            for( hkReflect::VarIter it = cv.begin(); it; ++it, ++idx )
            {
                hkReflect::IntVar curi = *it;
                hkReflect::IntValue iv = curi.getValue();
                HK_TEST( iv.equals(idx*10) );
            }
            HK_TEST(idx == HK_COUNT_OF(a0));
        }

        if(1)
        {
            VarTest::PodLike* obj = getTypedBuffer<VarTest::PodLike>(buffer);
            hkReflect::Var var(obj);

            hkResult res;

            obj->m_float = 42.0f;
            for (hkUint16 i = 0; i < 10; ++i)
            {
                obj->m_array[i] = i;
            }
            res = hkReflect::TypeDetail::defaultConstruct(obj, var.getType());
            HK_TEST(res.isSuccess());
            HK_TEST(obj->m_float == 0.0f);
            for (int i = 0; i < 10; ++i)
            {
                HK_TEST(obj->m_array[i] == 0.0f);
            }

            VarTest::PodLike rhs;
            rhs.m_float = 1000.0f;
            for (hkUint16 i = 0; i < 10; ++i)
            {
                rhs.m_array[i] = i*10;
            }
            res = hkReflect::TypeDetail::copyConstruct(obj, &rhs, var.getType());
            HK_TEST(res.isSuccess());
            HK_TEST(*obj == rhs);

            hkReflect::TypeDetail::defaultConstruct(obj, var.getType());
            res = hkReflect::TypeDetail::copyAssign(obj, &rhs, var.getType());
            HK_TEST(res.isSuccess());
            HK_TEST(*obj == rhs);
        }

        {
            const hkReflect::Type* type = hkReflect::getType< VarTest::TrivialTemplate<int> >();
            HK_TEST(hkReflect::TypeDetail::getDefaultConstructionFunction(type));
            HK_TEST(hkReflect::TypeDetail::getCopyConstructionFunction(type));
            HK_TEST(hkReflect::TypeDetail::getCopyAssignmentFunction(type));
        }

        {
            const hkReflect::Type* type = hkReflect::getType< VarTest::NonTrivialTemplate<int> >();
            HK_TEST(hkReflect::TypeDetail::getDefaultConstructionFunction(type));
            HK_TEST(hkReflect::TypeDetail::getCopyConstructionFunction(type));
            HK_TEST(hkReflect::TypeDetail::getCopyAssignmentFunction(type));
        }

        {
            hkReal realArray[6];
            const hkReflect::Type* type = hkReflect::getType<hkReal[6]>();

            hkReflect::TypeDetail::defaultConstruct(&realArray, type);
            for (int i = 0; i < 6; ++i)
            {
                HK_TEST_EQ(realArray[i], hkReal(0.0f));
            }

            hkReal rhs[6] = { 0, 1, 2, 3, 4, 5 };
            hkReflect::TypeDetail::copyAssign(&realArray, &rhs, type);
            for (int i = 0; i < 6; ++i)
            {
                HK_TEST_EQ(realArray[i], rhs[i]);
            }

            hkReflect::TypeDetail::destruct(&realArray, type);
            hkReflect::TypeDetail::copyConstruct(&realArray, &rhs, type);
            for (int i = 0; i < 6; ++i)
            {
                HK_TEST_EQ(realArray[i], rhs[i]);
            }
        }

        {
            VarTest::CustomMethods objArray[10];
            hkReflect::Var var(&objArray);

            hkMemUtil::memSet(objArray, 0, sizeof(VarTest::CustomMethods[10]));

            hkReflect::TypeDetail::defaultConstruct(&objArray, var.getType());
            for (int i = 0; i < 10; ++i)
            {
                HK_TEST(objArray[i].m_int == 1);
            }

            VarTest::CustomMethods rhs[10];
            for (int i = 0; i < 10; ++i)
            {
                rhs[i].m_int = i;
            }

            hkReflect::TypeDetail::copyAssign(&objArray, &rhs, var.getType());
            for (int i = 0; i < 10; ++i)
            {
                HK_TEST_EQ(objArray[i].m_int, rhs[i].m_int * 4);
            }

            var.destroy(hkReflect::Var::FLAG_DESTRUCT);
            HK_TEST_EQ(VarTest::CustomMethods::s_lastDeleted, reinterpret_cast<hkUlong>(&objArray[0]));

            hkReflect::TypeDetail::copyConstruct(&objArray, &rhs, var.getType());
            for (int i = 0; i < 10; ++i)
            {
                HK_TEST_EQ(objArray[i].m_int, rhs[i].m_int * 2);
            }
        }

        {
            const hkReflect::Type* type = hkReflect::getType<VarTest::NonCopyable[10]>();
            HK_TEST(hkReflect::TypeDetail::getDefaultConstructionFunction(type) != HK_NULL);
            HK_TEST(hkReflect::TypeDetail::getCopyConstructionFunction(type) == HK_NULL);
            HK_TEST(hkReflect::TypeDetail::getCopyAssignmentFunction(type) == HK_NULL);
        }

        {
            VarTest::RefPtrField obj;
            hkReferencedObject target1;
            hkReferencedObject target2;

            hkReflect::RecordVar objVar(&obj);
            hkReflect::PointerVar ptrField = objVar["ptr"];

            hkReflect::TypeDetail::defaultConstruct(ptrField.getAddress(), ptrField.getType());
            HK_TEST(obj.m_ptr == HK_NULL);

            hkReferencedObject* otherPtr = &target1;
            hkReflect::TypeDetail::copyConstruct(ptrField.getAddress(), &otherPtr, ptrField.getType());
            HK_TEST(obj.m_ptr == otherPtr);
            HK_TEST(target1.getReferenceCount() == 2);

            otherPtr = &target2;
            hkReflect::TypeDetail::copyAssign(ptrField.getAddress(), &otherPtr, ptrField.getType());
            HK_TEST(obj.m_ptr == otherPtr);
            HK_TEST(target1.getReferenceCount() == 1);
            HK_TEST(target2.getReferenceCount() == 2);

            ptrField.destroy(hkReflect::Var::FLAG_DESTRUCT);
            HK_TEST(target1.getReferenceCount() == 1);
        }

        {
            VarTest::ReusePadding obj;
            VarTest::ReusePadding rhs;
            hkString::memSet(&rhs, 0xff, sizeof(VarTest::ReusePadding));

            hkReflect::TypeDetail::copyAssign(&obj, &rhs, hkReflect::getType<VarTest::ReusePadding>());
            HK_TEST_EQ(obj.m_i64, rhs.m_i64);
            HK_TEST_EQ(obj.m_i8, rhs.m_i8);
            HK_TEST_EQ(obj.m_p.m_data, rhs.m_p.m_data);
        }

        {
            VarTest::ReuseEmpty obj;
            VarTest::ReuseEmpty rhs;
            hkString::memSet(&rhs, 0xff, sizeof(VarTest::ReuseEmpty));

            hkReflect::TypeDetail::copyAssign(&obj, &rhs, hkReflect::getType<VarTest::ReuseEmpty>());
            HK_TEST_EQ(obj.m_p.m_data, rhs.m_p.m_data);
        }
    }

    void test_ArrayVar()
    {
        {
            int intArray[5];
            hkReflect::Var var(&intArray);
            hkReflect::ArrayVar arrayVar = var;

            for (int i = 0; i < 5; ++i)
            {
                intArray[i] = i;
            }

            int intArray2[3];
            for (int i = 0; i < 3; ++i)
            {
                intArray2[i] = i;
            }
            HK_TEST(arrayVar.spliceInto(1, 3, hkReflect::ArrayValue(intArray2, 3)).isSuccess());

            HK_TEST(intArray[0] == 0);
            HK_TEST(intArray[4] == 4);
            for (int i = 0; i < 3; ++i)
            {
                HK_TEST(intArray[i+1] == intArray2[i]);
            }
        }

        {
            VarTest::CustomMethods objArray[5];
            hkReflect::Var var(&objArray);
            hkReflect::ArrayVar arrayVar = var;

            for (int i = 0; i < 5; ++i)
            {
                objArray[i].m_int = 10 + i;
            }

            VarTest::CustomMethods objArray2[3];
            for (int i = 0; i < 3; ++i)
            {
                objArray2[i].m_int = i;
            }
            HK_TEST(arrayVar.spliceInto(2, 3, hkReflect::ArrayValue(objArray2, 3)).isSuccess());

            HK_TEST(objArray[0].m_int == 10);
            HK_TEST(objArray[1].m_int == 11);
            for (int i = 0; i < 3; ++i)
            {
                HK_TEST(objArray[i+2].m_int == 2 * objArray2[i].m_int);
            }
        }

        {
            hkArray<int> intArray(5);
            hkReflect::Var var(&intArray);
            hkReflect::ArrayVar arrayVar = var;

            for (int i = 0; i < 5; ++i)
            {
                intArray[i] = i;
            }

            int intArray2[3];
            for (int i = 0; i < 3; ++i)
            {
                intArray2[i] = i;
            }
            HK_TEST(arrayVar.spliceInto(1, 2, hkReflect::ArrayValue(intArray2, 3)).isSuccess());

            HK_TEST(intArray.getSize() == 6);
            HK_TEST(intArray[0] == 0);
            for (int i = 0; i < 3; ++i)
            {
                HK_TEST(intArray[i+1] == intArray2[i]);
            }
            HK_TEST(intArray[4] == 3);
            HK_TEST(intArray[5] == 4);
        }

        {
            hkArray<VarTest::CustomMethods> objArray(5);
            hkReflect::Var var(&objArray);
            hkReflect::ArrayVar arrayVar = var;

            for (int i = 0; i < 5; ++i)
            {
                objArray[i].m_int = 10;
            }

            VarTest::CustomMethods objArray2[3];
            for (int i = 0; i < 3; ++i)
            {
                objArray2[i].m_int = i;
            }
            HK_TEST(arrayVar.spliceInto(0, 2, hkReflect::ArrayValue(objArray2, 3)).isSuccess());

            HK_TEST(objArray.getSize() == 6);
            for (int i = 0; i < 3; ++i)
            {
                HK_TEST(objArray[i].m_int == 2 * objArray2[i].m_int);
            }
            HK_TEST(objArray[3].m_int == 10);
            HK_TEST(objArray[4].m_int == 10);
            HK_TEST(objArray[5].m_int == 10);
        }

        {
            hkInplaceArray<int, 6> intArray(5);
            hkReflect::Var var(&intArray);
            hkReflect::ArrayVar arrayVar = var;

            for (int i = 0; i < 5; ++i)
            {
                intArray[i] = i;
            }

            int intArray2[3];
            for (int i = 0; i < 3; ++i)
            {
                intArray2[i] = i;
            }
            HK_TEST(arrayVar.spliceInto(1, 2, hkReflect::ArrayValue(intArray2, 3)).isSuccess());
            HK_TEST(arrayVar.removeAt(5).isSuccess());

            HK_TEST(intArray.getSize() == 5);
            HK_TEST(!intArray.wasReallocated());
            HK_TEST(intArray[0] == 0);
            for (int i = 0; i < 3; ++i)
            {
                HK_TEST(intArray[i + 1] == intArray2[i]);
            }
            HK_TEST(intArray[4] == 3);
        }

        {
            hkInplaceArray<VarTest::CustomMethods, 6> objArray(5);
            hkReflect::Var var(&objArray);
            hkReflect::ArrayVar arrayVar = var;

            for (int i = 0; i < 5; ++i)
            {
                objArray[i].m_int = 10;
            }

            VarTest::CustomMethods objArray2[3];
            for (int i = 0; i < 3; ++i)
            {
                objArray2[i].m_int = i;
            }
            HK_TEST(arrayVar.spliceInto(0, 2, hkReflect::ArrayValue(objArray2, 3)).isSuccess());

            HK_TEST(objArray.getSize() == 6);
            HK_TEST(!objArray.wasReallocated());
            for (int i = 0; i < 3; ++i)
            {
                HK_TEST(objArray[i].m_int == 2 * objArray2[i].m_int);
            }
            HK_TEST(objArray[3].m_int == 10);
            HK_TEST(objArray[4].m_int == 10);
            HK_TEST(objArray[5].m_int == 10);
        }
    }

    void test_CompoundVar()
    {
        using namespace hkReflect;
        {
            
#if 0
            VarTest::MultiMap mm;
            mm.insert("ten", 10);
            mm.insert("one", 1);
            mm.insert("one", -1);
            mm.insert("six", 6);

            Var vmm(&mm);
            if( ContainerVar c = vmm ) 
            {
                // check that find works
                {
                    hkStringPtr one = "one";
                    VarIter firstOne = c.find( &one);
                    //IntVar iv0 = *firstOne;
                    HK_TEST(*firstOne);
                    //if( iv0 ) { HK_TEST( iv0.get().equals(1) ); }
                    VarIter secondOne = c.find(&one, firstOne);
                    //IntVar iv1 = *secondOne;
                    HK_TEST(*secondOne);
                    HK_TEST(secondOne.m_cur.getAddress() != firstOne.m_cur.getAddress());
                    //if( iv1 ) { HK_TEST( iv1.get().equals(-1) ); }
                }
                // check the sizes match
                {
                    int nelem = 0;
                    for( VarIter cur=c.begin(), end=c.end(); cur!=end; ++cur )
                    {
                        nelem += 1;
                    }
                    HK_TEST( nelem == c.getCount() );
                    HK_TEST( nelem == mm.m_pairs.getSize() );
                }
            }
            if( ContainerVar c = vmm )
            {
                //c.insert
                //c.remove
            }
#endif
        }
        //arrays are containers too
        {
            hkArray<int> arr;
            const int values[] = { 101, 99, 102, 98, 103 };
            arr.insertAt(0, values, HK_COUNT_OF(values));

            Var varr(&arr);

            if( ContainerVar c = varr )
            {
                HK_TEST( c.getSubType()->equals(hkReflect::getType<int>()) );
                int nelem = 0;
                for( VarIter cur=c.begin(), end=c.end(); cur!=end; ++cur )
                {
                    nelem += 1;
                }
                HK_TEST( nelem == c.getCount() );
                HK_TEST( nelem == arr.getSize() );
            }
        }

        // Records are compounds (but not containers)
        {
            VarTest::Bar bar(10);
            VarTest::Foo foo(&bar);
            CompoundVar rvar(&foo);
            hkStringPtr thing3("things3");
            HK_TEST( rvar.find( &thing3) );
            hkStringPtr member_doesnt_exist("member_doesnt_exist");
            HK_TEST( !rvar.find( &member_doesnt_exist) );

            int numElem = 0;
            for( VarIter cur=rvar.begin(), end=rvar.end(); cur!=end; ++cur )
            {
                Var v = *cur;
                //HK_TEST( v.isField() )
                numElem += 1;
            }
            int expected = hkReflectUtil::getRecordNumFieldsWithAncestors(getType<VarTest::Foo>()->asRecord());
            HK_TEST( numElem == expected );
        }
    }

    void test_VarOfVar()
    {
        VarTest::Bar bar(10);

        hkReflect::Var var(&bar);

        do
        {
            hkReflect::Var varOfVar(&var);
            hkReflect::PointerVar pv = varOfVar;

            if(!HK_TEST(pv)) break;
            if(!HK_TEST(pv.dynCast<hkReflect::Var>())) break;

            hkReflect::Var v = pv.getValue();
            if(!HK_TEST(v)) break;

            hkReflect::RecordVar rv = v;
            if(!HK_TEST(rv)) break;

            HK_TEST(rv.getAddress() == var.getAddress());

        } while(0);
    }

        // Test that calling "convert" on the "srcvar" is equal to "result"
        // If worked==false, the output is not checked because the conversion is assumed to have failed.
    template<typename RESULT, typename DSTVAR, typename SRCVAR>
    static void coerceTest( RESULT result, bool (*convert)(DSTVAR&, const SRCVAR&), const SRCVAR& srcvar, bool worked=true )
    {
        RESULT tmp = 0;
        DSTVAR dstvar(&tmp);

        if( HK_TEST( (*convert)(dstvar, srcvar) == worked ) && worked )
        {
            HK_TEST(tmp == result);
        }
    }

    template<typename RESULT>
    static void coerceTest2( hkReflect::VarCoerce& coerce, RESULT result, const hkReflect::Var& srcvar, bool worked=true )
    {
        RESULT tmp = 0;
        hkReflect::Var dstvar(&tmp);

        if( HK_TEST( coerce.copy(dstvar, srcvar) == worked ) && worked )
        {
            HK_TEST(tmp == result);
        }
    }

    void test_Coerce()
    {
        hkFloat32 f5 = 5.25;
        hkReflect::FloatVar vf5(&f5);
        hkDouble64 f0 = 0;
        hkReflect::FloatVar vf0(&f0);

        hkBool b1 = 1;
        hkReflect::BoolVar vb1(&b1);
        bool b0 = 0;
        hkReflect::BoolVar vb0(&b0);

        int i61 = 61;
        hkReflect::IntVar vi61(&i61);

        hkStringPtr s11("11.25");
        hkReflect::StringVar vs11(&s11);

        hkStringPtr snull;
        hkReflect::StringVar vsnull(&snull);

        // convert to float
        {
            coerceTest( 5.25f, hkReflect::VarCoerce::floatFromFloat, vf5 );
            coerceTest( 5.25, hkReflect::VarCoerce::floatFromFloat, vf5 );
            coerceTest( 1.0f, hkReflect::VarCoerce::floatFromBool,  vb1);
            coerceTest( 1.0, hkReflect::VarCoerce::floatFromBool,  vb1);
            coerceTest( 0.0, hkReflect::VarCoerce::floatFromBool,  vb0);
            coerceTest( 61.0, hkReflect::VarCoerce::floatFromInt,  vi61);
            coerceTest( 11.25, hkReflect::VarCoerce::floatFromString,  vs11);
            coerceTest( 11.25, hkReflect::VarCoerce::floatFromString,  vsnull, false);
        }

        // convert to bool
        {
            coerceTest( true, hkReflect::VarCoerce::boolFromFloat, vf5 );
            coerceTest( false, hkReflect::VarCoerce::boolFromFloat, vf0 );
            coerceTest( true, hkReflect::VarCoerce::boolFromBool,  vb1);
            coerceTest( false, hkReflect::VarCoerce::boolFromBool,  vb0);
            coerceTest( true, hkReflect::VarCoerce::boolFromInt,  vi61);
            coerceTest( true, hkReflect::VarCoerce::boolFromString,  vs11);
            coerceTest( false, hkReflect::VarCoerce::boolFromString,  vsnull);
        }

        // convert to int
        {
            coerceTest( 5, hkReflect::VarCoerce::intFromFloat, vf5 );
            coerceTest( 0, hkReflect::VarCoerce::intFromFloat, vf0 );
            coerceTest( 1, hkReflect::VarCoerce::intFromBool,  vb1);
            coerceTest( 0, hkReflect::VarCoerce::intFromBool,  vb0);
            coerceTest( 61, hkReflect::VarCoerce::intFromInt,  vi61);
            coerceTest( 11, hkReflect::VarCoerce::intFromString,  vs11);
            coerceTest( -1, hkReflect::VarCoerce::intFromString,  vsnull, false);
        }

        {
            hkReflect::VarCoerce coerce;
            // check compilation fails for wrong signatures
            //coerce.allow<hkReflect::KIND_INT, hkReflect::KIND_FLOAT>(&hkReflect::VarCoerce::intFromInt);

            coerceTest2(coerce, 5.25, vf5);
            coerceTest2(coerce, 5, vf5, false); // mixed conversions fail by default
            coerceTest2(coerce, 61.0, vi61, false); // mixed conversions fail by default

            coerce.allow<hkReflect::KIND_FLOAT, hkReflect::KIND_INT>(&hkReflect::VarCoerce::floatFromInt);
            coerceTest2(coerce, 61.0, vi61); // float from int allowed
            coerceTest2(coerce, 5, vf5, false); // but not vice versa

            coerce.allow<hkReflect::KIND_INT, hkReflect::KIND_FLOAT>(&hkReflect::VarCoerce::intFromFloat);
            coerceTest2(coerce, 5, vf5);

            coerce.disallow(hkReflect::KIND_INT, hkReflect::KIND_FLOAT);
            coerceTest2(coerce, 5, vf5, false); //disallowed again
        }
    }

    struct AnyCloner : public UnitTest::Cloning::Cloner
    {
        virtual hkReflect::Var clone(const char* testName, const hkReflect::Var& root) HK_OVERRIDE
        {
            // Disable the warning on pointer copy
            m_any.setFromVar( root );
            return m_any.yieldOwnership();
        }
        virtual bool mustDeleteCopy() HK_OVERRIDE { return true; }
        hkReflect::Any m_any;
    };

    static void test_Any()
    {
        using namespace hkReflect;
        {
            {
                Any a0;
                HK_TEST(a0.containsObject() == false);
                a0.setFromObj( 10 );
                HK_TEST(a0.containsObject());
                a0.setFromObj( 11.1 );
                HK_TEST(a0.containsObject());
            }

            {
                VarTest::Foo foo(HK_NULL);
                Any a1 = Any::fromObj(foo);
                HK_TEST(a1.containsObject());
            }

            {
                VarTest::NoCopy nc;
                nc.m_ptr = hkRefNew<hkReferencedObject>(new hkReferencedObject);
                hkError::getInstance().setEnabled(0xa759f032, false);
                Any a2 = Any::fromObj(nc);
                hkError::getInstance().setEnabled(0xa759f032, true);
                VarTest::NoCopy* clone = a2.var().dynCast<VarTest::NoCopy>();
                HK_TEST(clone != HK_NULL);
                HK_TEST(clone->m_ptr == nc.m_ptr);
            }

            {
                VarTest::NoCopy nc;
                nc.m_ptr = hkRefNew<hkReferencedObject>(new hkReferencedObject);
                hkError::getInstance().setEnabled(0xa759f032, false);
                Any a2 = Any::fromObj(nc);
                hkError::getInstance().setEnabled(0xa759f032, true);
                VarTest::NoCopy* clone = a2.var().dynCast<VarTest::NoCopy>();
                HK_TEST(clone != HK_NULL);
                HK_TEST(clone->m_ptr == nc.m_ptr);
            }

            {
                hkRefPtr<hkReferencedObject> obj = hkRefNew<hkReferencedObject>(new hkReferencedObject);
                Any a3 = Any::fromObj(obj);
                HK_TEST_EQ(obj->getReferenceCount(), 2);
                a3.clear();
                HK_TEST_EQ(obj->getReferenceCount(), 1);
            }

            {
                VarTest::Bar bar(0);
                VarTest::Foo foo(&bar);
                Var fooVar(&foo);
                Any a4 = Any::fromVar(fooVar["property"]);
                HK_TEST_EQ(bar.getReferenceCount(), 3);
                PointerVar ptr = a4.var();
                if (HK_TEST(ptr.isValid()))
                {
                    HK_TEST_EQ(ptr.getValue().dynCast<VarTest::Bar>(), &bar);
                }
            }

            {
                int lhsValue = 20;
                Any lhsAny = Any::fromObj(lhsValue);
                ArrayVar lhsArrayVar(&lhsAny);

                int rhsValue = 10;
                Any rhsAny = Any::fromObj(rhsValue);
                ArrayVar rhsArrayVar(&rhsAny);

                HK_TEST(lhsArrayVar.spliceInto(0, 1, rhsArrayVar.getValue()).isSuccess());

                HK_TEST(lhsAny.containsObject());
                IntVar val = lhsAny.var();
                HK_TEST(val);
                HK_TEST(val.getValue().equals(rhsValue));

                lhsArrayVar.setArraySize(0);
                HK_TEST(!lhsAny.containsObject());
            }

            {
                hkArray<int> arr;
                const hkReflect::Type* const arrType = hkReflect::getType<decltype( arr )>();

                Var v(&arr);
                ArrayVar r = v;
                Any any0 = Any::fromObj(arr); // copy object
                Any any1 = Any::fromVar(v);   // copy Var content (base class Var)
                Any any2 = Any::fromVar(r);   // copy Var content (derived class ArrayVar)
                HK_TEST( (const hkReflect::Type*)any0.var().getType() == arrType );
                HK_TEST( (const hkReflect::Type*)any1.var().getType() == arrType );
                HK_TEST( (const hkReflect::Type*)any2.var().getType() == arrType ); // COM-3721
                any0.setFromObj(arr);
                any1.setFromVar(v);
                any2.setFromVar(r);
                HK_TEST( (const hkReflect::Type*)any0.var().getType() == arrType );
                HK_TEST( (const hkReflect::Type*)any1.var().getType() == arrType );
                HK_TEST( (const hkReflect::Type*)any2.var().getType() == arrType ); // COM-3721
            }

            {
                // Testing Any::stealFrom with internal storage

                // Both non-empty
                {
                    hkReflect::Any thief = hkReflect::Any::fromObj(1);
                    hkReflect::Any victim = hkReflect::Any::fromObj(2);
                    thief.stealFrom(victim);
                    int i = 2;
                    HK_TEST(thief.var().equals(&i));
                    HK_TEST(victim.containsObject() == false);
                    HK_TEST(thief.storesInplace());
                }
                // Empty thief
                {
                    hkReflect::Any thief;
                    hkReflect::Any victim = hkReflect::Any::fromObj(2);
                    thief.stealFrom(victim);
                    int i = 2;
                    HK_TEST(thief.var().equals(&i));
                    HK_TEST(victim.containsObject() == false);
                    HK_TEST(thief.storesInplace());
                }
                // Empty victim
                {
                    hkReflect::Any thief = hkReflect::Any::fromObj(2);
                    hkReflect::Any victim;
                    thief.stealFrom(victim);
                    HK_TEST(thief.containsObject() == false);
                    HK_TEST(victim.containsObject() == false);
                }
                // Both empty
                {
                    hkReflect::Any thief;
                    hkReflect::Any victim;
                    thief.stealFrom(victim);
                    HK_TEST(thief.containsObject() == false);
                    HK_TEST(victim.containsObject() == false);
                }

                // Testing Any::stealFrom with external storage
                const char data[64] = {};
                // Both non-empty
                {
                    hkReflect::Any thief = hkReflect::Any::fromObj(1);
                    hkReflect::Any victim = hkReflect::Any::fromObj(data);
                    thief.stealFrom(victim);
                    HK_TEST(thief.var().equals(&data));
                    HK_TEST(victim.containsObject() == false);
                    HK_TEST(thief.storesInplace() == false);
                }
                // Empty thief
                {
                    hkReflect::Any thief;
                    hkReflect::Any victim = hkReflect::Any::fromObj(data);
                    thief.stealFrom(victim);
                    HK_TEST(thief.var().equals(&data));
                    HK_TEST(victim.containsObject() == false);
                    HK_TEST(thief.storesInplace() == false);
                }
                // Empty victim
                {
                    hkReflect::Any thief = hkReflect::Any::fromObj(data);
                    hkReflect::Any victim;
                    thief.stealFrom(victim);
                    HK_TEST(thief.containsObject() == false);
                    HK_TEST(victim.containsObject() == false);
                }
                // Both empty
                {
                    hkReflect::Any thief;
                    hkReflect::Any victim;
                    thief.stealFrom(victim);
                    HK_TEST(thief.containsObject() == false);
                    HK_TEST(victim.containsObject() == false);
                }
            }
        }

        AnyCloner cloner;
        hkError::getInstance().setEnabled(0xa759f032, false);
        UnitTest::Cloning::TEST_MAIN_BREAK_HERE(cloner, UnitTest::Cloning::DISABLE_POINTERS);
        hkError::getInstance().setEnabled(0xa759f032, true);
    }

    static void test_VariantArray()
    {
        hkVariantArray array;
        hkReflect::ArrayVar arrayVar = hkReflect::Var(&array);

        array.allocate(10, hkReflect::getType<int>());
        for (int i = 0; i < 10; ++i)
        {
            array.setElement(i, i);
        }
        for (int i = 0; i < 10; ++i)
        {
            HK_TEST_EQ(array.getElement<int>(i), i);
        }

        int newElem = 42;
        HK_TEST(arrayVar.pushBack(&newElem).isSuccess());
        HK_TEST_EQ(arrayVar.getCount(), 11);
        HK_TEST_EQ(array.getElement<int>(10), 42);

        HK_TEST(arrayVar.removeAt(10).isSuccess());
        HK_TEST_EQ(arrayVar.getCount(), 10);

        float floatElem = 100.0f;
        HK_TEST(arrayVar.pushBack(&floatElem).isFailure());

        HK_TEST(arrayVar.clear().isSuccess());
        HK_TEST(arrayVar.pushBack(&floatElem).isSuccess());
        HK_TEST(arrayVar.getSubType()->equals<float>());

        hkReflect::ArrayValue intArr(&newElem, 1);
        HK_TEST(arrayVar.setValue(intArr).isSuccess());
        HK_TEST(arrayVar.getSubType()->equals<int>());
        HK_TEST_EQ(array.getElement<int>(0), 42);
    }

    static void test_charBuffer()
    {
        char buf[20];

        hkReflect::StringVar sv(&buf);

        // Set a simple value
        if (HK_TEST(sv.setValue("Hello").isSuccess()))
        {
            HK_TEST_EQ(&buf[0], "Hello");
        }

        // Null set does nothing but doesn't fail
        sv.setValue(NULL);

        // Setting a too-long value truncates
        HK_TEST(sv.setValue("This string is too long").isFailure());

    }

    int signOf(int x)
    {
        return (0 < x) - (x < 0);
    }

    static void test_compare()
    {
        // Different kinds, pairwise in the expected order.
        int x0 = 1;
        int x1 = 3;

        float v0 = 1.f;
        float v1 = 3.f;

        bool b0 = false;
        bool b1 = true;

        const char* str0 = "Hello Aoife";
        const char* str1 = "Hello Bob";

        char a0[] = { 1,2,3,4 };
        char a1[] = { 1,2,3,5,9 };

        VarTest::Bar bar[] = { VarTest::Bar(1), VarTest::Bar(2) };

        VarTest::Bar* barPtr0 = &bar[0];
        VarTest::Bar* barPtr1 = &bar[1];

        // None of these vars should compare equal.
        const hkReflect::Var differentVars[] =
        {
            hkReflect::Var(&x0),
            hkReflect::Var(&x1),
            hkReflect::Var(&v0),
            hkReflect::Var(&v1),
            hkReflect::Var(&b0),
            hkReflect::Var(&b1),
            hkReflect::Var(&str0),
            hkReflect::Var(&str1),
            hkReflect::Var(&a0),
            hkReflect::Var(&a1),
            hkReflect::Var(&bar[0]),
            hkReflect::Var(&bar[1]),
            hkReflect::Var(&barPtr0),
            hkReflect::Var(&barPtr1)
        };

        // Check anti-symmetry.
        for (int i = 0; i < HK_COUNT_OF(differentVars); ++i)
        {
            for (int j = 0; j < HK_COUNT_OF(differentVars); ++j)
            {
                const int ij = differentVars[i].compare(differentVars[j]);
                const int ji = differentVars[j].compare(differentVars[i]);
                HK_TEST(signOf(ij) == -signOf(ji));
            }
        }

        // Test transitivity.
        for (int i = 0; i < HK_COUNT_OF(differentVars); ++i)
        {
            for (int j = 0; j < HK_COUNT_OF(differentVars); ++j)
            {
                for (int k = 0; k < HK_COUNT_OF(differentVars); ++k)
                {
                    const int ij = differentVars[i].compare(differentVars[j]);
                    const int jk = differentVars[j].compare(differentVars[k]);
                    if (signOf(ij) == signOf(jk))
                    {
                        const int ik = differentVars[i].compare(differentVars[k]);
                        HK_TEST(signOf(ij) == signOf(ik));
                    }
                }
            }
        }

        // Check expected order
        // NOTE: This is not obligatory, but is useful for debugging.
        for (int i = 0; i < HK_COUNT_OF(differentVars) - 1; i += 2)
        {
            const int ii = differentVars[i].compare(differentVars[i + 1]);
            HK_TEST(ii < 0);
        }
    }
}

int vartests_main()
{
    test_RecordVar();
    test_specialMethods();
    test_ArrayVar();
    test_CompoundVar();
    test_VarOfVar();
    test_Coerce();
    test_Any();
    test_VariantArray();
    test_charBuffer();
    test_compare();

    return 0;
}

HK_TEST_REGISTER(vartests_main, "Fast", "Common/Test/UnitTest/Base/", __FILE__);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
