// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/UnitTest/Reflection/VarTest.h>

using namespace VarTest;

namespace
{

int declEqualityTest()
{
    {
        hkReflect::Decl a, b;
        HK_TEST( a == b );
    }
    {
        hkReflect::FieldDecl a, b;
        HK_TEST( a == b );
    }
    {
        hkReflect::PropertyFieldDecl a, b;
        HK_TEST( a == b );
    }
    {
        const hkReflect::Type * const barType = hkReflect::getType<Bar>();
        hkReflect::Decl empty;
        hkReflect::Decl barId = barType->findDecl("id");
        hkReflect::Decl barId_ = barType->findDecl("id");
        hkReflect::Decl barIdProp = barType->findDecl("propId");
        hkReflect::Decl barIdProp_ = barType->findDecl("propId");

        HK_TEST( empty != barId );
        HK_TEST( barId == barId_ );
        HK_TEST( barId != barIdProp );
        HK_TEST( barIdProp == barIdProp_ );
    }
    {
        const hkReflect::Type * const fooType = hkReflect::getType<Foo>();
        hkReflect::Decl empty;
        hkReflect::FieldDecl things = fooType->findDecl( "things" ).asField();
        hkReflect::FieldDecl things_ = fooType->findDecl( "things" ).asField();
        hkReflect::FieldDecl things2 = fooType->findDecl( "things2" ).asField();

        HK_TEST( empty != things );
        HK_TEST( things == things_ );
        HK_TEST( things != things2 );
    }
    {
        const hkReflect::Type * const fooType = hkReflect::getType<Foo>();
        hkReflect::Decl empty;
        hkReflect::DataFieldDecl things = fooType->findDecl( "things" ).asDataField();
        hkReflect::DataFieldDecl things_ = fooType->findDecl( "things" ).asDataField();
        hkReflect::DataFieldDecl things2 = fooType->findDecl( "things2" ).asDataField();

        HK_TEST( empty != things );
        HK_TEST( things == things_ );
        HK_TEST( things != things2 );
    }

    return 0;
}

}

int typetest_main()
{
    declEqualityTest();
    return 0;
}

HK_TEST_REGISTER(typetest_main, "Fast", "Common/Test/UnitTest/Base/", __FILE__);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
