// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/UnitTest/Reflection/TypeRegistryTest.h>
#include <Common/Base/Reflect/TypeReg/hkTypeReg.h>

#include <Common/Base/Container/Set/hkSet.h>
#include <Common/Base/Reflect/Builder/hkTypeBuilder.h>
#include <Common/Base/Container/Hash/hkHashMap.h>
#include <Common/Base/Reflect/Detail/hkTypeHasher.h>
#include <Common/Base/Serialize/hkSerialize.h>
#include <Common/Base/Reflect/TypeReg/Detail/hkTypeRegDetail.h>
#include <Common/Base/Serialize/Detail/hkSerializeDetail.h>
#include <Common/Base/Reflect/Util/hkReflectClone.h>

#if defined(HK_BUILDING_WITH_ENGINE)
#include <Common/NewBase/Reflection/Util/hkDynamicTypeManager.h>                
#endif

#define APPLY_TO_TYPE_NAMES(X) \
    X(MMM)\
    X(MAA)\
    X(MZZ)\
    X(MAZ)\
    X(AAB)\
    X(ABC)\
    X(BBB)\
    X(AAA)\
    X(CCC)\
    X(ABA)

#define TYPE_BUFFER_SYMBOL(Y) reg_TypeRegistryTest_##Y

#define TYPE_BUFFER_DECL(Y) \
    static hkReflect::Detail::TypeDataMax TYPE_BUFFER_SYMBOL(Y) HK_POSSIBLY_UNUSED;

#define TYPE_PTR(Y) \
    reinterpret_cast<hkReflect::Type*>(&TYPE_BUFFER_SYMBOL(Y))

APPLY_TO_TYPE_NAMES(TYPE_BUFFER_DECL)

#if defined(HK_BUILDING_WITH_ENGINE)
hkReflect::Type* createTestType(const char* fieldName, const hkReflect::Type* fieldType, const hkReflect::Type* parentType, bool addToRegistry)
{
    hkReflect::TypeBuilder builder;
    builder.beginRecord(HK_NULL, parentType);
    builder.addMember(fieldName, hkReflect::Decl::DECL_DATA_FIELD, fieldType);
    builder.addFlags(hkReflect::Type::TYPE_DYNAMIC);
    builder.addDeleteInfo();

    hkReflect::Type* type = builder.allocate(hkMemHeapAllocator());
    if (addToRegistry)
    {
        type = hkDynamicTypeManager::getInstance().addType(type, hkDynamicTypeManager::DELETE_TYPE_IF_DUPLICATE);
    }

    return type;
}
#endif

#define CREATE_TYPE(Y) \
{ \
    hkReflect::TypeBuilder builder; \
    builder.beginRecord(#Y, HK_NULL); \
    builder.addItem<hkReflect::Opt::INHERITANCE>(0); \
    builder.writeOnBuffer(&TYPE_BUFFER_SYMBOL(Y), sizeof(TYPE_BUFFER_SYMBOL(Y))); \
}

#define CREATE_TYPE_WITH_PARENT(Y, P) \
{ \
    hkReflect::TypeBuilder builder; \
    builder.beginRecord(#Y, TYPE_PTR(P)); \
    builder.addItem<hkReflect::Opt::INHERITANCE>(0); \
    builder.writeOnBuffer(&TYPE_BUFFER_SYMBOL(Y), sizeof(TYPE_BUFFER_SYMBOL(Y))); \
}

#define ADD_ENTRIES(Y) \
    typeRegistryAccess.add(TYPE_PTR(Y));
#define REMOVE_ENTRIES(Y) \
    typeRegistryAccess.remove(TYPE_PTR(Y));


#if 0
namespace TypeRegistryTest
{
    struct RegistrationEntryAccessor
    {
        static bool checkTree( const hkTypeRegistryAccess& typeRegistryAccess );
        static bool checkTree( const hkTypeRegistryEntry* root );
        static void checkList();
        static void checkParents();
        static void checkAfterRemoval( const hkTypeRegistryRWAccess& typeRegistryAccess );
    };

    bool RegistrationEntryAccessor::checkTree( const hkTypeRegistryAccess& typeRegistryAccess )
    {
        const hkTypeRegistryEntry* root = typeRegistryAccess.getTreeRoot();
        HK_TEST( root != HK_NULL );
        return checkTree( root );
    }

    bool RegistrationEntryAccessor::checkTree( const hkTypeRegistryEntry* root )
    {
        if ( root == HK_NULL )
        {
            return true;
        }

        if ( const hkTypeRegistryEntry* left = root->getLeft() )
        {
            if ( left->getType()->compare( root->getType() ) > 0 )
            {
                return false;
            }

            if ( !checkTree( left ) )
            {
                return false;
            }
        }

        if ( const hkTypeRegistryEntry* right = root->getRight() )
        {
            if ( right->getType()->compare( root->getType() ) < 0 )
            {
                return false;
            }

            if ( !checkTree( right ) )
            {
                return false;
            }
        }

        return true;
    }

    void RegistrationEntryAccessor::checkList()
    {
        // Check that the list has been sorted correctly.
        hkReflect::MutableTypeReg::Iterator prevIt;
        while ( prevIt.advance() )
        {
            hkReflect::MutableTypeReg::Iterator it( prevIt );
            while ( it.advance() )
            {
                if ( !HK_TEST( prevIt.current()->compare( it.current() ) < 0 ) )
                {
                    return;
                }
            }
        }
    }

    void RegistrationEntryAccessor::checkParents()
    {
        hkTypeRegistryIterator it;
        while ( it.advance() )
        {
            const hkReflect::Type* type = it.current();
            if ( type->isDecorator() )
            {
                continue;
            }

            hkSet<const hkReflect::Type*> parents;
            {
                const hkReflect::Type* curr = type->getParent();
                while ( curr )
                {
                    parents.insert( curr );
                    curr = curr->getParent();
                }
            }

            hkTypeRegistryIterator otherIt;
            while ( otherIt.advance() )
            {
                const hkReflect::Type* otherType = otherIt.current();
                if ( otherType->isDecorator() )
                {
                    continue;
                }
                bool typeIsOther = type->isA( otherType );
                if ( parents.contains( otherType ) || otherType == type )
                {
                    if ( !HK_TEST( typeIsOther ) )
                    {
                        return;
                    }
                }
                else if ( !HK_TEST( !typeIsOther ) )
                {
                    return;
                }
            }
        }
    }


    void RegistrationEntryAccessor::checkAfterRemoval( const hkTypeRegistryRWAccess& typeRegistryAccess )
    {
#if 0
        typeRegistryAccess.remove( TYPE_PTR( ABA ) );
        checkTree( typeRegistryAccess );
        checkList();
        checkParents();
        typeRegistryAccess.remove( TYPE_PTR( AAA ) );
        typeRegistryAccess.remove( TYPE_PTR( CCC ) );
        checkTree( typeRegistryAccess );
        checkList();
        checkParents();
        typeRegistryAccess.remove( TYPE_PTR( AAB ) );
        typeRegistryAccess.remove( TYPE_PTR( ABC ) );
        typeRegistryAccess.remove( TYPE_PTR( BBB ) );
        checkTree( typeRegistryAccess );
        checkList();
        checkParents();
        typeRegistryAccess.remove( TYPE_PTR( MMM ) );
        typeRegistryAccess.remove( TYPE_PTR( MAA ) );
        typeRegistryAccess.remove( TYPE_PTR( MZZ ) );
        typeRegistryAccess.remove( TYPE_PTR( MAZ ) );
        checkTree( typeRegistryAccess );
        checkList();
        checkParents();
        // Try to re-add.
        APPLY_TO_TYPE_NAMES( ADD_ENTRIES )
            checkTree( typeRegistryAccess );
        checkList();
        checkParents();
        APPLY_TO_TYPE_NAMES( REMOVE_ENTRIES )
#endif
    }
}
#endif

namespace
{
    template<typename T>
    bool testGetTypeFromName(const hkReflect::TypeReg* typeRegistryAccess)
    {
        const hkReflect::Type* type = hkReflect::getType<T>();
        const hkReflect::Type* foundType = typeRegistryAccess->typeFromName(type->getName());
        return type == foundType;
    }

    template<typename T>
    bool testGetTypeFromFullName( const hkReflect::TypeReg* typeRegistryAccess )
    {
        const hkReflect::Type* type = hkReflect::getType<T>();
        hkStringBuf buf;
        const hkReflect::Type* foundType = typeRegistryAccess->typeFromName( type->getFullName(buf) );
        return type == foundType;
    }

    template<typename T>
    bool testGetTypeFromType(const hkReflect::TypeReg* typeRegistryAccess)
    {
        const hkReflect::Type* type = hkReflect::getType<T>();
        const hkReflect::Type* foundType = typeRegistryAccess->typeFromType(type);
        return type == foundType;
    }

    template<typename T>
    bool testGetTypeNonTemplate( const hkReflect::TypeReg* typeRegistryAccess )
    {
        return testGetTypeFromName<T>( typeRegistryAccess ) && testGetTypeFromFullName<T>( typeRegistryAccess ) && testGetTypeFromType<T>( typeRegistryAccess );
    }

    template<typename T>
    bool testGetTypeTemplate( const hkReflect::TypeReg* typeRegistryAccess )
    {
        return !testGetTypeFromName<T>( typeRegistryAccess ) && testGetTypeFromFullName<T>( typeRegistryAccess ) && testGetTypeFromType<T>( typeRegistryAccess );
    }
}

#if defined(HK_BUILDING_WITH_ENGINE)
static void testTypeReplacement_callback(const hkReflect::MutableTypeReg::TypesChangedFuncArgs& args, void* cbData)
{
    int iteration = *static_cast<int*>(cbData);
    if(iteration == 0)
    {
        HK_TEST(args.m_added.getSize() == 1 && args.m_replaced.getSize() == 0 && args.m_removed.getSize() == 0);

        const hkReflect::Type* addedType = args.m_added[0];
        HK_TEST(addedType->getNumFields() == 1);
        HK_TEST(hkString::strCmp(addedType->getField(0).getName(), "a0") == 0);
    }
    else if(iteration == 1)
    {
        HK_TEST(args.m_added.getSize() == 0 && args.m_replaced.getSize() == 1 && args.m_removed.getSize() == 0);

        const hkReflect::Type* oldType = args.m_replaced[0].m_old;
        HK_TEST(oldType->getNumFields() == 1);
        HK_TEST(hkString::strCmp(oldType->getField(0).getName(), "a0") == 0);

        const hkReflect::Type* newType = args.m_replaced[0].m_new;
        HK_TEST(newType->getNumFields() == 1);
        HK_TEST(hkString::strCmp(newType->getField(0).getName(), "a1") == 0);
    }
}

static void testTypeReplacement()
{
    hkReflect::MutableTypeReg* typeReg = hkReflect::getTypeReg();

    int i = -1;
    auto changedSubscription = typeReg->subscribeForChange(&testTypeReplacement_callback, &i);

    for(i = 0; i < 2; i++)
    {
        hkReflect::TypeBuilder builder;
        builder.beginRecord("TestReplacementType", HK_NULL);

        hkStringBuf memberName;
        memberName.format("a{}", i);
        builder.addMember(memberName, hkReflect::Decl::DECL_FIELD, hkReflect::getType<hkInt32>().get());
        builder.addFlags(hkReflect::Type::TYPE_DYNAMIC);

        builder.addDeleteInfo();
        hkReflect::Type* type = builder.allocate(hkMemHeapAllocator());

        hkArray<const hkReflect::Type*> typeArr;
        typeArr.pushBack(type);

        hkArray<char> out;
        hkSerialize::Save().contentsPtr(&typeArr, &out);

        hkSerialize::Detail::CloneToRegistered cloneCallback;

        hkReflect::Var var = hkSerialize::Load().withCloneCallback(&cloneCallback).toVar(out);
        var.destroy();

        hk::DeleteTypeInfo::deleteType(type);
    }

    hkReflect::Type* loadedType = const_cast<hkReflect::Type*>(typeReg->typeFromName("TestReplacementType"));
    typeReg->remove(loadedType);
    hk::DeleteTypeInfo::deleteType(loadedType);

    changedSubscription.unsubscribe();
}

#endif

int typeRegistryTest_main()
{
    typedef hkArray<const hkReflect::Type*> Array;
    Array empty;
    typedef hkHashMap<hkUint32, Array > Map;
    Map map1;
    hkReflect::TypeHasher hasher;
    int numTypes = 0;
    for(hkReflect::TypeRegIterator typeit(hkReflect::getTypeReg()); typeit.advance(); )
    {
        const hkReflect::Type* type = typeit.current();
        numTypes += 1;
        // content hash
        {
            hkUint32 h = hasher.calc(type);
            Map::Iterator i = map1.findOrInsertKey(h, empty);
            map1.getValue(i).pushBack(type);

            hkReflect::TypeHasher clean;
            hkUint32 hc = clean.calc(type);
            HK_TEST2(h == hc, "Type hash caching is broken");
        }
    }

    for(Map::Iterator it(map1.getIterator()); map1.isValid(it); it = map1.getNext(it))
    {
        const Array& a = map1.getValue(it);
        HK_TEST2(a.getSize() == 1, "Type hash collision");
    }

#if defined(HK_BUILDING_WITH_ENGINE)
    // keep the old one alive
    hkRefPtr<hkDynamicTypeManager> oldMgr = hkDynamicTypeManager::getInstancePtr();

    // create temp
    hkRefPtr<hkDynamicTypeManager> tempMgr = hkRefNew<hkDynamicTypeManager>(new hkDynamicTypeManager(hkReflect::getTypeReg()));
    hkDynamicTypeManager::replaceInstanceAndAddReference(tempMgr);

    // run tests
    hkReflect::Type* B = createTestType("dataB", hkReflect::getType<int>(), HK_NULL, true);
    hkReflect::Type* Bcopy = createTestType("dataB", hkReflect::getType<int>(), HK_NULL, false);
    hkReflect::Type* A = createTestType("dataA", hkReflect::getType<int>(), Bcopy, false);

    hkArray<char> arr;
    hkSerialize::Save().contentsPtr(A, &arr);
    hkReflect::Var loaded = hkSerialize::Load().toVar(arr);
    hkReflect::Type* dtype = loaded.dynCast<hkReflect::Type>();
    const hkReflect::Type* Bfile = dtype->getParent();
    HK_TEST2( Bfile == B, "deserialized type equal to existed in registry");

    hkReflect::FieldDecl decl = dtype->findDecl("dataA").asField();
    hkReflect::Type* fieldA = const_cast<hkReflect::Type*>(decl.getType().get());
    const hkReflect::Type* managedFieldA = hkDynamicTypeManager::getInstance().typeFromType(fieldA);
    HK_TEST2(managedFieldA == HK_NULL, "we don't store field type in dynamic types manager unless they added explicitly");

    hkDynamicTypeManager::getInstance().removeType(dtype);
    hkDynamicTypeManager::getInstance().removeType(B);

    hk::DeleteTypeInfo::deleteType(A);
    hk::DeleteTypeInfo::deleteType(Bcopy);

    // reset back to old
    hkDynamicTypeManager::replaceInstanceAndAddReference(oldMgr);

    testTypeReplacement();
#endif

#if 0
    // create this before the hkBuiltinTypeRegistry, which creates a Read only access.
    // We can nest read only inside read write, but not the other way around.
    hkTypeRegistryRWAccess typeRegistryAccess;

    // Create several simple reflected types with distinct names.

    CREATE_TYPE(MMM);
    CREATE_TYPE(MAA);
    CREATE_TYPE(MZZ);
    CREATE_TYPE(MAZ);
    CREATE_TYPE_WITH_PARENT(AAB, MMM);
    CREATE_TYPE_WITH_PARENT(ABC, MAA);
    CREATE_TYPE_WITH_PARENT(BBB, MZZ);
    CREATE_TYPE_WITH_PARENT(AAA, AAB);
    CREATE_TYPE_WITH_PARENT(CCC, ABC);
    CREATE_TYPE_WITH_PARENT(ABA, AAA);

    APPLY_TO_TYPE_NAMES(ADD_ENTRIES)

    TypeRegistryTest::RegistrationEntryAccessor::checkList();
    HK_TEST(TypeRegistryTest::RegistrationEntryAccessor::checkTree(typeRegistryAccess));
    TypeRegistryTest::RegistrationEntryAccessor::checkParents();
#endif

    auto typeRegistryAccess = hkReflect::getTypeReg();

    HK_TEST(testGetTypeNonTemplate<int>(typeRegistryAccess));
    HK_TEST(testGetTypeNonTemplate<TypeRegistryTest::Ref>(typeRegistryAccess));

    HK_TEST(testGetTypeTemplate<int*>(typeRegistryAccess));

    HK_TEST(testGetTypeTemplate< hkArray<int> >(typeRegistryAccess));
    HK_TEST(testGetTypeTemplate< hkArray<TypeRegistryTest::Ref> >(typeRegistryAccess));
    HK_TEST(testGetTypeTemplate< hkArray<int>::Temp >(typeRegistryAccess));
    HK_TEST(testGetTypeTemplate< hkRefPtr<TypeRegistryTest::Ref> >(typeRegistryAccess));
    HK_TEST(testGetTypeTemplate< hkArrayView< hkArray<TypeRegistryTest::Ref> > >(typeRegistryAccess));

    HK_TEST(testGetTypeTemplate< TypeRegistryTest::Template<TypeRegistryTest::Ref> >(typeRegistryAccess));
    HK_TEST(testGetTypeTemplate< TypeRegistryTest::Template<TypeRegistryTest::Ref*> >(typeRegistryAccess));
    HK_TEST(testGetTypeTemplate< TypeRegistryTest::Template< hkRefPtr<TypeRegistryTest::Ref> > >(typeRegistryAccess));

    HK_TEST(testGetTypeTemplate< TypeRegistryTest::Template<TypeRegistryTest::Ref[10]> >(typeRegistryAccess));

    

    typedef hkEnum<TypeRegistryTest::A, hkUint8> EnumA;
    typedef hkEnum<TypeRegistryTest::B, hkUint8> EnumB;

    HK_TEST(testGetTypeTemplate< EnumA >(typeRegistryAccess));
    HK_TEST(testGetTypeTemplate< EnumB >(typeRegistryAccess));

    const hkReflect::Type* typedefType = typeRegistryAccess->typeFromName("TypeRegistryTest::TypedefTest");
    const hkReflect::Type* typedefChildType = hkReflect::getType<TypeRegistryTest::TypedefChild>();
    HK_TEST(typedefType->extendsOrEquals<TypeRegistryTest::Ref>());
    HK_TEST(typedefChildType->extendsOrEquals<TypeRegistryTest::Ref>());
    HK_TEST(typedefChildType->extendsOrEquals(typedefType));

    HK_TEST( typeRegistryAccess->typeFromName( "int*" ) == hkReflect::getType<int*>() );

    typedef TypeRegistryTest::Template< TypeRegistryTest::Ref*, 42 > ResType;

    HK_TEST( typeRegistryAccess->typeFromName( "TypeRegistryTest::Template< TypeRegistryTest::Ref*, 42 >" ) == hkReflect::getType< ResType >() );

    HK_TEST( typeRegistryAccess->typeFromName( "" ) == nullptr );
    HK_TEST( typeRegistryAccess->typeFromName( "SomeNonExistingType" ) == nullptr );
    HK_TEST( typeRegistryAccess->typeFromName( "hkReferencedObject<int>" ) == nullptr );

    {
        UnitTest::Raii::CaptureThreadLogOutput capture;
        HK_TEST( typeRegistryAccess->typeFromName( "<Invalid>" ) == nullptr );
        HK_TEST( typeRegistryAccess->typeFromName( "Invalid<" ) == nullptr );
        HK_TEST( typeRegistryAccess->typeFromName( "Invalid>" ) == nullptr );
        HK_TEST( typeRegistryAccess->typeFromName( "Invalid<>Invalid" ) == nullptr );
        HK_TEST( typeRegistryAccess->typeFromName( "Invalid<Invalid>>" ) == nullptr );
        HK_TEST( typeRegistryAccess->typeFromName( "Invalid<Invalid<>" ) == nullptr );
        HK_TEST( typeRegistryAccess->typeFromName( "Invalid<,,a,>" ) == nullptr );
    }

#if 0
    TypeRegistryTest::RegistrationEntryAccessor::checkAfterRemoval(typeRegistryAccess);
#endif
    return 0;
}

HK_TEST_REGISTER(typeRegistryTest_main, "Fast", "Common/Test/UnitTest/Base/", __FILE__);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
