// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/UnitTest/Reflection/VarTest.h>

using namespace VarTest;

static void testHashValue()
{
    {
        hkReflect::TypeName a("hkReferencedObject", nullptr);
        hkReflect::TypeName b(hkReflect::getType<hkReferencedObject>());
        HK_TEST(hkHash::hkHashValue(a) == hkHash::hkHashValue(b));
    }

    {
        hkMemoryAllocator& allocator = *hkMemHeapAllocator();

        hkReflect::Template* templ = hkReflect::Template::create(2, allocator);

        hkReflect::Template::Parameter* param1 = const_cast<hkReflect::Template::Parameter*>(templ->getParam(0));
        param1->m_kindAndName = "tT";
        param1->m_storage = (hkUlong)hkReflect::getType<hkStringPtr>().get();

        hkReflect::Template::Parameter* param2 = const_cast<hkReflect::Template::Parameter*>(templ->getParam(1));
        param2->m_kindAndName = "tAllocator";
        param2->m_storage = (hkUlong)hkReflect::getType<hkContainerHeapAllocator>().get();

        hkReflect::TypeName a("hkArray", templ);

        hkReflect::TypeName b(hkReflect::getType<hkArray<hkStringPtr> >());

        HK_TEST(hkHash::hkHashValue(a) == hkHash::hkHashValue(b));

        templ->destroy(allocator);
    }
}

int typeNameTest_main()
{
    testHashValue();
    return 0;
}

HK_TEST_REGISTER(typeNameTest_main, "Fast", "Common/Test/UnitTest/Base/", __FILE__);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
