// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/Reflect/Builder/hkTypeBuilder.h>
#include <Common/Base/Reflect/Core/Detail/hkCallableDetail.h>
#include <Common/Base/Reflect/Builder/hkRecordLayout.h>
#include <Common/Base/Reflect/Util/hkReflectUtil.h>
#include <Common/Base/Reflect/Core/Detail/hkReflectTypeDetail.h>
#include <Common/Base/UnitTest/Reflection/VarTest.h>

int typeBuilderTest_main()
{
    {
        // create a floating point type
        float* defaultVal = hkMemHeapCreate<float>(10.0f);
        hk::Default* defaultAttr = reinterpret_cast<hk::Default*>(defaultVal);

        float* maxVal = hkMemHeapCreate<float>(20.0f);
        hk::AbsMax* attr = reinterpret_cast<hk::AbsMax*>(maxVal);

        hkReflect::Type* type = HK_NULL;
        {
            hkReflect::TypeBuilder builder;
            builder.beginDerived(hkReflect::getType<float>());

            builder.addItem<hkReflect::Opt::NAME>("FloatTest");

            builder.addAttribute(hkReflect::Var(attr));
            builder.addAttribute(hkReflect::Var(defaultAttr));

            builder.addDeleteInfo();

            type = builder.allocate(hkMemHeapAllocator());
        }

        HK_TEST(type->asFloat());
        HK_TEST(type->asFloat()->getFormat() == hkReflect::Format::Value::create(hkReflect::Format::OfFloat<float>::Value));
        HK_TEST(type->getParent() == hkReflect::getType<float>());

        HK_TEST(hkString::strCmp(type->getName(), "FloatTest") == 0);
        HK_TEST(type->getImpl() == &hkReflect::Detail::FloatImplN<float>::s_instance);

        hkReflect::Var defaultVar = type->getDefault();
        HK_TEST(defaultVar.getAddress() == defaultVal);

        const hk::AbsMax* foundAttr = type->findAttribute<hk::AbsMax>();
        if (HK_TEST(foundAttr))
        {
            hkReflect::FloatVar maxVar = foundAttr->get(hkReflect::getType<float>());
            if (HK_TEST(maxVar))
            {
                HK_TEST(maxVar.getValue() == *maxVal);
            }
        }

        HK_TEST(hk::DeleteTypeInfo::deleteType(type));
    }

    {
        hkReflect::Type* type = HK_NULL;
        {
            hkUint32 mask = hkReflect::Opt::FORMAT | hkReflect::Opt::IMPL | hkReflect::Opt::NAME | hkReflect::Opt::SIZE_ALIGN;

            hkReflect::TypeBuilder builder;
            builder.beginShallowClone(hkReflect::getType<float>(), mask);
            builder.addDeleteInfo();

            type = builder.allocate(hkMemHeapAllocator());
        }

        HK_TEST(type->asFloat());
        HK_TEST(type->asFloat()->getFormat() == hkReflect::Format::Value::create(hkReflect::Format::OfFloat<float>::Value));

        HK_TEST(!type->extendsOrEquals<float>());

        HK_TEST(hk::DeleteTypeInfo::deleteType(type));
    }

    {
        const hkReflect::Detail::CallInvoker invoker1 = { reinterpret_cast<hkReflect::Detail::CallInvoker::InvokeFunc>(1), reinterpret_cast<void*>(2) };
        const hkReflect::Detail::CallInvoker invoker2 = { reinterpret_cast<hkReflect::Detail::CallInvoker::InvokeFunc>(2), reinterpret_cast<void*>(4) };
        const hkReflect::Detail::CallInvoker invoker3 = { reinterpret_cast<hkReflect::Detail::CallInvoker::InvokeFunc>(3), reinterpret_cast<void*>(6) };
        const hkReflect::Detail::CallInvoker invoker4 = { reinterpret_cast<hkReflect::Detail::CallInvoker::InvokeFunc>(4), reinterpret_cast<void*>(8) };
        // create a record type
        hkReflect::RecordType* type = HK_NULL;
        {
            hkReflect::TypeBuilder builder;
            builder.beginRecord("", HK_NULL);

            builder.addMember("floatField", 0, hkReflect::getType<float>());
            builder.addMember("vecField", 0, hkReflect::getType<hkVector4>());
            builder.addProperty("strProperty", hkReflect::getType<const char*>());
            builder.addMember("arrayField", 0, hkReflect::getType< hkArray<int> >());
            builder.addMember("ptrField", hkReflect::RecordType::TYPE_NOT_SERIALIZABLE, hkReflect::getType<int*>());

            hkArray<const hkReflect::Type*> params;
            builder.addMethod("method1", invoker1, hkReflect::getType<int>(), params);

            params.pushBack(hkReflect::getType< hkRefPtr<hkReferencedObject> >());
            builder.addMethod("method2", invoker2, hkReflect::getType<void>(), params);

            builder.addConstructor("constructor", invoker3, params);

            params.pushBack(hkReflect::getType<hkVector4>());
            builder.addFunction("static", invoker4, hkReflect::getType<hkVector4>(), params);

            builder.addDeleteInfo();

            type = builder.allocate(hkMemHeapAllocator())->asRecord();
            HK_TEST(type);
        }

        HK_TEST(type->getNumFields() == 5);
        HK_TEST(hkReflectUtil::getRecordNumFieldsWithAncestors(type) == 5);

        HK_TEST(hkString::strCmp(type->getField(0).getName(), "floatField") == 0);
        HK_TEST(hkString::strCmp(type->getField(1).getName(), "vecField") == 0);
        HK_TEST(hkString::strCmp(type->getField(2).getName(), "arrayField") == 0);
        HK_TEST(hkString::strCmp(type->getField(3).getName(), "ptrField") == 0);
        HK_TEST(hkString::strCmp(type->getField(4).getName(), "strProperty") == 0);

        HK_TEST(type->getField(0).getType()->extendsOrEquals<float>());
        HK_TEST(type->getField(1).getType()->extendsOrEquals<hkVector4>());
        HK_TEST(type->getField(2).getType()->extendsOrEquals< hkArray<int> >());
        HK_TEST(type->getField(3).getType()->extendsOrEquals<int*>());
        HK_TEST(type->getField(4).getType()->extendsOrEquals<const char*>());

        typedef hkReflect::Detail::CallableSignatureTraits<float, hkVector4, hkArray<int>, int*> TestTypeTraits;

        hkReflect::RecordLayout::recomputeNative(type);
        HK_TEST(type->getAlignOf() == TestTypeTraits::ALIGN);
        HK_TEST(type->getSizeOf() == HK_NEXT_MULTIPLE_OF(TestTypeTraits::ALIGN, TestTypeTraits::OFFSET4));

        HK_TEST(type->getField(0).getOffset() == TestTypeTraits::OFFSET0);
        HK_TEST(type->getField(1).getOffset() == TestTypeTraits::OFFSET1);
        HK_TEST(type->getField(2).getOffset() == TestTypeTraits::OFFSET2);
        HK_TEST(type->getField(3).getOffset() == TestTypeTraits::OFFSET3);
        HK_TEST(type->getField(4).getOffset() == 0);

        const hkReflect::Detail::Functions* functions = hkReflect::TypeDetail::getDeclaredFunctions(type);
        HK_TEST(functions);
        HK_TEST(functions->getNumMethods() == 2);
        HK_TEST(functions->getNumConstructors() == 1);
        HK_TEST(functions->getNumFunctions() == 1);

        const hkReflect::NamedCallable* method1 =
            hkString::strCmp(functions->getUnboundMethod(0)->getName(), "method1") == 0 ?
            functions->getUnboundMethod(0) : functions->getUnboundMethod(1);
        const hkReflect::NamedCallable* method2 = method1 == functions->getUnboundMethod(0) ?
            functions->getUnboundMethod(1) : functions->getUnboundMethod(0);

        const hkReflect::NamedCallable* constructor = functions->getConstructor(0);
        const hkReflect::NamedCallable* staticFunction = functions->getFunction(0);

        HK_TEST(hkString::strCmp(method1->getName(), "method1") == 0);
        HK_TEST(hkString::strCmp(method2->getName(), "method2") == 0);
        HK_TEST(hkString::strCmp(constructor->getName(), "constructor") == 0);
        HK_TEST(hkString::strCmp(staticFunction->getName(), "static") == 0);

        HK_TEST(method1->getCallInvoker() == invoker1 );
        HK_TEST(method2->getCallInvoker() == invoker2 );
        HK_TEST(constructor->getCallInvoker() == invoker3 );
        HK_TEST(staticFunction->getCallInvoker() == invoker4 );

        HK_TEST(method1->getObjectType());
        HK_TEST(method2->getObjectType());
        HK_TEST(!constructor->getObjectType());
        HK_TEST(!staticFunction->getObjectType());

        HK_TEST(method1->getReturnType() == hkReflect::getType<int>());
        HK_TEST(method2->getReturnType() == hkReflect::getType<void>());
        HK_TEST(constructor->getReturnType() == type);
        HK_TEST(staticFunction->getReturnType() == hkReflect::getType<hkVector4>());

        HK_TEST(method1->getNumParams() == 0);
        HK_TEST(method2->getNumParams() == 1);
        HK_TEST(constructor->getNumParams() == 1);
        HK_TEST(staticFunction->getNumParams() == 2);

        typedef hkReflect::Detail::CallableSignatureTraits<hkRefPtr<hkReferencedObject>, hkVector4> TestTypeTraits2;
        HK_TEST(staticFunction->getParamBufAlignment() == TestTypeTraits2::ALIGN);
        HK_TEST(staticFunction->getParamBufSize() == TestTypeTraits2::OFFSET1 + sizeof(hkVector4));

        HK_TEST(staticFunction->getParamOffset(0) == TestTypeTraits2::OFFSET0);
        HK_TEST(staticFunction->getParamOffset(1) == TestTypeTraits2::OFFSET1);

        HK_TEST(staticFunction->getParamType(0) == hkReflect::getType< hkRefPtr<hkReferencedObject> >());
        HK_TEST(staticFunction->getParamType(1) == hkReflect::getType< hkVector4 >());

        HK_TEST(hk::DeleteTypeInfo::deleteType(type));
    }

    // Check combinations of equals/extendsOrEquals between builtin and dynamic types
    {
        const hkReflect::Type* builtinRecord = hkReflect::getType<hkReferencedObject>();
        const hkReflect::Type* builtinPtr = hkReflect::getType<hkReferencedObject*>();
        hkReflect::Type* dynamicRecord;
        hkReflect::Type* dynamicPtr;

        hkArray<hkReflect::Type*> typesToDelete;

        {
            hkReflect::TypeBuilder builder;
            builder.beginRecord("DynamicRecord", HK_NULL);
            builder.addDeleteInfo();

            dynamicRecord = builder.allocate(hkMemHeapAllocator());
            typesToDelete.pushBack(dynamicRecord);
        }

        {
            hkReflect::TypeBuilder builder;
            builder.beginPointer(dynamicRecord);
            builder.addDeleteInfo();

            dynamicPtr = builder.allocate(hkMemHeapAllocator());
            typesToDelete.pushBack(dynamicPtr);
        }

        // Builtin types have Opt::INHERITANCE
        HK_TEST(hkReflect::TypeDetail::getInheritance(builtinRecord) != HK_NULL);
        HK_TEST(hkReflect::TypeDetail::getInheritance(builtinPtr) != HK_NULL);

        // Dynamic types don't have Opt::INHERITANCE
        HK_TEST(hkReflect::TypeDetail::getInheritance(dynamicRecord) == HK_NULL);
        HK_TEST(hkReflect::TypeDetail::getInheritance(dynamicPtr) == HK_NULL);

        // Check equality between these four types
        const hkReflect::Type* baseTypes[] = { builtinRecord, dynamicRecord, builtinPtr, dynamicPtr };
        for (int i = 0; i < HK_COUNT_OF(baseTypes); ++i)
        {
            for (int j = 0; j < HK_COUNT_OF(baseTypes); ++j)
            {
                if (i == j)
                {
                    HK_TEST(baseTypes[i]->equals(baseTypes[j]));
                    HK_TEST(baseTypes[j]->equals(baseTypes[i]));
                    HK_TEST(baseTypes[i]->extendsOrEquals(baseTypes[j]));
                    HK_TEST(baseTypes[j]->extendsOrEquals(baseTypes[i]));
                }
                else
                {
                    HK_TEST(!baseTypes[i]->equals(baseTypes[j]));
                    HK_TEST(!baseTypes[j]->equals(baseTypes[i]));
                    HK_TEST(!baseTypes[i]->extendsOrEquals(baseTypes[j]));
                    HK_TEST(!baseTypes[j]->extendsOrEquals(baseTypes[i]));
                }
            }
        }

        hkReflect::Type* decoratedTypes[4];

        for (int i = 0; i < HK_COUNT_OF(baseTypes); ++i)
        {
            hkReflect::TypeBuilder builder;
            builder.beginDerived(baseTypes[i]);
            builder.addDeleteInfo();

            decoratedTypes[i] = builder.allocate(hkMemHeapAllocator());
            typesToDelete.pushBack(decoratedTypes[i]);
        }

        for (int i = 0; i < HK_COUNT_OF(baseTypes); ++i)
        {
            for (int j = 0; j < HK_COUNT_OF(decoratedTypes); ++j)
            {
                if (i == j)
                {
                    // Decorated types are indistinguishable from non-decorated ones
                    HK_TEST(baseTypes[i]->equals(decoratedTypes[j]));
                    HK_TEST(decoratedTypes[j]->equals(baseTypes[i]));
                    HK_TEST(baseTypes[i]->extendsOrEquals(decoratedTypes[j]));
                    HK_TEST(decoratedTypes[j]->extendsOrEquals(baseTypes[i]));
                }
                else
                {
                    HK_TEST(!baseTypes[i]->equals(decoratedTypes[j]));
                    HK_TEST(!decoratedTypes[j]->equals(baseTypes[i]));
                    HK_TEST(!baseTypes[i]->extendsOrEquals(decoratedTypes[j]));
                    HK_TEST(!decoratedTypes[j]->extendsOrEquals(baseTypes[i]));
                }
            }
        }

        // Can't properly derive from pointer type, so only test against the first 2 base types
        hkReflect::Type* derivedTypes[2];

        for (int i = 0; i < HK_COUNT_OF(derivedTypes); ++i)
        {
            hkReflect::TypeBuilder builder;
            builder.beginRecord("Derived", baseTypes[i]);
            builder.addDeleteInfo();

            derivedTypes[i] = builder.allocate(hkMemHeapAllocator());
            typesToDelete.pushBack(derivedTypes[i]);
        }


        for (int i = 0; i < HK_COUNT_OF(baseTypes); ++i)
        {
            for (int j = 0; j < HK_COUNT_OF(derivedTypes); ++j)
            {
                if (i == j)
                {
                    // Properly derived types aren't equal but extendsOrEquals must work
                    HK_TEST(!baseTypes[i]->equals(derivedTypes[j]));
                    HK_TEST(!derivedTypes[j]->equals(baseTypes[i]));
                    HK_TEST(!decoratedTypes[i]->equals(derivedTypes[j]));
                    HK_TEST(!derivedTypes[j]->equals(decoratedTypes[i]));
                    HK_TEST(!baseTypes[i]->extendsOrEquals(derivedTypes[j]));
                    HK_TEST(derivedTypes[j]->extendsOrEquals(baseTypes[i]));
                    HK_TEST(!decoratedTypes[i]->extendsOrEquals(derivedTypes[j]));
                    HK_TEST(derivedTypes[j]->extendsOrEquals(decoratedTypes[i]));   // Decorators are ignored, so derived[j] "extends" decorated[i]
                }
                else
                {
                    HK_TEST(!baseTypes[i]->equals(derivedTypes[j]));
                    HK_TEST(!derivedTypes[j]->equals(baseTypes[i]));
                    HK_TEST(!decoratedTypes[i]->equals(derivedTypes[j]));
                    HK_TEST(!derivedTypes[j]->equals(decoratedTypes[i]));
                    HK_TEST(!baseTypes[i]->extendsOrEquals(derivedTypes[j]));
                    HK_TEST(!derivedTypes[j]->extendsOrEquals(baseTypes[i]));
                    HK_TEST(!decoratedTypes[i]->extendsOrEquals(derivedTypes[j]));
                    HK_TEST(!derivedTypes[j]->extendsOrEquals(decoratedTypes[i]));
                }
            }
        }

        for (int i = 0; i < typesToDelete.getSize(); ++i)
        {
            HK_TEST(hk::DeleteTypeInfo::deleteType(typesToDelete[i]));
        }
    }

    // Test implicit special methods
    {
        hkReflect::Detail::TypeDataMax buffer;
        hkReflect::TypeBuilder builder;
        builder.beginRecord( "Rec", HK_NULL );
        builder.addMember( "a", 0, hkReflect::getType<int>() );
        builder.addMember( "b", 0, hkReflect::getType<float>() );
        builder.addImplicitSpecialMethods();
        auto type = builder.writeOnBuffer( &buffer, sizeof( buffer ) );
        HK_TEST( hkReflect::TypeDetail::hasTrivialMethod<hkReflect::Opt::DEF_CONSTRUCTOR>( type ) );
        HK_TEST( hkReflect::TypeDetail::hasTrivialMethod<hkReflect::Opt::COPY_CONSTRUCTOR>( type ) );
        HK_TEST( hkReflect::TypeDetail::hasTrivialMethod<hkReflect::Opt::COPY_ASSIGNMENT>( type ) );
        HK_TEST( hkReflect::TypeDetail::hasTrivialMethod<hkReflect::Opt::DESTRUCTOR>( type ) );
    }
    {
        hkReflect::Detail::TypeDataMax buffer;
        hkReflect::TypeBuilder builder;
        builder.beginRecord( "Rec", hkReflect::getType<VarTest::NonCopyable>() );
        builder.addMember( "a", 0, hkReflect::getType<hkStringPtr>() );
        builder.addMember( "b", 0, hkReflect::getType<float>() );
        builder.addImplicitSpecialMethods();
        auto type = builder.writeOnBuffer( &buffer, sizeof( buffer ) );
        HK_TEST( hkReflect::TypeDetail::hasImplicitMethod<hkReflect::Opt::DEF_CONSTRUCTOR>( type ) );
        HK_TEST( hkReflect::TypeDetail::hasDeletedMethod<hkReflect::Opt::COPY_CONSTRUCTOR>( type ) );
        HK_TEST( hkReflect::TypeDetail::hasDeletedMethod<hkReflect::Opt::COPY_ASSIGNMENT>( type ) );
        HK_TEST( hkReflect::TypeDetail::hasImplicitMethod<hkReflect::Opt::DESTRUCTOR>( type ) );
    }

    return 0;
}

HK_TEST_REGISTER(typeBuilderTest_main, "Fast", "Common/Test/UnitTest/Base/", __FILE__);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
