// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT    : COMMON
// VISIBILITY : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/Reflect/Core/Detail/hkReflectTypeDetail.h>
#include <Common/Base/Reflect/Util/hkReflectAny.h>

int reflectedDetailCoercionTest_main()
{
    {
        // same exact type

        int value = 123;

        hkReflect::Var var(&value);

        hkReflect::Any temp;
        hkReflect::QualType refType = hkReflect::getType<int>();
        hkReflect::Var varResult;
        HK_TEST(hkReflect::Detail::coerceArgIfNecessary(refType, var, varResult, temp).isSuccess());

        HK_TEST(!temp.containsObject());
        HK_TEST(var.equals(varResult));
    }

    {
        // different types, same kind

        hkInt16 value = 123;

        hkReflect::Var var(&value);

        hkReflect::Any temp;
        hkReflect::QualType refType = hkReflect::getType<hkInt32>();
        hkReflect::Var varResult;
        HK_TEST(hkReflect::Detail::coerceArgIfNecessary(refType, var, varResult, temp).isSuccess());

        HK_TEST(temp.containsObject());
        HK_TEST(var.equals(varResult));
    }

    {
        // from type to reference to same type

        hkInt16 value = 123;

        hkReflect::Var var(&value);

        hkReflect::Any temp;
        hkReflect::QualType refType = hkReflect::getType<hkReflect::Detail::Reference<hkInt16>>();
        hkReflect::Var varResult;
        HK_TEST(hkReflect::Detail::coerceArgIfNecessary(refType, var, varResult, temp).isSuccess());

        HK_TEST(temp.containsObject());
        hkReflect::Detail::Reference<hkInt16>* ref = varResult.upCast<hkReflect::Detail::Reference<hkInt16>>();
        HK_TEST(ref && ref->get() == value);
    }

    {
        // from type to pointer to same type

        hkInt16 value = 123;

        hkReflect::Var var(&value);

        hkReflect::Any temp;
        hkReflect::QualType refType = hkReflect::getType<hkInt16*>();
        hkReflect::Var varResult;
        HK_TEST(hkReflect::Detail::coerceArgIfNecessary(refType, var, varResult, temp).isSuccess());

        HK_TEST(temp.containsObject());
        hkInt16** ref = varResult.upCast<hkInt16*>();
        HK_TEST(ref && *ref && **ref== value);
    }

    {
        // conversion accross kinds should fail

        int value = 123;

        hkReflect::Var var(&value);

        hkReflect::Any temp;
        hkReflect::QualType refType = hkReflect::getType<float>();
        hkReflect::Var varResult;
        HK_TEST(hkReflect::Detail::coerceArgIfNecessary(refType, var, varResult, temp).isFailure());

        HK_TEST(!temp.containsObject());
        HK_TEST(!varResult.isValid());
    }

    {
        // conversion from array to array view

        hkArray<int> value;
        value.pushBack(123);
        value.pushBack(234);

        hkReflect::Var var(&value);

        hkReflect::Any temp;
        hkReflect::QualType refType = hkReflect::getType<hkArrayView<int>>();
        hkReflect::Var varResult;
        HK_TEST(hkReflect::Detail::coerceArgIfNecessary(refType, var, varResult, temp).isSuccess());

        HK_TEST(temp.containsObject());
        hkArrayView<int>* view = varResult.upCast<hkArrayView<int>>();
        HK_TEST(view && (*view)[0] == value[0] && (*view)[1] == value[1]);
    }

    return 0;
}

HK_TEST_REGISTER(reflectedDetailCoercionTest_main, "Fast", "Common/Test/UnitTest/Base/", __FILE__);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
