// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT    : COMMON
// VISIBILITY : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/Reflect/Core/Detail/hkCallableDetail.h>

namespace
{
    void VoidFunc1(short a)
    {
        HK_TEST(a == 123);
    }
    int IntFunc1(short a)
    {
        return a * 2;
    }
    void VoidFunc2(short a, int b)
    {
        HK_TEST(a == 123);
        HK_TEST(b == 234);
    }
    int IntFunc2(short a, int b)
    {
        return a * b;
    }
}

int reflectedDetailCallableTest_main()
{
    {
        short param1 = 123;

        hkReflect::Callable callableVoidFunc1 = hkReflect::makeCallable(VoidFunc1);
        hkReflect::Call(&callableVoidFunc1).withArg(hkReflect::Var(&param1));

        int result = 0;

        hkReflect::Callable callableIntFunc1 = hkReflect::makeCallable(IntFunc1);
        hkReflect::Call(&callableIntFunc1).into(hkReflect::Var(&result)).withArg(hkReflect::Var(&param1));

        HK_TEST(result == param1 * 2);
    }

    {
        hkReflect::Callable callableVoidFunc2 = hkReflect::makeCallable(VoidFunc2);

        struct Param2
        {
            short a;
            int b;
        } param2 = { 123, 234 };

        const hkArrayView<void> rawArgs(&param2, sizeof(param2));

        hkReflect::Call(&callableVoidFunc2).withArgsRaw(rawArgs);

        int result = 0;

        hkReflect::Callable callableIntFunc2 = hkReflect::makeCallable(IntFunc2);
        hkReflect::Call(&callableIntFunc2).into(hkReflect::Var(&result)).withArgsRaw(rawArgs);

        HK_TEST(result == param2.a * param2.b);
    }

    return 0;
}

HK_TEST_REGISTER(reflectedDetailCallableTest_main, "Fast", "Common/Test/UnitTest/Base/", __FILE__);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
