// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/Reflect/ReflectFile/hkReflectFileParser.h>
#include <stdio.h>

int ReflectFileTest_main()
{
    hkReflectFileParser::Error errorMessage;
    {
        const char testEmptyInput[] = "";

        hkReflectFileParser parser( testEmptyInput, "testEmptyInput" );

        errorMessage.clear();
        HK_TEST( parser.parse( errorMessage ).isSuccess() );
        HK_TEST( !errorMessage.isSet() );
    }

    {
        const char testWrongSyntax1[] = "someField;";

        hkReflectFileParser parser( testWrongSyntax1, "testWrongSyntax1" );
        errorMessage.clear();
        HK_TEST( parser.parse( errorMessage ).isFailure() );
        HK_TEST( errorMessage.isSet() );
    }

    {
        const char testWrongSyntax2[] = "hkAdditionalAttributesFor";

        hkReflectFileParser parser( testWrongSyntax2, "testWrongSyntax2" );
        errorMessage.clear();
        HK_TEST( parser.parse( errorMessage ).isFailure() );
        HK_TEST( errorMessage.isSet() );
    }

    {
        const char testWrongSyntax3[] = "hkAdditionalAttributesFor(";

        hkReflectFileParser parser( testWrongSyntax3, "testWrongSyntax3" );
        errorMessage.clear();
        HK_TEST( parser.parse( errorMessage ).isFailure() );
        HK_TEST( errorMessage.isSet() );
    }

    {
        const char testWrongSyntax4[] = "hkAdditionalAttributesFor(someClass";

        hkReflectFileParser parser( testWrongSyntax4, "testWrongSyntax4" );
        errorMessage.clear();
        HK_TEST( parser.parse( errorMessage ).isFailure() );
        HK_TEST( errorMessage.isSet() );
    }

    {
        const char testWrongSyntax5[] = "hkAdditionalAttributesFor()";

        hkReflectFileParser parser( testWrongSyntax5, "testWrongSyntax5" );
        errorMessage.clear();
        HK_TEST( parser.parse( errorMessage ).isFailure() );
        HK_TEST( errorMessage.isSet() );
    }

    {
        const char testWrongSyntax6[] = "hkAdditionalAttributesFor(someClass)";

        hkReflectFileParser parser( testWrongSyntax6, "testWrongSyntax6" );
        errorMessage.clear();
        HK_TEST( parser.parse( errorMessage ).isFailure() );
        HK_TEST( errorMessage.isSet() );
    }

    {
        const char testWrongSyntax7[] =
            "hkAdditionalAttributesFor(someClass)\n"
            "{";

        hkReflectFileParser parser( testWrongSyntax7, "testWrongSyntax7" );
        errorMessage.clear();
        HK_TEST( parser.parse( errorMessage ).isFailure() );
        HK_TEST( errorMessage.isSet() );
    }

    {
        const char testCorrect1[] =
            "hkAdditionalAttributesFor(hk::someClass)\n"
            "{}";

        hkReflectFileParser parser( testCorrect1, "testCorrect1" );
        errorMessage.clear();
        HK_TEST( parser.parse( errorMessage ).isSuccess() );
        HK_TEST( !errorMessage.isSet() );
        if (HK_TEST_EQ( parser.getClassDeclarations().getSize(), 1 ))
        {
            HK_TEST_EQ( parser.getClassDeclarations()[0].m_name, "hk::someClass" );
            HK_TEST_EQ( parser.getClassDeclarations()[0].m_properties.getSize(), 0 );
        }
    }

    {
        const char testWrongSyntax8[] =
            "hkAdditionalAttributesFor(someClass) hk::Ui_Group \n"
            "{}";

        hkReflectFileParser parser( testWrongSyntax8, "testWrongSyntax8" );
        errorMessage.clear();
        HK_TEST( parser.parse( errorMessage ).isFailure() );
        HK_TEST( errorMessage.isSet() );
    }

    {
        const char testWrongSyntax9[] =
            "hkAdditionalAttributesFor(someClass) hk::Ui_Group \n"
            "{\n"
            "  hk::Ui_Group(\"test\")\n"
            "  {\n"
            "  }\n"
            "}\n";

        hkReflectFileParser parser( testWrongSyntax9, "testWrongSyntax9" );
        errorMessage.clear();
        HK_TEST( parser.parse( errorMessage ).isFailure() );
        HK_TEST( errorMessage.isSet() );
    }

    hkDisableError allowGlobalNew(0xf0c34ded); // Tests below call new[] char

    {
        const char testCorrect2[] =
            "hkAdditionalAttributesFor(someOtherClass) \n"
            "{\n"
            "  group hk::Ui_Group(\"test\")\n"
            "  {\n"
            "    someField1;\n"
            "    someField2 hk::Ui_Expert;\n"
            "    someField3 hk::Ui_Slider(0,1);\n"
            "    someField4 hk::Ui_Slider(0,1), hk::Ui_Expert;\n"
            "  }\n"
            "}\n";

        hkReflectFileParser parser( testCorrect2, "testCorrect2" );
        errorMessage.clear();
        HK_TEST( parser.parse( errorMessage ).isSuccess() );
        HK_TEST( !errorMessage.isSet() );
        if (HK_TEST_EQ( parser.getClassDeclarations().getSize(), 1 ))
        {
            HK_TEST_EQ( parser.getClassDeclarations()[0].m_name, "someOtherClass" );
            if (HK_TEST_EQ( parser.getClassDeclarations()[0].m_properties.getSize(), 4 ))
            {
                const hkArray<hkReflectFileParser::Property>& properties = parser.getClassDeclarations()[0].m_properties;

                HK_TEST_EQ( properties[0].m_name, "someField1" );
                if (HK_TEST_EQ( properties[0].m_attributes.getSize(), 2 ))
                {
                    HK_TEST_EQ( properties[0].m_attributes[0].m_name, "hk::Ui_Group" );
                    HK_TEST_EQ( properties[0].m_attributes[0].m_arguments, "\"test\"" );
                    HK_TEST_EQ( properties[0].m_attributes[1].m_name, "hk::Ui_Order" );
                    HK_TEST_EQ( properties[0].m_attributes[1].m_arguments, "1" );
                }

                HK_TEST_EQ( properties[1].m_name, "someField2" );
                if (HK_TEST_EQ( properties[1].m_attributes.getSize(), 3 ))
                {
                    HK_TEST_EQ( properties[1].m_attributes[0].m_name, "hk::Ui_Expert" );
                    HK_TEST_EQ( properties[1].m_attributes[0].m_arguments.getSize(), 0 );
                    HK_TEST_EQ( properties[1].m_attributes[1].m_name, "hk::Ui_Group" );
                    HK_TEST_EQ( properties[1].m_attributes[1].m_arguments, "\"test\"" );
                    HK_TEST_EQ( properties[1].m_attributes[2].m_name, "hk::Ui_Order" );
                    HK_TEST_EQ( properties[1].m_attributes[2].m_arguments, "2" );
                }

                HK_TEST_EQ( properties[2].m_name, "someField3" );
                if (HK_TEST_EQ( properties[2].m_attributes.getSize(), 3 ))
                {
                    HK_TEST_EQ( properties[2].m_attributes[0].m_name, "hk::Ui_Slider" );
                    HK_TEST_EQ( properties[2].m_attributes[0].m_arguments, "0,1" );
                    HK_TEST_EQ( properties[2].m_attributes[1].m_name, "hk::Ui_Group" );
                    HK_TEST_EQ( properties[2].m_attributes[1].m_arguments, "\"test\"" );
                    HK_TEST_EQ( properties[2].m_attributes[2].m_name, "hk::Ui_Order" );
                    HK_TEST_EQ( properties[2].m_attributes[2].m_arguments, "3" );
                }

                HK_TEST_EQ( properties[3].m_name, "someField4" );
                if (HK_TEST_EQ( properties[3].m_attributes.getSize(), 4 ))
                {
                    HK_TEST_EQ( properties[3].m_attributes[0].m_name, "hk::Ui_Slider" );
                    HK_TEST_EQ( properties[3].m_attributes[0].m_arguments, "0,1" );
                    HK_TEST_EQ( properties[3].m_attributes[1].m_name, "hk::Ui_Expert" );
                    HK_TEST_EQ( properties[3].m_attributes[1].m_arguments.getSize(), 0 );
                    HK_TEST_EQ( properties[3].m_attributes[2].m_name, "hk::Ui_Group" );
                    HK_TEST_EQ( properties[3].m_attributes[2].m_arguments, "\"test\"" );
                    HK_TEST_EQ( properties[3].m_attributes[3].m_name, "hk::Ui_Order" );
                    HK_TEST_EQ( properties[3].m_attributes[3].m_arguments, "4" );
                }
            }
        }
    }

    {
        const char testCorrect3[] =
            "hkAdditionalAttributesFor(someOtherClass) \n"
            "{\n"
            "  var1;\n"
            "  var2 hk::Ui_Order(4);\n"
            "  var3;"
            "}\n";

        hkReflectFileParser parser( testCorrect3, "testCorrect3" );
        errorMessage.clear();
        HK_TEST( parser.parse( errorMessage ).isSuccess() );
        HK_TEST( !errorMessage.isSet() );
        if (HK_TEST_EQ( parser.getClassDeclarations().getSize(), 1 ))
        {
            HK_TEST_EQ( parser.getClassDeclarations()[0].m_name, "someOtherClass" );
            if (HK_TEST_EQ( parser.getClassDeclarations()[0].m_properties.getSize(), 3 ))
            {
                const hkArray<hkReflectFileParser::Property>& properties = parser.getClassDeclarations()[0].m_properties;

                HK_TEST_EQ( properties[0].m_name, "var1" );
                if (HK_TEST_EQ( properties[0].m_attributes.getSize(), 1 ))
                {
                    HK_TEST_EQ( properties[0].m_attributes[0].m_name, "hk::Ui_Order" );
                    HK_TEST_EQ( properties[0].m_attributes[0].m_arguments, "1" );
                }

                HK_TEST_EQ( properties[1].m_name, "var2" );
                if (HK_TEST_EQ( properties[1].m_attributes.getSize(), 1 ))
                {
                    HK_TEST_EQ( properties[1].m_attributes[0].m_name, "hk::Ui_Order" );
                    HK_TEST_EQ( properties[1].m_attributes[0].m_arguments, "4" );
                }

                HK_TEST_EQ( properties[2].m_name, "var3" );
                if (HK_TEST_EQ( properties[2].m_attributes.getSize(), 1 ))
                {
                    HK_TEST_EQ( properties[2].m_attributes[0].m_name, "hk::Ui_Order" );
                    HK_TEST_EQ( properties[2].m_attributes[0].m_arguments, "3" );
                }
            }
        }
    }

    {
        const char testCorrect4[] =
            "hkAdditionalAttributesFor(someOtherClass) \n"
            "{\n"
            "  group hk::Ui_Group(\"group1\")\n"
            "  {\n"
            "    var1;\n"
            "    group hk::Ui_Group(\"group2\")\n"
            "    {\n"
            "      var2;\n"
            "    }\n"
            "  }\n"
            "}\n";

        hkReflectFileParser parser( testCorrect4, "testCorrect4" );
        errorMessage.clear();
        HK_TEST( parser.parse( errorMessage ).isSuccess() );
        HK_TEST( !errorMessage.isSet() );
        if (HK_TEST_EQ( parser.getClassDeclarations().getSize(), 1 ))
        {
            HK_TEST_EQ( parser.getClassDeclarations()[0].m_name, "someOtherClass" );
            if (HK_TEST_EQ( parser.getClassDeclarations()[0].m_properties.getSize(), 2 ))
            {
                const hkArray<hkReflectFileParser::Property>& properties = parser.getClassDeclarations()[0].m_properties;

                HK_TEST_EQ( properties[0].m_name, "var1" );
                if (HK_TEST_EQ( properties[0].m_attributes.getSize(), 2 ))
                {
                    HK_TEST_EQ( properties[0].m_attributes[0].m_name, "hk::Ui_Group" );
                    HK_TEST_EQ( properties[0].m_attributes[0].m_arguments, "\"group1\"" );
                    HK_TEST_EQ( properties[0].m_attributes[1].m_name, "hk::Ui_Order" );
                    HK_TEST_EQ( properties[0].m_attributes[1].m_arguments, "1" );
                }

                HK_TEST_EQ( properties[1].m_name, "var2" );
                if (HK_TEST_EQ( properties[1].m_attributes.getSize(), 3 ))
                {
                    HK_TEST_EQ( properties[1].m_attributes[0].m_name, "hk::Ui_Group" );
                    HK_TEST_EQ( properties[1].m_attributes[0].m_arguments, "\"group1\"" );
                    HK_TEST_EQ( properties[1].m_attributes[1].m_name, "hk::Ui_Group" );
                    HK_TEST_EQ( properties[1].m_attributes[1].m_arguments, "\"group2\"" );
                    HK_TEST_EQ( properties[1].m_attributes[2].m_name, "hk::Ui_Order" );
                    HK_TEST_EQ( properties[1].m_attributes[2].m_arguments, "2" );
                }
            }
        }
    }

    {
        const char testWrongSyntax10[] =
            "hkAdditionalAttributesFor(someOtherClass) \n"
            "{\n"
            "  var1\n"
            "}\n";

        hkReflectFileParser parser( testWrongSyntax10, "testWrongSyntax10" );
        errorMessage.clear();
        HK_TEST( parser.parse( errorMessage ).isFailure() );
        HK_TEST( errorMessage.isSet() );
    }

    {
        const char testCorrect5[] =
            "hkAdditionalAttributesFor(classA) \n"
            "{\n"
            "  var1;\n"
            "}\n"
            "\n"
            "hkAdditionalAttributesFor(classB) \n"
            "{\n"
            "  var2;\n"
            "}\n";

        hkReflectFileParser parser( testCorrect5, "testCorrect5" );
        errorMessage.clear();
        HK_TEST( parser.parse( errorMessage ).isSuccess() );
        HK_TEST( !errorMessage.isSet() );
        if (HK_TEST_EQ( parser.getClassDeclarations().getSize(), 2 ))
        {
            HK_TEST_EQ( parser.getClassDeclarations()[0].m_name, "classA" );
            if (HK_TEST_EQ( parser.getClassDeclarations()[0].m_properties.getSize(), 1 ))
            {
                HK_TEST_EQ( parser.getClassDeclarations()[0].m_properties[0].m_name, "var1" );
            }

            HK_TEST_EQ( parser.getClassDeclarations()[1].m_name, "classB" );
            if (HK_TEST_EQ( parser.getClassDeclarations()[1].m_properties.getSize(), 1 ))
            {
                HK_TEST_EQ( parser.getClassDeclarations()[1].m_properties[0].m_name, "var2" );
            }
        }
    }

    {
        const char testCorrect6[] =
            "hkAdditionalAttributesFor(classA) \n"
            "{\n"
            "  group hk::Ui_Expert, hk::Ui_Group(\"test\")\n"
            "  {\n"
            "    var1;\n"
            "  }\n"
            "}\n";

        hkReflectFileParser parser( testCorrect6, "testCorrect6" );
        errorMessage.clear();
        HK_TEST( parser.parse( errorMessage ).isSuccess() );
        HK_TEST( !errorMessage.isSet() );
        if (HK_TEST_EQ( parser.getClassDeclarations().getSize(), 1 ))
        {
            HK_TEST_EQ( parser.getClassDeclarations()[0].m_name, "classA" );
            if (HK_TEST_EQ( parser.getClassDeclarations()[0].m_properties.getSize(), 1 ))
            {
                const hkArray<hkReflectFileParser::Property>& properties = parser.getClassDeclarations()[0].m_properties;

                HK_TEST_EQ( properties[0].m_name, "var1" );
                if (HK_TEST_EQ( properties[0].m_attributes.getSize(), 3 ))
                {
                    HK_TEST_EQ( properties[0].m_attributes[0].m_name, "hk::Ui_Expert" );
                    HK_TEST_EQ( properties[0].m_attributes[0].m_arguments.getSize(), 0 );
                    HK_TEST_EQ( properties[0].m_attributes[1].m_name, "hk::Ui_Group" );
                    HK_TEST_EQ( properties[0].m_attributes[1].m_arguments, "\"test\"" );
                    HK_TEST_EQ( properties[0].m_attributes[2].m_name, "hk::Ui_Order" );
                    HK_TEST_EQ( properties[0].m_attributes[2].m_arguments, "1" );
                }
            }
        }
    }

    {
        // Test string with a UTF8 character and utf8 BOM
        const char testUtf8[] =
            "\xef\xbb\xbf"\
            "hkAdditionalAttributesFor(classA) \n"
            "{\n"\
            "  var1 hk::Ui_UnitOfMeasure(\"b\xC2\xB0""a\");"\
            "}\n";

        hkReflectFileParser parser( testUtf8, "testUtf8" );
        errorMessage.clear();
        HK_TEST( parser.parse( errorMessage ).isSuccess() );
        HK_TEST( !errorMessage.isSet() );
        if (HK_TEST_EQ( parser.getClassDeclarations().getSize(), 1 ))
        {
            HK_TEST_EQ( parser.getClassDeclarations()[0].m_name, "classA" );
            if (HK_TEST_EQ( parser.getClassDeclarations()[0].m_properties.getSize(), 1 ))
            {
                const hkArray<hkReflectFileParser::Property>& properties = parser.getClassDeclarations()[0].m_properties;

                HK_TEST_EQ( properties[0].m_name, "var1" );
                if (HK_TEST_EQ( properties[0].m_attributes.getSize(), 2 ))
                {
                    HK_TEST_EQ( properties[0].m_attributes[0].m_name, "hk::Ui_UnitOfMeasure" );
                    HK_TEST_EQ( properties[0].m_attributes[0].m_arguments, "\"b\\xC2\\xB0\"\"a\"" );
                    HK_TEST_EQ( properties[0].m_attributes[1].m_name, "hk::Ui_Order" );
                    HK_TEST_EQ( properties[0].m_attributes[1].m_arguments, "1" );
                }
            }
        }
    }

    return 0;
}

HK_TEST_REGISTER( ReflectFileTest_main, "Fast", "Common/Test/UnitTest/Base/", __FILE__ );

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
