// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Reflect/Util/hkFieldSetterDetail.h>

namespace UnitTest
{
    struct SetterTest
    {
        HK_DECLARE_CLASS(SetterTest, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

        SetterTest()
            : m_intSet(0)
            , m_stringSet(0)
            , m_pointerSet(0)
            , m_nestedSet(0)
            , m_arraySet(0)
            , m_arrayRecSet(0)
            , m_arrayArraySet(0) {}

        void init();
        bool operator==(const SetterTest& rhs) const;

        void setInt(int i)
        {
            m_int = i;
            ++m_intSet;
        }

        int m_intSet;
        int m_int HK_ATTR(hk::FieldSetter);

        void setString(const char* s)
        {
            m_string = s;
            ++m_stringSet;
        }

        int m_stringSet;
        hkStringPtr m_string HK_ATTR(hk::FieldSetter);

        struct Foo : public hkReferencedObject
        {
            HK_DECLARE_CLASS(Foo, New, Reflect, BypassCtor);
            HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

            Foo(int i) : m_int(i) {}
            bool operator==(const Foo& rhs) const { return m_int == rhs.m_int; }
            bool operator!=(const Foo& rhs) const { return !operator==(rhs); }
            int m_int;
        };

        Foo& pointed() const { return *m_pointer; }

        void setPointer(Foo* p)
        {
            m_pointer = p;
            ++m_pointerSet;
        }

        int m_pointerSet;
        hkRefPtr<Foo> m_pointer HK_ATTR(hk::FieldSetter);

        struct TwiceNested
        {
            HK_DECLARE_CLASS(TwiceNested, New, Reflect);
            HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

            TwiceNested() : m_int(0), m_float(0) {}
            int m_int;
            float m_float;
        };

        struct Nested
        {
            HK_DECLARE_CLASS(Nested, New, Reflect);
            HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

            Nested() : m_int(0), m_float(0), m_twiceNestedSet(false) {}

            int m_int;
            float m_float;
            TwiceNested m_plain;

            void setTwiceNested(const TwiceNested& n)
            {
                m_twiceNested = n;
                ++m_twiceNestedSet;
            }

            int m_twiceNestedSet;
            static hkReflect::Detail::SetterRecordImpl s_impl;
            TwiceNested m_twiceNested HK_ATTR(hk::FieldSetter);

            hkArray<int> m_array;

            
        };

        void setNested(Nested n)
        {
            m_nested = n;
            ++m_nestedSet;
        }

        int m_nestedSet;
        Nested m_nested HK_ATTR(hk::FieldSetter);

        void setArray(hkArray<int> a)
        {
            m_array = a;
            ++m_arraySet;
        }

        int m_arraySet;
        hkArray<int> m_array HK_ATTR(hk::FieldSetter);

        void setArrayRec(const hkArray<Nested>& a)
        {
            m_arrayRec = a;
            ++m_arrayRecSet;
        }

        int m_arrayRecSet;
        hkArray<Nested> m_arrayRec HK_ATTR(hk::FieldSetter);

        void setArrayArray(const hkArray< hkArray<int> >& a)
        {
            m_arrayArray = a;
            ++m_arrayArraySet;
        }

        int m_arrayArraySet;
        hkArray< hkArray<int> > m_arrayArray HK_ATTR(hk::FieldSetter);
    };



    
#if 0
    // We have two types of colorHSV of different sizes to try to catch incorrectly sized buffers.

    struct LittleStruct
    {
        HK_DECLARE_CLASS(LittleStruct, New, Reflect, BypassCtor);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
        LittleStruct() : m_a('a'), m_b('b') {}
        char m_a;
        char m_b;
    };

    struct BiggerStruct
    {
        HK_DECLARE_CLASS(BiggerStruct, New, Reflect, BypassCtor);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
        BiggerStruct() : m_pad0(0), m_pad1(1) {}
        hkUlong m_pad0;
        LittleStruct m_little;
        hkUlong m_pad1;
    };

    struct ColorHSV
    {
        HK_DECLARE_CLASS(ColorHSV, New, Reflect, BypassCtor);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
        ColorHSV() {}
        ColorHSV(hkReal h, hkReal s, hkReal v) : m_h(h), m_s(s), m_v(v) {}
        bool operator==(const ColorHSV& c) const { return m_h==c.m_h && m_s==c.m_s && m_v==c.m_v; }
        hkReal m_h;
        hkReal m_s;
        hkReal m_v;
    };

    struct ColorHSV2
    {
        HK_DECLARE_CLASS(ColorHSV2, New, Reflect, BypassCtor);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
        ColorHSV2() { hkMemUtil::memSet(m_pad,-1, sizeof(m_pad)); }
        ColorHSV2(hkReal h, hkReal s, hkReal v) : m_h(h), m_s(s), m_v(v) { hkMemUtil::memSet(m_pad,-1, sizeof(m_pad)); }
        bool operator==(const ColorHSV2& c) const { return m_h==c.m_h && m_s==c.m_s && m_v==c.m_v; }
        hkReal m_h;
        hkReal m_s;
        hkReal m_v;
        hkUlong m_pad[10];
    };

    struct ColorRGB
    {
        HK_DECLARE_CLASS(ColorRGB, New, Reflect, BypassCtor);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
        ColorRGB() : m_pad(0) { }
        ColorRGB(hkReal r, hkReal g, hkReal b) : m_pad(0), m_r(r), m_g(g), m_b(b), m_a(0) {}
        bool operator==(const ColorRGB& c) const { return m_r==c.m_r && m_g==c.m_g && m_b==c.m_b; }

        int m_pad;
        hkReal m_r;
        hkReal m_g;
        hkReal m_b;
        hkReal m_a;

            // pretend negative rgb values are hsv for this test
        ColorHSV getHSV() const
        {
            return ColorHSV(-m_r, -m_g, -m_b);
        }
        bool setHSV(ColorHSV c)
        {
            m_pad = 0;
            m_r=-c.m_h; m_g=-c.m_s; m_b=-c.m_v;
            m_a = 0;
            return true;
        }
        HK_PROPERTY(hsv, getHSV, setHSV);

        ColorHSV2 getHSV2() const
        {
            return ColorHSV2(-m_r, -m_g, -m_b);
        }
        bool setHSV2(ColorHSV2 c)
        {
            m_r=-c.m_h; m_g=-c.m_s; m_b=-c.m_v;
            return true;
        }
        HK_PROPERTY(hsv2, getHSV2, setHSV2);
    };

    struct PropertyContainer
    {
        HK_DECLARE_CLASS(PropertyContainer, New, Reflect, BypassCtor);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
        PropertyContainer() {}

        hkUint32 m_pad;
        hkUint32 m_colorStore;
        BiggerStruct m_biggerStore;

        // non-valuetype property

        ColorRGB getColor() const
        {
            unsigned r = (m_colorStore >> 16) &0xff;
            unsigned g = (m_colorStore >>  8) &0xff;
            unsigned b = (m_colorStore >>  0) &0xff;
            return ColorRGB( hkReal(r), hkReal(g), hkReal(b) );
        }
        bool setColor(ColorRGB c)
        {
            hkReal r = hkMath::clamp(c.m_r,0,255);
            hkReal g = hkMath::clamp(c.m_g,0,255);
            hkReal b = hkMath::clamp(c.m_b,0,255);
            m_colorStore = (unsigned(r)<<16) | (unsigned(g)<<8) | unsigned(b);
            return true;
        }
        HK_PROPERTY(color, getColor, setColor);


        BiggerStruct getBigger() const
        {
            return m_biggerStore;
        }
        bool setBigger(BiggerStruct b)
        {
            m_biggerStore = b;
            return true;
        }
        HK_PROPERTY(bigger, getBigger, setBigger);
    };
#endif
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
